/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.console.SMTblCellEditor;
import com.sun.symon.base.client.console.SMTblSelectionInfo;
import com.sun.symon.base.console.views.CvToolTip;
import com.sun.symon.base.console.views.table.CvTblBooleanEditor;
import com.sun.symon.base.console.views.table.CvTblCell;
import com.sun.symon.base.console.views.table.CvTblDateEditor;
import com.sun.symon.base.console.views.table.CvTblFloatEditor;
import com.sun.symon.base.console.views.table.CvTblIntEditor;
import com.sun.symon.base.console.views.table.CvTblStringEditor;
import com.sun.symon.base.console.views.table.CvTblTableColumn;
import com.sun.symon.base.console.views.table.CvTblTableEvent;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;

public class CvCommonTable
extends JTable
implements MouseListener,
KeyListener,
MouseMotionListener {
    protected int visibleLines = -1;
    protected Vector tableEventListeners = new Vector();
    protected int oldRow = -1;
    protected int oldColumn = -1;
    protected int oldSelectRow = -1;
    protected int oldSelectColumn = -1;
    protected int selectedCol = -1;
    protected boolean headerSelected = false;
    protected boolean headerSelectAllowed = false;
    protected Color alternateBackground = Color.white;
    protected Icon acknowledgedIcon = null;
    protected Hashtable defaultEditors = new Hashtable();
    protected SMTblSelectionInfo tblContextSelection = null;

    public CvCommonTable() {
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.0f);
        this.setAutoCreateColumnsFromModel(false);
        this.setGridColor(Color.black);
        this.setShowGrid(true);
        this.addMouseListener(this);
        this.addKeyListener(this);
        this.addMouseMotionListener(this);
        this.setBorder(new LineBorder(Color.black, 1));
        this.setRowSelectionAllowed(false);
        this.setupDefaultEditors();
    }

    public void addTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.addElement(cvTblTableEventListener);
    }

    public void clearSelection() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        listSelectionModel.clearSelection();
        listSelectionModel2.clearSelection();
        this.selectedCol = -1;
        this.tblContextSelection = null;
        CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 6, "", "", 0, 0);
        if (this.getCellEditor() != null) {
            this.getCellEditor().stopCellEditing();
        }
        int n = 0;
        while (n < this.tableEventListeners.size()) {
            Object e = this.tableEventListeners.elementAt(n);
            ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
            ++n;
        }
    }

    public JToolTip createToolTip() {
        return new CvToolTip();
    }

    public Icon getAcknowledgedIcon() {
        return this.acknowledgedIcon;
    }

    public Color getAlternateBackground() {
        return this.alternateBackground;
    }

    public int getRowHeight() {
        return super.getRowHeight() + 4;
    }

    public int getVisibleLines() {
        return this.visibleLines;
    }

    protected void setContextSelection(SMTblSelectionInfo sMTblSelectionInfo) {
        this.tblContextSelection = sMTblSelectionInfo;
    }

    public SMTblSelectionInfo getContextSelection() {
        return this.tblContextSelection;
    }

    protected void sendTableEvent(CvTblTableEvent cvTblTableEvent) {
        int n = 0;
        while (n < this.tableEventListeners.size()) {
            Object e = this.tableEventListeners.elementAt(n);
            ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
            ++n;
        }
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        SMTblCellEditor sMTblCellEditor = null;
        String string = this.getDataType(n, n2);
        String string2 = this.mapDataType(string);
        sMTblCellEditor = (SMTblCellEditor)this.defaultEditors.get(string2);
        return sMTblCellEditor;
    }

    public String mapDataType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("int") || string.equals("counter") || string.equals("conter32") || string.equals("counter64") || string.equals("gauge") || string.equals("uint")) {
            return "int";
        }
        if (string.equals("float")) {
            return "float";
        }
        if (string.equals("boolean")) {
            return "boolean";
        }
        if (string.equals("date")) {
            return "date";
        }
        return "string";
    }

    public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
        boolean bl;
        Component component;
        Object object = this.getValueAt(n, n2);
        CvTblCell cvTblCell = (CvTblCell)object;
        String string = "";
        if (cvTblCell != null) {
            string = cvTblCell.getDataValue();
        }
        if ((component = tableCellEditor.getTableCellEditorComponent(this, string, bl = this.isCellSelected(n, n2), n, n2)) != null && component.getFont() == null) {
            component.setFont(this.getFont());
        }
        component.removeMouseListener(this);
        component.addMouseListener(this);
        return component;
    }

    public void saveAgentData(int n, int n2, String string, String string2) {
    }

    public void editingStopped(ChangeEvent changeEvent) {
        TableCellEditor tableCellEditor = this.getCellEditor();
        if (tableCellEditor != null) {
            Object object = tableCellEditor.getCellEditorValue();
            CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
            int n = this.convertColumnIndexToModel(this.editingColumn);
            String string = cvTblTableModel.getFullURL(this.editingRow, n);
            String string2 = cvTblTableModel.getDataValue(this.editingRow, n);
            if (object != null && (string2 == null || object.toString().compareTo(string2) != 0)) {
                String string3 = this.getRawDataType(this.editingRow, this.editingColumn);
                this.saveAgentData(this.editingRow, n, object.toString(), string3);
            }
            this.removeEditor();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            int n;
            int n2;
            if (mouseEvent.getSource() == this.getTableHeader()) {
                CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
                if (!cvTblTableModel.getVertical()) {
                    Point point = this.getTableHeader().getLocation();
                    int n3 = this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                    int n4 = this.convertColumnIndexToModel(n3);
                    String string = cvTblTableModel.getURL(0, n4);
                    String string2 = cvTblTableModel.getFullName(0, n4);
                    CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 3, string, string2, mouseEvent.getPoint().x + point.x, mouseEvent.getPoint().y + point.y);
                    int n5 = 0;
                    while (n5 < this.tableEventListeners.size()) {
                        Object e = this.tableEventListeners.elementAt(n5);
                        ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                        ++n5;
                    }
                    return;
                }
                return;
            }
            Point point = this.getLocation();
            if (!(mouseEvent.getSource() instanceof CvCommonTable)) {
                n2 = this.editingRow;
                n = this.editingColumn;
                mouseEvent = SwingUtilities.convertMouseEvent((Component)mouseEvent.getSource(), mouseEvent, this);
            } else {
                n2 = this.rowAtPoint(mouseEvent.getPoint());
                n = this.columnAtPoint(mouseEvent.getPoint());
            }
            int n6 = this.convertColumnIndexToModel(n);
            if (n2 == -1 || n == -1 || n6 == -1) {
                return;
            }
            CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
            if (cvTblTableModel.getVertical() && n6 == 0) {
                return;
            }
            String string = cvTblTableModel.getFullURL(n2, n6);
            String string3 = cvTblTableModel.getFullName(n2, n6);
            String string4 = cvTblTableModel.getExclusionInfo(n2, n6);
            int n7 = 2;
            CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, n7, string, string3, mouseEvent.getPoint().x + point.x, mouseEvent.getPoint().y + point.y);
            cvTblTableEvent.setExclusionInfo(string4);
            int n8 = 0;
            while (n8 < this.tableEventListeners.size()) {
                Object e = this.tableEventListeners.elementAt(n8);
                ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                ++n8;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        boolean bl = false;
        if (n != this.oldRow || n2 != this.oldColumn) {
            bl = true;
        }
        this.oldRow = n;
        this.oldColumn = n2;
        if (this.oldRow == -1 || this.oldColumn == -1) {
            return;
        }
        Object object = this.getValueAt(this.oldRow, this.oldColumn);
        if (object == null || !(object instanceof JComponent)) {
            this.setToolTipText(null);
            return;
        }
        String string = ((JComponent)object).getToolTipText();
        String string2 = this.getToolTipText();
        if (bl) {
            this.setToolTipText(string);
        } else if (string != null && string2 == null || string == null && string2 != null) {
            this.setToolTipText(string);
        } else if (string != null && string2 != null && !string.equals(string2)) {
            this.setToolTipText(string);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
        if (!mouseEvent.isPopupTrigger()) {
            this.repaint();
        }
        if ((mouseEvent.getModifiers() & 0x10) != 0 && mouseEvent.getSource() != this.getTableHeader()) {
            this.selectedCol = -1;
        }
        this.showPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    public void removeTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.removeElement(cvTblTableEventListener);
    }

    public void setAcknowledgedIcon(Icon icon) {
        this.acknowledgedIcon = icon;
    }

    public void setAllowCellSelect(boolean bl) {
        if (bl) {
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            listSelectionModel.setSelectionMode(2);
            this.setRowSelectionAllowed(true);
            ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
            listSelectionModel2.setSelectionMode(0);
            this.setColumnSelectionAllowed(true);
            listSelectionModel.addListSelectionListener(this);
            listSelectionModel2.addListSelectionListener(this);
            this.headerSelectAllowed = true;
        } else {
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setCellSelectionEnabled(false);
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            ListSelectionModel listSelectionModel3 = this.getColumnModel().getSelectionModel();
            listSelectionModel.removeListSelectionListener(this);
            listSelectionModel3.removeListSelectionListener(this);
            this.setHeaderSelected(false);
            this.headerSelectAllowed = false;
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.alternateBackground = color.darker();
        this.repaint();
    }

    public void setBackground(Color color, Color color2) {
        super.setBackground(color);
        this.alternateBackground = color2;
        this.repaint();
    }

    public void setVisibleLines(int n) {
        this.visibleLines = n >= -1 ? n : -1;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.resizeAndRepaint();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.selectedCol != -1) {
            return;
        }
        boolean bl = true;
        int n = -1;
        int n2 = -1;
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        ListSelectionModel listSelectionModel2 = this.getColumnModel().getSelectionModel();
        n = this.getSelectedRow();
        n2 = this.getSelectedColumn();
        if (n2 == -1 && listSelectionModel2.isSelectionEmpty()) {
            n2 = 0;
        }
        int n3 = this.convertColumnIndexToModel(n2);
        int[] nArray = this.getSelectedRows();
        SMTblSelectionInfo sMTblSelectionInfo = this.getContextSelection();
        SMTblSelectionInfo sMTblSelectionInfo2 = new SMTblSelectionInfo(2, n, n2, nArray);
        this.setContextSelection(sMTblSelectionInfo2);
        CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
        CvTblTableEvent cvTblTableEvent = null;
        if (!sMTblSelectionInfo2.equals(sMTblSelectionInfo) && !listSelectionModel.isSelectionEmpty()) {
            cvTblTableEvent = new CvTblTableEvent(this, 5, "", "", 0, 0);
        } else if (listSelectionModel.isSelectionEmpty() && listSelectionModel2.isSelectionEmpty()) {
            this.setContextSelection(null);
            cvTblTableEvent = new CvTblTableEvent(this, 6, "", "", 0, 0);
        }
        if (cvTblTableEvent != null) {
            int n4 = 0;
            while (n4 < this.tableEventListeners.size()) {
                Object e = this.tableEventListeners.elementAt(n4);
                ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                ++n4;
            }
        }
    }

    public void setHeaderSelected(boolean bl) {
        if (this.headerSelectAllowed) {
            this.headerSelected = bl;
            if (bl) {
                this.clearSelection();
                CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 7, "", "", 0, 0);
                int n = 0;
                while (n < this.tableEventListeners.size()) {
                    Object e = this.tableEventListeners.elementAt(n);
                    ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                    ++n;
                }
            }
        }
        this.getTableHeader().resizeAndRepaint();
    }

    public boolean getHeaderSelected() {
        return this.headerSelected;
    }

    public void setupDefaultEditors() {
        CvTblStringEditor cvTblStringEditor = new CvTblStringEditor();
        this.defaultEditors.put("string", cvTblStringEditor);
        CvTblIntEditor cvTblIntEditor = new CvTblIntEditor();
        this.defaultEditors.put("int", cvTblIntEditor);
        CvTblBooleanEditor cvTblBooleanEditor = new CvTblBooleanEditor();
        this.defaultEditors.put("boolean", cvTblBooleanEditor);
        CvTblFloatEditor cvTblFloatEditor = new CvTblFloatEditor();
        this.defaultEditors.put("float", cvTblFloatEditor);
        CvTblDateEditor cvTblDateEditor = new CvTblDateEditor();
        this.defaultEditors.put("date", cvTblDateEditor);
    }

    public String getDataType(int n, int n2) {
        String string = this.getRawDataType(n, n2);
        String string2 = string = string != null ? string : "";
        if (!(string.equals("int") || string.equals("float") || string.equals("date") || string.equals("boolean"))) {
            string = "string";
        }
        return string;
    }

    public String getRawDataType(int n, int n2) {
        CvTblTableColumn cvTblTableColumn = (CvTblTableColumn)this.getColumnModel().getColumn(n2);
        CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
        String string = null;
        if (cvTblTableColumn == null) {
            return null;
        }
        string = cvTblTableModel.getVertical() ? cvTblTableColumn.getRowDataType(n) : cvTblTableColumn.getDataType();
        return string;
    }

    public void setSelectedCol(int n) {
        this.selectedCol = n;
    }

    public boolean isCellSelected(int n, int n2) {
        if (this.cellSelectionEnabled) {
            return this.isRowSelected(n) && this.isColumnSelected(n2);
        }
        if (this.isRowSelected(n)) {
            return this.getRowSelectionAllowed() && this.isRowSelected(n);
        }
        if (this.isColumnSelected(n2)) {
            return this.isColumnSelected(n2) && this.selectedCol == n2;
        }
        return false;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown() && keyEvent.getKeyCode() == 121) {
            if (this.getSelectedColumn() > -1 && this.getSelectedRow() == -1) {
                CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
                if (!cvTblTableModel.getVertical()) {
                    Point point = this.getTableHeader().getLocation();
                    int n = this.getSelectedColumn();
                    int n2 = this.convertColumnIndexToModel(n);
                    String string = cvTblTableModel.getURL(0, n2);
                    String string2 = cvTblTableModel.getFullName(0, n2);
                    Rectangle rectangle = this.getTableHeader().getHeaderRect(n);
                    CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, 3, string, string2, rectangle.x + point.x + 10, rectangle.y + point.y + 10);
                    int n3 = 0;
                    while (n3 < this.tableEventListeners.size()) {
                        Object e = this.tableEventListeners.elementAt(n3);
                        ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                        ++n3;
                    }
                    return;
                }
                return;
            }
            Point point = this.getLocation();
            int n = this.getSelectedRow();
            int n4 = this.getSelectedColumn();
            Rectangle rectangle = this.getCellRect(n, n4, true);
            int n5 = this.convertColumnIndexToModel(n4);
            if (n == -1 || n4 == -1 || n5 == -1) {
                return;
            }
            CvTblTableModel cvTblTableModel = (CvTblTableModel)this.getModel();
            if (cvTblTableModel.getVertical() && n5 == 0) {
                return;
            }
            String string = cvTblTableModel.getFullURL(n, n5);
            String string3 = cvTblTableModel.getFullName(n, n5);
            String string4 = cvTblTableModel.getExclusionInfo(n, n5);
            int n6 = 2;
            CvTblTableEvent cvTblTableEvent = new CvTblTableEvent(this, n6, string, string3, rectangle.x + point.x + 10, rectangle.y + point.y + 10);
            cvTblTableEvent.setExclusionInfo(string4);
            int n7 = 0;
            while (n7 < this.tableEventListeners.size()) {
                Object e = this.tableEventListeners.elementAt(n7);
                ((CvTblTableEventListener)e).tableEventOccurred(cvTblTableEvent);
                ++n7;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

