/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.utility.UcDDL;
import java.awt.Font;

public class CvGraphYLabelFormat {
    private String fontStyle = "plain";
    private String fontName = "Serif";
    private String position = "west";
    private int fontSize = 10;
    private String orientation = "verticalflip";
    private String borderType = "none";
    private int borderWidth = 2;
    private boolean showYTitle = true;

    public boolean getShowYTitle() {
        return this.showYTitle;
    }

    public void setShowYTitle(boolean bl) {
        this.showYTitle = bl;
    }

    public Font getTitleFont() {
        return new Font(this.fontName, CvGraphFormat.getFontStyleNumber(this.fontStyle), this.fontSize);
    }

    public String getBorderType() {
        return this.borderType;
    }

    public int getBorderTypeNumber() {
        return CvGraphFormat.getBorderTypeNumber(this.borderType);
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public int getOrientationNumber() {
        return CvGraphFormat.getOrientationNumber(this.orientation);
    }

    public int getOrientation() {
        return CvGraphFormat.getOrientationNumber(this.orientation);
    }

    public int getPlacement() {
        return CvGraphFormat.getPositionNumber(this.position);
    }

    public String getConfiguration() {
        return "YLabel^" + this.showYTitle + "^" + this.fontStyle + "^" + this.fontName + "^" + new Integer(this.fontSize).toString() + "^" + this.position + "^" + this.orientation + "^" + this.borderType + "^" + new Integer(this.borderWidth).toString();
    }

    public void setConfiguration(String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, "^");
        if (stringArray.length != 9) {
            UcDDL.logDebugMessage((String)("CvGraphYLabelFormat::setConfiguration - invalid number of parameters '" + string + "'"));
            return;
        }
        if (!stringArray[0].equals("YLabel")) {
            UcDDL.logDebugMessage((String)("CvGraphFormat::setGraphConfiguration - invalid keyword '" + stringArray[0] + "'"));
            return;
        }
        this.showYTitle = Boolean.valueOf(stringArray[1]);
        this.fontStyle = stringArray[2];
        this.fontName = stringArray[3];
        this.position = stringArray[5];
        this.orientation = stringArray[6];
        this.borderType = stringArray[7];
        try {
            this.fontSize = new Integer(stringArray[4]);
            this.borderWidth = new Integer(stringArray[8]);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)("CvGraphTitleFromat::setConfiguration -- cannot convert strings " + stringArray[4] + " and " + stringArray[8] + " to integer "));
        }
    }

    public void setPlacement(int n) {
        if (n == 16) {
            this.position = "north";
        } else if (n == 18) {
            this.position = "northwest";
        } else if (n == 17) {
            this.position = "northeast";
        } else if (n == 2) {
            this.position = "west";
        } else if (n == 1) {
            this.position = "east";
        } else if (n == 32) {
            this.position = "south";
        } else if (n == 34) {
            this.position = "southwest";
        } else if (n == 33) {
            this.position = "southeast";
        }
    }
}

