/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.graph.SMGraphInfo;
import com.sun.symon.base.client.graph.SMGraphRequest;
import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CvGraphOpenManager
extends JPanel {
    private SMGraphRequest graphDataSource = null;
    private JList fileList = new JList();
    private JLabel savedLabel = new JLabel(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:availabletemplates"));
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();

    public CvGraphOpenManager() {
        this.setLayout(this.gridbag);
        this.c.insets = new Insets(5, 2, 5, 2);
        JLabel jLabel = new JLabel(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:username"));
        this.savedLabel.setDisplayedMnemonic(UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:availabletemplates").charAt(0));
        this.savedLabel.setLabelFor(this.fileList);
        this.addOne(this.savedLabel);
        this.fileList.setVisibleRowCount(4);
        this.fileList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.fileList);
        jScrollPane.setPreferredSize(new Dimension(300, 50));
        this.addOne(jScrollPane);
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    private void addOne(JComponent jComponent) {
        this.c.weightx = 1.0;
        this.c.fill = 2;
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(jComponent, this.c);
        this.add(jComponent);
    }

    public String getGraphUserId() {
        return this.graphDataSource.getGraphUserId();
    }

    public String getGraphInfo() {
        String string = this.graphDataSource.getGraphUserId();
        String string2 = this.getFileName();
        try {
            SMGraphInfo[] sMGraphInfoArray = this.graphDataSource.getUserGraphInfo(string);
            int n = 0;
            while (n < sMGraphInfoArray.length) {
                SMGraphInfo sMGraphInfo = sMGraphInfoArray[n];
                if (string2.equals(sMGraphInfo.getGraphName())) {
                    String string3 = sMGraphInfo.getGraphInfo();
                    return string3;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public String getFirstUrl() {
        String string = this.graphDataSource.getGraphUserId();
        String string2 = this.getFileName();
        String string3 = null;
        try {
            SMGraphInfo[] sMGraphInfoArray = this.graphDataSource.getUserGraphInfo(string);
            int n = 0;
            while (n < sMGraphInfoArray.length) {
                SMGraphInfo sMGraphInfo = sMGraphInfoArray[n];
                if (string2.equals(sMGraphInfo.getGraphName())) {
                    String string4 = sMGraphInfo.getGraphInfo();
                    String[] stringArray = CvGraphFormat.splitString(string4, "$");
                    String string5 = stringArray[0];
                    String[] stringArray2 = CvGraphFormat.splitString(string5, ",");
                    string3 = stringArray2[0];
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return string3;
    }

    public String[] getAllGraphs() {
        try {
            SMGraphInfo[] sMGraphInfoArray = this.graphDataSource.getUserGraphInfo(this.graphDataSource.getGraphUserId());
            String[] stringArray = new String[sMGraphInfoArray.length];
            int n = 0;
            while (n < sMGraphInfoArray.length) {
                SMGraphInfo sMGraphInfo = sMGraphInfoArray[n];
                stringArray[n] = sMGraphInfo.getGraphName();
                ++n;
            }
            return stringArray;
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logDebugMessage((String)("cannot retrieve graph info for  user " + this.graphDataSource.getGraphUserId()));
            return null;
        }
    }

    public void setGraphList() {
        if (this.getAllGraphs().length != 0) {
            this.setFileNames(this.getAllGraphs());
        }
    }

    public void setGraphDataSource(SMRawDataRequest sMRawDataRequest) {
        if (sMRawDataRequest != null) {
            this.graphDataSource = new SMGraphRequest(sMRawDataRequest);
        }
    }

    public void setDescription(String string) {
        this.savedLabel.setText(string);
    }

    public String getDescription() {
        return this.savedLabel.getText();
    }

    public JList getFileList() {
        return this.fileList;
    }

    public String getFileName() {
        return (String)this.fileList.getSelectedValue();
    }

    public void setFileNames(String[] stringArray) {
        this.fileList.setListData(stringArray);
        if (stringArray != null && stringArray.length != 0) {
            this.fileList.setSelectedIndex(0);
        }
    }

    public static void main(String[] stringArray) {
        CvGraphOpenManager cvGraphOpenManager = new CvGraphOpenManager();
        String[] stringArray2 = new String[]{"one", "two", "three", "four", "five"};
        cvGraphOpenManager.setFileNames(stringArray2);
        JFrame jFrame = new JFrame("open files");
        jFrame.getContentPane().add("Center", cvGraphOpenManager);
        jFrame.pack();
        jFrame.show();
    }
}

