/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.ConjunctionCombo;
import com.sun.symon.base.console.tools.editor.CtTimexEditor;
import com.sun.symon.base.console.tools.editor.Display;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;

public class CtTimexListPanel
extends JPanel {
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private String value;
    private Vector simpleExprs = new Vector();
    private Vector delims = new Vector();
    private CtTimexEditor editor;
    private int index = -1;
    private String currentMesg = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:current");
    private String deleteMesg = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:deleteerror");
    private String insertMesg = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:inserterror");
    private String nothingMesg = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:nothing");
    private String andConj = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:and");
    private String orConj = UcInternationalizer.translateKey((String)"base.console.tools.editor.TimexLabels:or");

    public CtTimexListPanel(String string, CtTimexEditor ctTimexEditor) {
        this.value = string;
        this.editor = ctTimexEditor;
        this.setLayout(this.gridbag);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&&");
        this.delims.addElement("");
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = (String)stringTokenizer.nextElement();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "||");
            if (++n > 1) {
                this.delims.addElement(this.andConj);
            }
            n2 = 0;
            while (stringTokenizer2.hasMoreTokens()) {
                this.simpleExprs.addElement(stringTokenizer2.nextElement());
                if (++n2 <= 1) continue;
                this.delims.addElement(this.orConj);
            }
        }
        this.makeList();
    }

    void changeIndex() {
        this.index = this.oneHasFocus();
        if (this.index != -1) {
            String string = this.currentMesg + new Integer(this.index / 2 + 1).toString();
            this.editor.updateMessage(string);
            this.editor.enableEdit();
        } else {
            this.editor.updateMessage(this.nothingMesg);
            this.editor.disableDelete();
        }
    }

    void deleteSE() {
        if (this.index != -1) {
            this.remove(this.index);
            this.remove(this.index - 1);
            int n = this.getComponentCount();
            if (n != 0) {
                if (this.index == 1) {
                    this.remove(0);
                    this.add((Component)new JLabel(), 0);
                } else if (this.index >= n) {
                    this.index = 1;
                }
                ((JComponent)this.getComponent(this.index)).grabFocus();
            } else {
                this.index = -1;
            }
        }
        if (this.index != -1) {
            String string = this.currentMesg + new Integer(this.index / 2 + 1).toString();
            this.editor.updateMessage(string);
            this.editor.enableEdit();
        } else {
            this.editor.updateMessage(this.nothingMesg);
            this.editor.disableDelete();
        }
        this.validate();
        super.repaint();
    }

    int getCount() {
        return this.getComponentCount();
    }

    String getCurrentValue() {
        int n = this.getComponentCount();
        String string = "";
        int n2 = 0;
        while (n2 < n / 2) {
            JComponent jComponent;
            int n3 = 2 * n2;
            int n4 = 2 * n2 + 1;
            if (n3 != 0) {
                jComponent = (ConjunctionCombo)this.getComponent(n3);
                Display display = (Display)this.getComponent(n4);
                if (display.getText().trim().length() != 0) {
                    String string2 = (String)((JComboBox)jComponent).getSelectedItem();
                    string2 = string2.trim();
                    String string3 = "";
                    int n5 = ((JComboBox)jComponent).getSelectedIndex();
                    string3 = n5 == 0 ? " && " : " || ";
                    if (string.length() > 0) {
                        string = string + string3;
                    }
                    string = string + display.getText();
                }
            } else {
                jComponent = (Display)this.getComponent(n4);
                string = string + ((JTextComponent)jComponent).getText();
            }
            ++n2;
        }
        return string;
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    void insertSE(String string) {
        Object object;
        int n = this.getComponentCount();
        if (n != 0) {
            object = new ConjunctionCombo(this.andConj, this.orConj);
            if (this.index == -1) {
                this.index = n - 1;
            }
            this.c.weightx = 0.05;
            this.c.fill = 2;
            this.c.gridwidth = 1;
            this.gridbag.setConstraints((Component)object, this.c);
            this.add((Component)object, this.index + 1);
            this.c.weightx = 1.0;
            this.c.fill = 2;
            this.c.gridwidth = 0;
            Display display = new Display(string, this);
            display.setScrollOffset(0);
            this.gridbag.setConstraints(display, this.c);
            this.add((Component)display, this.index + 2);
            this.index += 2;
            ((JComponent)this.getComponent(this.index)).grabFocus();
            ((Display)this.getComponent(this.index)).selectAll();
            this.validate();
            this.getParent().validate();
            this.getParent().repaint();
        } else {
            object = new JLabel();
            this.c.weightx = 0.0;
            this.c.fill = 2;
            this.c.gridwidth = 1;
            this.gridbag.setConstraints((Component)object, this.c);
            this.add((Component)object, 0);
            this.c.weightx = 1.0;
            this.c.fill = 2;
            this.c.gridwidth = 0;
            Display display = new Display(string, this);
            display.setScrollOffset(0);
            this.gridbag.setConstraints(display, this.c);
            this.add((Component)display, 1);
            ((JComponent)this.getComponent(1)).grabFocus();
            ((Display)this.getComponent(1)).selectAll();
            this.index = 1;
            this.validate();
            this.getParent().validate();
            this.getParent().repaint();
        }
        object = this.currentMesg + new Integer(this.index / 2 + 1).toString();
        this.editor.updateMessage((String)object);
        this.editor.enableEdit();
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    private void makeList() {
        this.c.insets = new Insets(2, 4, 2, 4);
        int n = 0;
        while (n < this.simpleExprs.size()) {
            JComponent jComponent;
            String string = (String)this.simpleExprs.elementAt(n);
            String string2 = (String)this.delims.elementAt(n);
            Display display = new Display(string, this);
            if (n == 0) {
                jComponent = new JLabel("");
            } else {
                jComponent = new ConjunctionCombo(this.andConj, this.orConj);
                if (string2.equals(this.orConj)) {
                    ((ConjunctionCombo)jComponent).setSelectedIndex(1);
                }
            }
            this.c.weightx = 0.08;
            this.c.fill = 2;
            this.c.gridwidth = 1;
            this.gridbag.setConstraints(jComponent, this.c);
            this.add(jComponent);
            this.c.weightx = 1.0;
            this.c.fill = 2;
            this.c.gridwidth = 0;
            this.gridbag.setConstraints(display, this.c);
            this.add(display);
            ++n;
        }
    }

    boolean notReady() {
        int n = this.getComponentCount();
        return this.index == -1 || n == 0;
    }

    int oneHasFocus() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JComponent jComponent = (JComponent)componentArray[n];
            if (jComponent.hasFocus()) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

