/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.attribute.SMAttributeUpdateData;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtResetEvent;
import com.sun.symon.base.console.tools.editor.CtResetListener;
import com.sun.symon.base.console.tools.editor.CtSaveEvent;
import com.sun.symon.base.console.tools.editor.CtSaveListener;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JComboBox;

public class CtListField
extends JComboBox
implements CtResetListener,
CtFocusTraversable,
KeyListener,
FocusListener,
CtSaveListener {
    protected int currentIndex;
    protected int originalIndex;
    protected int lastIndex;
    protected boolean access;
    protected String attKey;
    protected String groupKey;
    protected Vector listItems;
    protected Vector listDisplayItems;
    protected CtAttributeEditor theEditor;
    protected boolean lastEditable = false;
    protected boolean changed = false;
    protected boolean hasFocus = false;
    protected Vector focusListener = new Vector();

    private void _CtListField(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor, Vector vector, Vector vector2) {
        String string2;
        this.listItems = vector;
        this.listDisplayItems = vector2;
        this.theEditor = ctAttributeEditor;
        String string3 = sMAttributeEntryData.getValue();
        string3 = string3.replace('\t', ' ');
        this.attKey = sMAttributeEntryData.getKey();
        this.groupKey = string;
        this.access = sMAttributeEntryData.getAccess();
        int n = 0;
        this.lastIndex = -1;
        this.originalIndex = -1;
        this.currentIndex = -1;
        if (string3.equals("")) {
            string3 = sMAttributeEntryData.getDefault();
            SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.groupKey, this.attKey, string3);
            this.theEditor.updateSaveData(sMAttributeUpdateData);
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            string2 = (String)vector.elementAt(n2);
            if (string3.equals(string2)) {
                n = n2;
            }
            this.addItem((String)vector2.elementAt(n2));
            ++n2;
        }
        if (string3.equals("") && sMAttributeEntryData.getDefault().equals("")) {
            string3 = (String)vector.elementAt(0);
            this.setSelectedIndex(0);
            string2 = new SMAttributeUpdateData(this.groupKey, this.attKey, string3);
            this.theEditor.updateSaveData((SMAttributeUpdateData)string2);
        }
        this.setSelectedIndex(n);
        this.originalIndex = this.lastIndex = n;
        this.currentIndex = this.lastIndex;
        this.addKeyListener(this);
        this.addFocusListener(this);
        if (this.access) {
            this.theEditor.addCtResetListener(this);
            this.theEditor.addCtSaveListener(this);
        }
    }

    public CtListField(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor, Vector vector, Vector vector2) {
        this._CtListField(sMAttributeEntryData, string, ctAttributeEditor, vector, vector2);
    }

    public CtListField(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor) {
        this.listItems = new Vector();
        this.listDisplayItems = new Vector();
        this.getListValues(sMAttributeEntryData.getFormat(), this.listItems, this.listDisplayItems);
        this._CtListField(sMAttributeEntryData, string, ctAttributeEditor, this.listItems, this.listDisplayItems);
    }

    public synchronized void addCtFocusChangeListener(CtFocusChangeListener ctFocusChangeListener) {
        if (!this.focusListener.contains(ctFocusChangeListener)) {
            this.focusListener.addElement(ctFocusChangeListener);
        }
    }

    public void attributeReset(CtResetEvent ctResetEvent) {
        this.setSelectedIndex(this.originalIndex);
        this.setForeground(this.theEditor.getAttValueForeground());
        this.setBackground(this.theEditor.getAttValueBackground());
        this.changed = false;
        this.repaint();
    }

    public void attributeSaved(CtSaveEvent ctSaveEvent) {
        this.originalIndex = this.getSelectedIndex();
        this.setForeground(this.theEditor.getAttValueForeground());
        this.setBackground(this.theEditor.getAttValueBackground());
        this.changed = false;
        this.repaint();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.notifyFocusChange();
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setBackground(this.theEditor.getAttValueBackground());
        if (this.changed) {
            this.setForeground(this.theEditor.getEditedForeground());
        } else {
            this.setForeground(this.theEditor.getAttValueForeground());
        }
        this.hasFocus = false;
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    void getListValues(String string, Vector vector, Vector vector2) {
        int n = string.indexOf(58, 0);
        int n2 = 0;
        Vector<String> vector3 = new Vector<String>();
        Vector vector4 = new Vector();
        while (n != -1) {
            if (n2 >= string.length()) break;
            vector3.addElement(string.substring(n2, n));
            n2 = n + 1;
            if (n2 >= string.length()) continue;
            n = string.indexOf(124, n2);
        }
        if (n2 != string.length()) {
            vector3.addElement(string.substring(n2, string.length()));
        }
        int n3 = 1;
        while (n3 < vector3.size()) {
            String string2 = (String)vector3.elementAt(n3);
            int n4 = string2.indexOf(44);
            if (n4 < 0) {
                vector.addElement(string2);
                vector2.addElement(string2);
            } else {
                vector.addElement(string2.substring(0, n4));
                String string3 = string2.substring(n4 + 1);
                string3 = UcInternationalizer.translateKey((String)string3);
                vector2.addElement(string3);
            }
            ++n3;
        }
    }

    public boolean isFocusTraversable() {
        return this.access;
    }

    public boolean isRequestFocusEnabled() {
        return this.access;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Character c = new Character('\n');
        if (c.equals(new Character(keyEvent.getKeyChar()))) {
            if (this.lastEditable) {
                this.theEditor.currentPanel.firstGrabFocus();
            } else {
                this.transferFocus();
            }
        }
    }

    public void notifyFocusChange() {
        Vector vector;
        CtFocusChangeEvent ctFocusChangeEvent = new CtFocusChangeEvent(this);
        CtListField ctListField = this;
        synchronized (ctListField) {
            vector = (Vector)this.focusListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtFocusChangeListener ctFocusChangeListener = (CtFocusChangeListener)vector.elementAt(n);
            ctFocusChangeListener.attributeFocusChanged(ctFocusChangeEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(this.theEditor.getFocusedBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public String getSelectedRawValue(int n) {
        return (String)this.listItems.elementAt(n);
    }

    protected void selectedItemChanged() {
        if (this.currentIndex < 0) {
            return;
        }
        this.currentIndex = this.getSelectedIndex();
        if (this.lastIndex != this.currentIndex) {
            if (this.access) {
                String string = (String)this.listItems.elementAt(this.currentIndex);
                SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.groupKey, this.attKey, string);
                this.theEditor.updateSaveData(sMAttributeUpdateData);
                this.changed = true;
                this.theEditor.notifyEdited();
                this.setForeground(this.theEditor.getEditedForeground());
                this.lastIndex = this.currentIndex;
                this.validate();
                this.theEditor.validate();
            } else {
                this.currentIndex = this.lastIndex;
                this.setSelectedIndex(this.currentIndex);
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

