/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.manager.CmProbeViewerRequest;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.util.Vector;
import javax.swing.text.JTextComponent;

public class CmProbeViewer
implements AwxServiceManager,
Runnable {
    private AwxServiceProvider SvcProvider = null;
    private SMRawDataRequest RequestHandle = null;
    private JTextComponent DisplayArea = null;
    private String ProbeUrl = null;
    private String[] ProbeArgs = null;

    public void init() {
        this.reload();
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void reload() {
        Thread thread = new Thread((Runnable)this, "probe");
        thread.setPriority(6);
        thread.start();
    }

    public void run() {
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("message", stringArray);
        this.DisplayArea.setText("");
        this.SvcProvider.triggerService("busyStart");
        try {
            CmProbeViewerRequest cmProbeViewerRequest = new CmProbeViewerRequest(this.RequestHandle);
            String string = cmProbeViewerRequest.getResult(this.ProbeUrl, this.ProbeArgs);
            if (string == null || string.equals("")) {
                String string2 = UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:probe.nodata");
                this.DisplayArea.setText(string2);
            } else {
                this.DisplayArea.setText(string);
            }
        }
        catch (Exception exception) {
            String[] stringArray2 = new String[]{"base.console.ConsoleMessages:probe.fail"};
            this.SvcProvider.triggerService("messageBell", stringArray2);
        }
        this.SvcProvider.triggerService("busyEnd");
    }

    public void setProbeArgs(String string) {
        Vector vector = new Vector();
        if (!UcListUtil.decomposeList((String)string, vector) || vector.size() == 0) {
            this.ProbeArgs = null;
        } else {
            this.ProbeArgs = new String[vector.size()];
            int n = 0;
            while (n < vector.size()) {
                this.ProbeArgs[n] = (String)vector.elementAt(n);
                ++n;
            }
        }
    }

    public void setProbeUrl(String string) {
        this.ProbeUrl = string;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.RequestHandle = sMRawDataRequest;
    }

    public void setTextArea(JTextComponent jTextComponent) {
        this.DisplayArea = jTextComponent;
    }
}

