/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.bootstrap.BsRMIClassLoader;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.service.SMDBChangeEvent;
import com.sun.symon.base.client.service.SMDBChangeListener;
import com.sun.symon.base.client.service.SMDBObject;
import com.sun.symon.base.client.service.SMDBObjectID;
import com.sun.symon.base.client.service.SMHandle;
import com.sun.symon.base.client.service.SMHandleRegistry;
import com.sun.symon.base.client.service.SMLengthException;
import com.sun.symon.base.client.task.SMTask;
import com.sun.symon.base.client.task.SMTaskData;
import com.sun.symon.base.client.task.SMTaskEditor;
import com.sun.symon.base.client.task.SMTaskEditorEx;
import com.sun.symon.base.client.task.SMTaskEditorFactory;
import com.sun.symon.base.client.task.SMTaskEditorManager;
import com.sun.symon.base.client.task.SMTaskEditorManagerEx;
import com.sun.symon.base.client.task.SMTaskInfo;
import com.sun.symon.base.client.task.SMTaskOperationData;
import com.sun.symon.base.client.task.SMTaskType;
import com.sun.symon.base.console.grouping.CgFieldValidator;
import com.sun.symon.base.console.grouping.CgGlassPane;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.grouping.aggregate.CgTaskPanel;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.server.receptors.rmi.RMIClientLevel1;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public class CgTaskManager
extends JFrame
implements SMTaskEditorManagerEx,
SMDBChangeListener {
    private static final String TM_TASK = "TM_TASK";
    private static final int DEFAULT_TASK_NAME_LABEL_WIDTH = 120;
    private static final int MODULE_TASK_NAME_LABEL_WIDTH = 120;
    private static final int PROPERTY_TASK_NAME_LABEL_WIDTH = 140;
    private static final int TABLE_TASK_NAME_LABEL_WIDTH = 125;
    private static final int MCP_TASK_NAME_LABEL_WIDTH = 130;
    private static final int TASK_NAME_FIELD_WIDTH = 230;
    private boolean testing_ = false;
    private boolean reloadNeeded_ = false;
    private boolean cleared_ = false;
    private boolean allowNameChangeNotification_ = false;
    private CgFieldValidator nameValidator_ = new CgFieldValidator(32, 8L);
    private SMTaskType[] taskTypes_;
    private SMTaskType taskType_;
    private boolean modified_ = false;
    private SMTaskEditor editor_;
    private SMTaskEditorEx editorEx_;
    private SMTask taskHandle_;
    private SMRawDataRequest handle_;
    private SMTaskData task_;
    private int currentRow_ = -1;
    private int currentTaskTypeIndex_ = -1;
    JPanel buttonPanel_ = new JPanel();
    GridBagLayout buttonGridBagLayout_ = new GridBagLayout();
    JLabel statusLabel_ = new JLabel();
    BorderLayout borderLayout_ = new BorderLayout();
    JPanel closeButtonGridPanel_ = new JPanel();
    GridLayout buttonGridLayout_ = new GridLayout();
    JPanel mainPanel_ = new JPanel();
    GridBagLayout mainGridBagLayout_ = new GridBagLayout();
    CgTaskPanel taskPanel_ = new CgTaskPanel();
    JButton deleteButton_ = new JButton();
    JLabel taskTypeLabel_ = new JLabel();
    JComboBox taskTypeComboBox_ = new JComboBox();
    JLabel taskNameLabel_ = new JLabel();
    JTextField nameTextField_ = new JTextField();
    JScrollPane editorScrollPane_ = new JScrollPane();
    JLabel descriptionLabel_ = new JLabel();
    JScrollPane descriptionScrollPane_ = new JScrollPane();
    JTextArea descriptionTextArea_ = new JTextArea(new CgFieldValidator(256, 0L));
    JPanel editButtonPanel_ = new JPanel();
    JPanel editButtonInnerPanel_ = new JPanel();
    GridLayout editButtonInnerGridLayout_ = new GridLayout();
    JButton addButton_ = new JButton();
    JButton changeButton_ = new JButton();
    JButton closeButton_ = new JButton();
    JButton helpButton_ = new JButton();
    JButton resetButton_ = new JButton();
    JTextArea taskTypeDesc_ = new JTextArea(){

        public boolean isFocusTraversable() {
            return false;
        }
    };

    public CgTaskManager() {
        this.handle_ = SMConsoleContext.getInstance().getAPIHandle();
        if (this.handle_ == null) {
            this.testing_ = true;
        }
        this.setGlassPane(new CgGlassPane());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        ((JTextComponent)this.nameTextField_).setDocument(this.nameValidator_);
        this.nameTextField_.getDocument().addDocumentListener(new MyDocumentListener("name"));
        this.descriptionTextArea_.getDocument().addDocumentListener(new MyDocumentListener("description"));
        this.taskPanel_.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                CgTaskManager.this.tableRowSelected(listSelectionEvent);
            }
        });
        this.taskPanel_.getTaskTypeComboBox().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    CgTaskManager.this.deleteButton_.setEnabled(false);
                    CgTaskManager.this.currentRow_ = -1;
                }
            }
        });
        this.localize();
        this.pack();
        ((Component)this).setSize(850, 720);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
        this.getRootPane().setDefaultButton(this.addButton_);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgTaskManager.this.dispose();
            }
        });
        CgUtility.setLastEditedTask("");
        this.clearStatusMessage();
        ((Frame)this).setIconImage(CgUtility.getSunMCImage());
        ((Component)this).setVisible(true);
        this.nameTextField_.requestFocus();
        if (!this.testing_) {
            this.load();
        }
    }

    public void dispose() {
        if (this.modified_ && !CgUtility.confirmDiscardChanges(this, CgUtility.getI18nMsg("standard.askDiscardChanges"))) {
            return;
        }
        if (this.editor_ != null) {
            this.editor_.cleanup();
        }
        if (this.taskHandle_ != null) {
            try {
                this.taskHandle_.removeDBChangeListener((SMDBChangeListener)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose();
    }

    public void setBusy(boolean bl) {
        CgUtility.setGlassPaneVisible(this, bl);
    }

    public void setModified(boolean bl) {
        this.modified_ = bl;
        if (this.cleared_ && bl) {
            this.addButton_.setEnabled(true);
        } else {
            this.addButton_.setEnabled(false);
        }
        if (bl) {
            this.clearStatusMessage();
        }
    }

    public void clearStatusMessage() {
        this.statusLabel_.setText("");
    }

    public void setStatusMessage(String string) {
        this.statusLabel_.setText(string);
    }

    public String getTaskName() {
        if (this.nameTextField_.getText() == null) {
            return "";
        }
        return this.nameTextField_.getText().trim();
    }

    private void realignFields() {
        int n = this.getTaskNameLabelWidth();
        this.taskTypeLabel_.setMinimumSize(new Dimension(n, 18));
        this.taskTypeLabel_.setMaximumSize(new Dimension(n, 18));
        this.taskTypeLabel_.setPreferredSize(new Dimension(n, 18));
        this.taskNameLabel_.setMinimumSize(new Dimension(n, 18));
        this.taskNameLabel_.setMaximumSize(new Dimension(n, 18));
        this.taskNameLabel_.setPreferredSize(new Dimension(n, 18));
        this.taskTypeLabel_.revalidate();
        this.taskNameLabel_.revalidate();
        this.repaint();
    }

    public int getTaskNameLabelWidth() {
        if (this.taskType_ == null) {
            return 120;
        }
        if (this.taskType_.getTaskTypeString().equals("Core_Module")) {
            return 120;
        }
        if (this.taskType_.getTaskTypeString().equals("Core_DataProperty")) {
            return 140;
        }
        if (this.taskType_.getTaskTypeString().equals("Core_Table")) {
            return 125;
        }
        if (this.taskType_.getTaskTypeString().equals("Core_MCP")) {
            return 130;
        }
        return 120;
    }

    public int getTaskNameFieldWidth() {
        return 230;
    }

    private void documentChanged(Object object) {
        String string = (String)object;
        if (string.equals("name") && this.allowNameChangeNotification_) {
            this.cleared_ = true;
            this.setModified(true);
            if (this.editorEx_ != null) {
                this.editorEx_.taskNameChanged(this.getTaskName());
            }
        }
    }

    private void localize() {
        this.setTitle(CgUtility.getI18nMsg("task.message.newTask"));
        this.deleteButton_.setText(CgUtility.getI18nMsg("task.deleteTask"));
        this.deleteButton_.setMnemonic(CgUtility.getMnemonic("task.deleteTask"));
        this.taskTypeLabel_.setText(CgUtility.getI18nMsg("task.selectTaskType") + ":");
        this.taskTypeLabel_.setLabelFor(this.taskTypeComboBox_);
        this.taskTypeLabel_.setDisplayedMnemonic(CgUtility.getMnemonic("task.selectTaskType"));
        this.taskNameLabel_.setText(CgUtility.getI18nMsg("task.taskName") + ":");
        this.taskNameLabel_.setLabelFor(this.nameTextField_);
        this.taskNameLabel_.setDisplayedMnemonic(CgUtility.getMnemonic("task.taskName"));
        this.descriptionLabel_.setText(CgUtility.getI18nMsg("standard.description") + " (" + CgUtility.getI18nMsg("standard.optional") + ")");
        this.descriptionLabel_.setLabelFor(this.descriptionTextArea_);
        this.descriptionLabel_.setDisplayedMnemonic(CgUtility.getMnemonic("standard.description"));
        this.addButton_.setText(CgUtility.getI18nMsg("task.saveTask"));
        this.changeButton_.setText(CgUtility.getI18nMsg("task.updateTask"));
        this.changeButton_.setMnemonic(CgUtility.getMnemonic("task.updateTask"));
        this.resetButton_.setText(CgUtility.getI18nMsg("standard.resetForm"));
        this.resetButton_.setMnemonic(CgUtility.getMnemonic("standard.resetForm"));
        this.closeButton_.setText(CgUtility.getI18nMsg("message.close"));
        this.helpButton_.setText(CgUtility.getI18nMsg("standard.help"));
        this.helpButton_.setMnemonic(CgUtility.getMnemonic("standard.help"));
        this.getAccessibleContext().setAccessibleDescription(CgUtility.getI18nMsg("taskManager.window.description"));
    }

    private void load() {
        this.reloadNeeded_ = false;
        final CgTaskManager cgTaskManager = this;
        Runnable runnable = new Runnable(){

            public void run() {
                CgTaskManager.this.setBusy(true);
                CgTaskManager.this.setStatusMessage(CgUtility.getI18nMsg("standard.loading") + "...");
                try {
                    try {
                        if (CgTaskManager.this.taskHandle_ == null) {
                            CgTaskManager.this.taskHandle_ = (SMTask)SMHandleRegistry.getInstance((String)"CONSOLE").getHandle(CgTaskManager.TM_TASK);
                            if (CgTaskManager.this.taskHandle_ == null) {
                                CgTaskManager.this.taskHandle_ = new SMTask(SMConsoleContext.getInstance().getAPIHandle());
                                SMHandleRegistry.getInstance((String)"CONSOLE").addHandle(CgTaskManager.TM_TASK, (SMHandle)CgTaskManager.this.taskHandle_);
                            }
                            CgTaskManager.this.taskHandle_.addDBChangeListener(cgTaskManager);
                        }
                        if (CgTaskManager.this.taskTypes_ == null) {
                            CgTaskManager.access$302(CgTaskManager.this, CgUtility.getTaskTypes(CgTaskManager.this.taskHandle_));
                        }
                        CgTaskManager.this.taskPanel_.load(CgTaskManager.this.taskHandle_);
                        CgTaskManager.this.currentRow_ = -1;
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.showErrorMessage(CgUtility.getI18nMsg("task.noService"));
                        Object var3_2 = null;
                        return;
                    }
                    Object var3_1 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    throw throwable;
                }
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (5.access$400(this.this$1).taskTypeComboBox_.getItemCount() == 0) {
                            int n = 0;
                            while (n < CgTaskManager.access$300(5.access$400(this.this$1)).length) {
                                5.access$400(this.this$1).taskTypeComboBox_.addItem(CgTaskManager.access$300(5.access$400(this.this$1))[n]);
                                ++n;
                            }
                        }
                        CgTaskManager.access$500(5.access$400(this.this$1));
                        5.access$400(this.this$1).setBusy(false);
                        5.access$400(this.this$1).deleteButton_.setEnabled(false);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            static /* synthetic */ CgTaskManager access$400(5 var0) {
                return var0.CgTaskManager.this;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            Thread thread = new Thread(runnable);
            thread.start();
        } else {
            runnable.run();
        }
    }

    private void loadTask(final String string) {
        Thread thread = new Thread(){

            public void run() {
                CgTaskManager.this.setBusy(true);
                try {
                    try {
                        CgTaskManager.this.task_ = CgTaskManager.this.taskHandle_.load(string);
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.handleError(sMAPIException);
                        Object var3_2 = null;
                        CgTaskManager.this.setBusy(false);
                        return;
                    }
                    Object var3_1 = null;
                    CgTaskManager.this.setBusy(false);
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    CgTaskManager.this.setBusy(false);
                    throw throwable;
                }
                Runnable runnable = new Runnable(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        7.access$700(this.this$1).nameTextField_.setText(CgTaskManager.access$600(7.access$700(this.this$1)).getName());
                        7.access$700(this.this$1).descriptionTextArea_.setText(CgTaskManager.access$600(7.access$700(this.this$1)).getDescription());
                        SMTaskOperationData[] sMTaskOperationDataArray = CgTaskManager.access$600(7.access$700(this.this$1)).getOperations();
                        7.access$700(this.this$1).setModified(false);
                        CgTaskManager.access$800(7.access$700(this.this$1)).setOperationData(CgTaskManager.access$600(7.access$700(this.this$1)).getOperations());
                        7.access$700(this.this$1).changeButton_.setEnabled(true);
                        7.access$700(this.this$1).deleteButton_.setEnabled(true);
                        CgTaskManager.access$902(7.access$700(this.this$1), false);
                        CgTaskManager.access$1002(7.access$700(this.this$1), true);
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            static /* synthetic */ CgTaskManager access$700(7 var0) {
                return var0.CgTaskManager.this;
            }
        };
        thread.start();
    }

    private void jbInit() throws Exception {
        this.buttonPanel_.setLayout(this.buttonGridBagLayout_);
        this.statusLabel_.setText("status");
        this.getContentPane().setLayout(this.borderLayout_);
        this.closeButtonGridPanel_.setLayout(this.buttonGridLayout_);
        this.buttonGridLayout_.setColumns(2);
        this.buttonGridLayout_.setHgap(5);
        this.buttonGridLayout_.setVgap(5);
        this.mainPanel_.setLayout(this.mainGridBagLayout_);
        this.deleteButton_.setEnabled(false);
        this.deleteButton_.setText("delete");
        this.deleteButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.deleteButton__actionPerformed(actionEvent);
            }
        });
        this.taskTypeLabel_.setText("taskType");
        this.taskNameLabel_.setText("taskName");
        this.taskTypeLabel_.setMinimumSize(new Dimension(80, 18));
        this.taskTypeLabel_.setMaximumSize(new Dimension(80, 18));
        this.taskTypeLabel_.setPreferredSize(new Dimension(80, 18));
        this.taskNameLabel_.setMinimumSize(new Dimension(80, 18));
        this.taskNameLabel_.setMaximumSize(new Dimension(80, 18));
        this.taskNameLabel_.setPreferredSize(new Dimension(80, 18));
        this.editorScrollPane_.setHorizontalScrollBarPolicy(31);
        this.editorScrollPane_.setVerticalScrollBarPolicy(21);
        this.editorScrollPane_.setBorder(null);
        this.editorScrollPane_.setMinimumSize(new Dimension(24, 100));
        this.editorScrollPane_.setPreferredSize(new Dimension(4, 100));
        this.descriptionLabel_.setText("description");
        this.taskPanel_.setMinimumSize(new Dimension(324, 150));
        this.descriptionScrollPane_.setHorizontalScrollBarPolicy(31);
        this.descriptionScrollPane_.setMinimumSize(new Dimension(370, 38));
        this.descriptionScrollPane_.setPreferredSize(new Dimension(570, 38));
        this.buttonPanel_.setBorder(BorderFactory.createEmptyBorder(10, 12, 12, 12));
        this.mainPanel_.setAlignmentX(0.0f);
        this.mainPanel_.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        this.descriptionTextArea_.setText("");
        this.descriptionTextArea_.setPreferredSize(new Dimension(570, 18));
        this.descriptionTextArea_.setWrapStyleWord(true);
        this.descriptionTextArea_.setLineWrap(true);
        this.descriptionTextArea_.setMinimumSize(new Dimension(370, 18));
        this.taskTypeComboBox_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CgTaskManager.this.taskTypeComboBox__itemStateChanged(itemEvent);
            }
        });
        this.nameTextField_.setText("");
        this.nameTextField_.setMinimumSize(new Dimension(250, 23));
        this.nameTextField_.setPreferredSize(new Dimension(250, 23));
        this.editButtonInnerPanel_.setLayout(this.editButtonInnerGridLayout_);
        this.addButton_.setEnabled(false);
        this.addButton_.setText("newTask");
        this.addButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.addButton__actionPerformed(actionEvent);
            }
        });
        this.changeButton_.setEnabled(false);
        this.changeButton_.setText("updateTask");
        this.changeButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.changeButton__actionPerformed(actionEvent);
            }
        });
        this.closeButton_.setText("close");
        this.closeButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.closeButton__actionPerformed(actionEvent);
            }
        });
        this.helpButton_.setText("help");
        this.closeButton_.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.closeButton__actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.helpButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.helpButton__actionPerformed(actionEvent);
            }
        });
        this.editButtonInnerGridLayout_.setColumns(3);
        this.editButtonInnerGridLayout_.setHgap(5);
        this.resetButton_.setText("reset");
        this.resetButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgTaskManager.this.resetButton__actionPerformed(actionEvent);
            }
        });
        this.taskTypeDesc_.setEditable(false);
        this.taskTypeDesc_.setWrapStyleWord(true);
        this.taskTypeDesc_.setLineWrap(true);
        this.taskTypeDesc_.setText("Task Description");
        this.taskTypeDesc_.setBackground(UIManager.getColor("CheckBoxMenuItem.background"));
        this.taskTypeDesc_.setFont(new Font("Dialog", 0, 12));
        this.getContentPane().add((Component)this.buttonPanel_, "South");
        this.buttonPanel_.add((Component)this.closeButtonGridPanel_, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.closeButtonGridPanel_.add((Component)this.closeButton_, null);
        this.closeButtonGridPanel_.add((Component)this.helpButton_, null);
        this.buttonPanel_.add((Component)this.editButtonPanel_, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editButtonPanel_.add((Component)this.editButtonInnerPanel_, null);
        this.editButtonInnerPanel_.add((Component)this.addButton_, null);
        this.editButtonInnerPanel_.add((Component)this.changeButton_, null);
        this.editButtonInnerPanel_.add((Component)this.resetButton_, null);
        this.buttonPanel_.add((Component)this.statusLabel_, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.mainPanel_, "Center");
        this.mainPanel_.add((Component)this.taskPanel_, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.taskTypeLabel_, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 10, 0), 0, 0));
        this.mainPanel_.add((Component)this.taskTypeComboBox_, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 10, 0), 0, 0));
        this.mainPanel_.add((Component)this.taskNameLabel_, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(17, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.nameTextField_, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(17, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.editorScrollPane_, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.descriptionLabel_, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 0, 0), 3, 0));
        this.mainPanel_.add((Component)this.deleteButton_, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(36, 10, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.descriptionScrollPane_, new GridBagConstraints(0, 5, 4, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel_.add((Component)this.taskTypeDesc_, new GridBagConstraints(2, 2, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 20, 0, 0), 0, 0));
        this.descriptionScrollPane_.getViewport().add((Component)this.descriptionTextArea_, null);
    }

    private void showEditor(String string, String string2) {
        int n = 0;
        while (n < this.taskTypes_.length) {
            if (this.taskTypes_[n].getTaskTypeString().equals(string)) {
                this.showEditor(this.taskTypes_[n], string2, true);
                return;
            }
            ++n;
        }
        this.showEditor(null, string2);
        this.setStatusMessage(CgUtility.getI18nMsg("task.noEditor"));
    }

    private void repaintEditor() {
        this.editorScrollPane_.getViewport().invalidate();
        this.editorScrollPane_.getViewport().validate();
        this.editorScrollPane_.getViewport().repaint();
    }

    private void showEditor(SMTaskType sMTaskType, String string, boolean bl) {
        SMTaskEditorFactory sMTaskEditorFactory;
        Class clazz;
        Object object;
        if (this.editor_ != null) {
            this.editor_.cleanup();
            this.editorScrollPane_.getViewport().remove((Component)this.editor_);
            this.editor_ = null;
            this.editorEx_ = null;
        }
        this.allowNameChangeNotification_ = false;
        this.nameTextField_.setText(string);
        this.descriptionTextArea_.setText("");
        this.taskType_ = sMTaskType;
        this.realignFields();
        if (this.taskType_ == null) {
            this.repaintEditor();
            return;
        }
        String string2 = this.taskType_.getConsoleClassName();
        try {
            object = BsRMIClassLoader.getClassLoader((RMIClientLevel1)SMConsoleContext.getInstance().getAPIHandle().getHandle());
            clazz = object.loadClass(string2, true);
            sMTaskEditorFactory = (SMTaskEditorFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            this.setStatusMessage(CgUtility.getI18nMsg("task.noEditor"));
            System.err.println(exception);
            this.repaintEditor();
            return;
        }
        object = null;
        clazz = null;
        if (sMTaskEditorFactory != null) {
            clazz = sMTaskEditorFactory.getInstance((SMTaskEditorManager)this, this.taskHandle_, this.handle_, false);
            if (clazz == null) {
                this.setStatusMessage(CgUtility.getI18nMsg("task.noEditor"));
            } else if (!(clazz instanceof Component)) {
                System.out.println("Task editor must be a subclass of Component");
            } else {
                object = (Component)((Object)clazz);
                if (bl && this.taskPanel_.getSelectedTask() != null && string != null && !string.equals("")) {
                    this.loadTask(string);
                }
            }
        }
        if (object != null) {
            this.editorScrollPane_.getViewport().add((Component)object);
            this.editor_ = clazz;
            if (this.editor_ instanceof SMTaskEditorEx) {
                this.editorEx_ = (SMTaskEditorEx)this.editor_;
            }
        }
        this.repaintEditor();
    }

    private void save(final boolean bl, SMTaskData sMTaskData) {
        if (sMTaskData == null) {
            return;
        }
        SMTaskData sMTaskData2 = null;
        if (!bl && this.task_ != null) {
            sMTaskData2 = (SMTaskData)this.task_.clone();
            sMTaskData2.setObjectID(this.task_.getObjectID());
            try {
                this.task_.setName(sMTaskData.getName());
                this.task_.setDescription(sMTaskData.getDescription());
                this.task_.setOperations(sMTaskData.getOperations());
            }
            catch (SMLengthException sMLengthException) {
                // empty catch block
            }
            sMTaskData = this.task_;
        }
        final SMTaskData sMTaskData3 = sMTaskData2;
        final SMTaskData sMTaskData4 = sMTaskData;
        this.setBusy(true);
        this.setStatusMessage(CgUtility.getI18nMsg("standard.saving") + "...");
        final CgTaskManager cgTaskManager = this;
        Thread thread = new Thread(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block10: {
                    block9: {
                        try {
                            CgTaskManager.this.setModified(false);
                            if (CgTaskManager.this.editorEx_ == null) {
                                CgTaskManager.this.taskPanel_.getTable().clearSelection();
                                if (!CgUtility.saveObj(cgTaskManager, (SMHandle)CgTaskManager.this.taskHandle_, (SMDBObject)sMTaskData4)) {
                                    CgTaskManager.this.setModified(true);
                                }
                            } else {
                                CgTaskManager.this.setModified(true);
                                if (bl) {
                                    if (!CgUtility.saveObj(cgTaskManager, (SMHandle)CgTaskManager.this.taskHandle_, (SMDBObject)sMTaskData4) || !CgTaskManager.this.editorEx_.add(sMTaskData4)) {
                                        CgTaskManager.this.setModified(true);
                                        Object var2_1 = null;
                                        CgTaskManager.this.clearStatusMessage();
                                        CgTaskManager.this.setBusy(false);
                                        return;
                                    }
                                } else if (!(CgUtility.saveObj(cgTaskManager, (SMHandle)CgTaskManager.this.taskHandle_, (SMDBObject)sMTaskData4, true, false) && CgTaskManager.this.editorEx_.change(sMTaskData3, sMTaskData4) && CgUtility.saveObj(cgTaskManager, (SMHandle)CgTaskManager.this.taskHandle_, (SMDBObject)sMTaskData4, false))) {
                                    CgTaskManager.this.setModified(true);
                                    break block9;
                                }
                                CgTaskManager.this.load();
                                CgTaskManager.this.editorEx_.saved(sMTaskData4.getObjectID());
                            }
                            CgUtility.setLastEditedTask(sMTaskData4.getName());
                            break block10;
                        }
                        catch (Throwable throwable) {
                            Object var2_4 = null;
                            CgTaskManager.this.clearStatusMessage();
                            CgTaskManager.this.setBusy(false);
                            throw throwable;
                        }
                    }
                    Object var2_2 = null;
                    CgTaskManager.this.clearStatusMessage();
                    CgTaskManager.this.setBusy(false);
                    return;
                }
                Object var2_3 = null;
                CgTaskManager.this.clearStatusMessage();
                CgTaskManager.this.setBusy(false);
            }
        };
        thread.start();
    }

    private SMTaskData getNewData() {
        this.clearStatusMessage();
        if (this.nameTextField_.getText() == null || this.nameTextField_.getText().trim().equals("")) {
            this.setStatusMessage(CgUtility.getI18nMsg("task.taskNameRequired"));
            Toolkit.getDefaultToolkit().beep();
            return null;
        }
        if (!this.editor_.validateData()) {
            Toolkit.getDefaultToolkit().beep();
            return null;
        }
        SMTaskOperationData[] sMTaskOperationDataArray = this.editor_.getOperationData();
        if (sMTaskOperationDataArray == null || sMTaskOperationDataArray.length == 0) {
            this.setStatusMessage(CgUtility.getI18nMsg("task.incompleteData"));
            Toolkit.getDefaultToolkit().beep();
            return null;
        }
        SMTaskData sMTaskData = new SMTaskData();
        try {
            sMTaskData.setName(this.nameTextField_.getText().trim());
            sMTaskData.setDescription(this.descriptionTextArea_.getText().trim());
        }
        catch (SMLengthException sMLengthException) {
            // empty catch block
        }
        sMTaskData.setTaskType(this.taskType_.getTaskTypeString());
        sMTaskData.setOperations(sMTaskOperationDataArray);
        return sMTaskData;
    }

    private void resetForm() {
        if (this.taskType_ == null && this.taskTypes_ != null) {
            this.taskType_ = this.taskTypes_[0];
            this.taskTypeComboBox_.setSelectedIndex(0);
        }
        this.showEditor(this.taskType_, null, false);
        this.task_ = null;
        this.addButton_.setEnabled(false);
        this.changeButton_.setEnabled(false);
        this.taskTypeComboBox_.setEnabled(true);
        this.taskPanel_.getTable().clearSelection();
        this.deleteButton_.setEnabled(false);
        this.clearStatusMessage();
        this.currentRow_ = -1;
        this.cleared_ = true;
        this.modified_ = false;
        this.nameTextField_.requestFocus();
    }

    public void changed(SMDBChangeEvent sMDBChangeEvent) throws SMAPIException {
        if (!this.modified_ && this.taskPanel_.getSelectedRow() < 0) {
            this.load();
        } else {
            this.reloadNeeded_ = true;
        }
    }

    private void tableRowSelected(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.taskPanel_.getSelectedRow();
        if (n < 0) {
            this.currentRow_ = -1;
            return;
        }
        if (this.currentRow_ == n) {
            return;
        }
        if (this.modified_ && !CgUtility.confirmDiscardChanges(this, CgUtility.getI18nMsg("standard.askDiscardChanges"))) {
            this.taskPanel_.selectRow(this.currentRow_);
            if (this.reloadNeeded_) {
                this.load();
            }
            return;
        }
        this.setModified(false);
        this.currentRow_ = n;
        SMTaskInfo sMTaskInfo = this.taskPanel_.getSelectedTask();
        this.showEditor(sMTaskInfo.getTaskTypeString(), sMTaskInfo.getName());
        this.taskTypeComboBox_.setEnabled(false);
        this.taskTypeComboBox_.setSelectedItem(this.taskType_);
    }

    void closeButton__actionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    void deleteButton__actionPerformed(ActionEvent actionEvent) {
        if (this.task_ == null) {
            return;
        }
        if (!CgUtility.confirmDelete(this, CgUtility.getI18nMsg("task.askTaskDelete"))) {
            return;
        }
        this.setBusy(true);
        this.setStatusMessage(CgUtility.getI18nMsg("standard.deleting") + "...");
        Thread thread = new Thread(){

            public void run() {
                try {
                    try {
                        if (CgTaskManager.this.editorEx_ != null && !CgTaskManager.this.editorEx_.delete(CgTaskManager.this.task_)) {
                            Object var3_1 = null;
                            CgTaskManager.this.clearStatusMessage();
                            CgTaskManager.this.setBusy(false);
                            return;
                        }
                        SMDBObjectID sMDBObjectID = CgTaskManager.this.task_.getObjectID();
                        CgTaskManager.this.resetForm();
                        CgTaskManager.this.taskHandle_.delete(sMDBObjectID);
                    }
                    catch (SMAPIException sMAPIException) {
                        CgUtility.handleError(sMAPIException);
                        Object var3_3 = null;
                        CgTaskManager.this.clearStatusMessage();
                        CgTaskManager.this.setBusy(false);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    CgTaskManager.this.clearStatusMessage();
                    CgTaskManager.this.setBusy(false);
                    throw throwable;
                }
                Object var3_2 = null;
                CgTaskManager.this.clearStatusMessage();
                CgTaskManager.this.setBusy(false);
            }
        };
        thread.start();
    }

    void taskTypeComboBox__itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        if (this.currentTaskTypeIndex_ == this.taskTypeComboBox_.getSelectedIndex()) {
            return;
        }
        if (this.modified_ && !CgUtility.confirmDiscardChanges(this, CgUtility.getI18nMsg("standard.askDiscardChanges"))) {
            if (this.currentTaskTypeIndex_ >= 0) {
                this.taskTypeComboBox_.setSelectedIndex(this.currentTaskTypeIndex_);
            }
            return;
        }
        this.currentTaskTypeIndex_ = this.taskTypeComboBox_.getSelectedIndex();
        SMTaskType sMTaskType = (SMTaskType)this.taskTypeComboBox_.getSelectedItem();
        String string = sMTaskType.getTaskTypeDescriptionKey();
        if (string != null && !string.equals("")) {
            String string2 = UcInternationalizer.translateKey((String)string);
            this.taskTypeDesc_.setText(string2);
        } else {
            this.taskTypeDesc_.setText("");
        }
        if (this.taskPanel_.getSelectedTask() == null) {
            this.showEditor((SMTaskType)this.taskTypeComboBox_.getSelectedItem(), this.getTaskName(), false);
        }
    }

    void resetButton__actionPerformed(ActionEvent actionEvent) {
        this.clearStatusMessage();
        if (this.modified_ && !CgUtility.confirmDiscardChanges(this, CgUtility.getI18nMsg("standard.askDiscardChanges"))) {
            return;
        }
        this.resetForm();
        if (this.reloadNeeded_) {
            this.load();
        }
    }

    void changeButton__actionPerformed(ActionEvent actionEvent) {
        SMTaskData sMTaskData = this.getNewData();
        if (sMTaskData == null) {
            return;
        }
        this.save(false, sMTaskData);
    }

    void addButton__actionPerformed(ActionEvent actionEvent) {
        SMTaskData sMTaskData = this.getNewData();
        if (sMTaskData == null) {
            return;
        }
        this.save(true, sMTaskData);
    }

    void helpButton__actionPerformed(ActionEvent actionEvent) {
        CmConsoleSession.getInstance().launchHelp("grouping-task-manager-help");
    }

    static /* synthetic */ SMTaskType[] access$302(CgTaskManager cgTaskManager, SMTaskType[] sMTaskTypeArray) {
        cgTaskManager.taskTypes_ = sMTaskTypeArray;
        return sMTaskTypeArray;
    }

    static /* synthetic */ SMTaskEditor access$800(CgTaskManager cgTaskManager) {
        return cgTaskManager.editor_;
    }

    static /* synthetic */ boolean access$902(CgTaskManager cgTaskManager, boolean bl) {
        cgTaskManager.cleared_ = bl;
        return cgTaskManager.cleared_;
    }

    static /* synthetic */ boolean access$1002(CgTaskManager cgTaskManager, boolean bl) {
        cgTaskManager.allowNameChangeNotification_ = bl;
        return cgTaskManager.allowNameChangeNotification_;
    }

    class MyDocumentListener
    implements DocumentListener {
        private Object id_;

        public MyDocumentListener(Object object) {
            this.id_ = object;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            CgTaskManager.this.documentChanged(this.id_);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            CgTaskManager.this.documentChanged(this.id_);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            CgTaskManager.this.documentChanged(this.id_);
        }
    }
}

