/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping;

import com.sun.symon.base.client.SMUtility;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class CgFieldValidator
extends PlainDocument {
    public static final long ANY = 1L;
    public static final long NUMERIC = 2L;
    public static final long FILENAME = 4L;
    public static final long NOT_START_WITH_UNDERSCORE = 8L;
    public static final long IP_ADDRESS = 16L;
    public static final long ALL_CHARACTERS = 0L;
    private int length_;
    private long bitFlags_;

    public CgFieldValidator(int n, long l) {
        this.length_ = n;
        this.bitFlags_ = l;
    }

    private void reject() {
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) {
            super.insertString(n, string, attributeSet);
            return;
        }
        if (string.length() == 0) {
            return;
        }
        if (this.length_ > 0 && this.getLength() + string.length() > this.length_) {
            this.reject();
            return;
        }
        if (this.bitFlags_ != 0L && SMUtility.validate((String)string) >= 0) {
            this.reject();
            return;
        }
        if (this.bitFlags_ != 1L && this.bitFlags_ != 0L) {
            if ((this.bitFlags_ & 2L) != 0L) {
                try {
                    Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.reject();
                    return;
                }
            }
            if ((this.bitFlags_ & 4L) != 0L && !this.isValidFilename(string)) {
                this.reject();
                return;
            }
            if ((this.bitFlags_ & 8L) != 0L && n == 0 && (string.startsWith("_") || string.startsWith(" "))) {
                this.reject();
                return;
            }
            if ((this.bitFlags_ & 0x10L) != 0L && !this.isValidIPAddress(string)) {
                this.reject();
                return;
            }
        }
        super.insertString(n, string, attributeSet);
    }

    private boolean isValidFilename(String string) {
        if (string.equals(".")) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c <= '\u007f' && !Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != '.') {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isValidIPAddress(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '.' && !Character.isDigit(c)) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

