/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.hardview.console.presentation;

import com.sun.symon.apps.hardview.console.presentation.ListEntry;
import com.sun.symon.apps.hardview.console.presentation.SMHvSummary;
import com.sun.symon.apps.hardview.console.presentation.TreeCombo;
import com.sun.symon.apps.hardview.console.presentation.ViewNode;
import com.sun.symon.apps.lv.console.presentation.SMLvBean;
import com.sun.symon.apps.pv.console.presentation.SMPvBean;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMManagedEntityRequest;
import com.sun.symon.base.client.SMPropertyData;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.table.SMTableFormat;
import com.sun.symon.base.client.table.SMTableRequest;
import com.sun.symon.base.client.table.SMTableResponse;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class SMHvBean
extends JPanel
implements ItemListener,
SMTableResponse,
Runnable {
    private int agentPort;
    private String agentHost;
    private String configdName;
    SMRawDataRequest rawReq;
    SMManagedEntityRequest mReq;
    JLabel statusMsg;
    static final String hvKey = "base.console.ConsoleGeneric:details.hwResources";
    static final String pvKey = "base.console.ConsoleGeneric:details.pv";
    static final String lvKey = "base.console.ConsoleGeneric:details.lv";
    String sumItem = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:details.hwResources");
    String pvItem = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:details.pv");
    String lvItem = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:details.lv");
    int oldItemIndex = 0;
    static final String sumCate = "Summary";
    static final String pvCate = "PV";
    static final String lvCate = "LV";
    static final String greyCate = "Grey";
    SMLvBean lvBean;
    SMPvBean pvBean;
    SMHvSummary sumBean;
    boolean lvFirst = true;
    boolean pvFirst = true;
    DefaultTreeModel treeModel;
    DefaultMutableTreeNode hdviewNode;
    DefaultMutableTreeNode hdsumNode;
    DefaultMutableTreeNode lvNode;
    DefaultMutableTreeNode pvNode;
    DefaultMutableTreeNode lastNode = null;
    ViewNode lastview = null;
    ViewNode vn = null;
    TreeCombo viewCombo;
    JPanel cbPanel;
    JPanel vpPanel;
    Hashtable hvCache;
    Hashtable treeDataCache;
    Hashtable compDataCache;
    Hashtable propCache;
    Hashtable treePropOrderCache;
    Hashtable rawTreePropCache;
    Object hdtabThread;

    public SMHvBean() {
        this.setLayout(new BorderLayout());
        this.statusMsg = null;
    }

    public void init() {
        String string;
        this.cbPanel = new JPanel();
        this.cbPanel.setLayout(new BoxLayout(this.cbPanel, 0));
        this.cbPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.hvCache = new Hashtable();
        this.treeDataCache = new Hashtable();
        this.compDataCache = new Hashtable();
        this.propCache = new Hashtable();
        this.treePropOrderCache = new Hashtable();
        this.rawTreePropCache = new Hashtable();
        try {
            string = InetAddress.getByName(this.agentHost).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = this.agentHost;
        }
        this.hdviewNode = new DefaultMutableTreeNode(new ViewNode(string, null, null, 0, greyCate));
        this.sumBean = new SMHvSummary();
        this.sumBean.setHvBean(this);
        this.sumBean.setRawDataRequestHandle(this.rawReq);
        this.sumBean.setAgentHost(this.agentHost);
        this.sumBean.setAgentPort(this.agentPort);
        this.sumBean.setModuleName(this.configdName);
        this.sumBean.init();
        if (this.sumBean.isHwSummaryAvailable()) {
            this.hdsumNode = new DefaultMutableTreeNode(new ViewNode(this.sumItem, null, null, 0, sumCate));
            this.hdviewNode.add(this.hdsumNode);
        }
        this.lvNode = new DefaultMutableTreeNode(new ViewNode(this.lvItem, null, null, 0, greyCate));
        this.pvNode = new DefaultMutableTreeNode(new ViewNode(this.pvItem, null, null, 0, greyCate));
        this.hdviewNode.add(this.pvNode);
        this.hdviewNode.add(this.lvNode);
        this.treeModel = new DefaultTreeModel(this.hdviewNode);
        JLabel jLabel = new JLabel(this.getI18NString("Views"));
        this.cbPanel.add(jLabel);
        this.cbPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        this.viewCombo = new TreeCombo(this.treeModel);
        this.viewCombo.setMinimumSize(new Dimension(260, 27));
        this.viewCombo.setMaximumSize(new Dimension(260, 27));
        this.viewCombo.setEditable(false);
        jLabel.setDisplayedMnemonic(this.getI18NString("Views.mnemonic").charAt(0));
        jLabel.setLabelFor(this.viewCombo);
        this.cbPanel.add(this.viewCombo);
        this.cbPanel.add(Box.createRigidArea(new Dimension(100, 0)));
        this.add((Component)this.cbPanel, "North");
        this.vpPanel = new JPanel();
        this.vpPanel.setLayout(new CardLayout());
        this.vpPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, Color.gray));
        this.lvBean = new SMLvBean();
        this.pvBean = new SMPvBean();
        this.lvBean.setHvBean(this);
        this.pvBean.setHvBean(this);
        this.pvBean.setCaches(this.treeDataCache, this.compDataCache, this.propCache, this.treePropOrderCache, this.rawTreePropCache);
        this.lvBean.setCaches(this.treeDataCache, this.compDataCache, this.propCache, this.treePropOrderCache, this.rawTreePropCache);
        this.vpPanel.add((Component)this.pvBean, this.pvItem);
        this.vpPanel.add((Component)this.lvBean, this.lvItem);
        this.getHdregTable();
        this.viewCombo.addItemListener(this);
        if (this.sumBean.isHwSummaryAvailable()) {
            this.vpPanel.add((Component)this.sumBean, this.sumItem);
            this.viewCombo.setSelectedItem(this.hdsumNode);
        } else {
            this.viewCombo.setSelectedItem(this.pvNode);
        }
        this.add((Component)this.vpPanel, "Center");
        this.getAccessibleContext().setAccessibleDescription(UcInternationalizer.translateKey((String)"com.sun.symon.base.console.AccessibleDescription:hardwareTab.description"));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ListEntry listEntry = (ListEntry)itemEvent.getItem();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)listEntry.object();
        ViewNode viewNode = (ViewNode)defaultMutableTreeNode.getUserObject();
        int n = this.viewCombo.getItemCount();
        if (itemEvent.getStateChange() == 2) {
            int n2 = 0;
            while (n2 < n) {
                if (this.viewCombo.getItemAt(n2).equals(listEntry)) {
                    this.oldItemIndex = n2;
                    break;
                }
                ++n2;
            }
            if (defaultMutableTreeNode.isLeaf()) {
                this.lastNode = defaultMutableTreeNode;
            }
            return;
        }
        if (viewNode == this.lastview || viewNode == null || viewNode == this.vn) {
            return;
        }
        if (!defaultMutableTreeNode.isLeaf() || defaultMutableTreeNode == this.pvNode || defaultMutableTreeNode == this.lvNode) {
            int n3 = -1;
            int n4 = this.viewCombo.getSelectedIndex();
            if (n4 > this.oldItemIndex) {
                int n5 = n4;
                while (n5 < n) {
                    ListEntry listEntry2 = (ListEntry)this.viewCombo.getItemAt(n5);
                    DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)listEntry2.object();
                    ViewNode viewNode2 = (ViewNode)defaultMutableTreeNode2.getUserObject();
                    if (viewNode2.category != greyCate) {
                        n3 = n5;
                        break;
                    }
                    ++n5;
                }
                if (n3 >= 0) {
                    this.viewCombo.setSelectedIndex(n3);
                } else if (this.lastNode != null) {
                    this.viewCombo.setSelectedItem(this.lastNode);
                }
            } else {
                int n6 = n4;
                while (n6 >= 0) {
                    ListEntry listEntry3 = (ListEntry)this.viewCombo.getItemAt(n6);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)listEntry3.object();
                    ViewNode viewNode3 = (ViewNode)defaultMutableTreeNode3.getUserObject();
                    if (viewNode3.category != greyCate) {
                        n3 = n6;
                        break;
                    }
                    --n6;
                }
                if (n3 >= 0) {
                    this.viewCombo.setSelectedIndex(n3);
                } else if (this.lastNode != null) {
                    this.viewCombo.setSelectedItem(this.lastNode);
                }
            }
            return;
        }
        this.vn = viewNode;
        new Thread(this).start();
    }

    public void run() {
        this.pvBean.busyProcessStart();
        if (this.lastview != null) {
            if (this.lastview.category.equals(lvCate)) {
                this.lvBean.cleanup();
            } else if (this.lastview.category.equals(pvCate)) {
                this.pvBean.cleanup();
            }
        }
        if (this.vn.category().equals(lvCate)) {
            CardLayout cardLayout = (CardLayout)this.vpPanel.getLayout();
            cardLayout.show(this.vpPanel, this.lvItem);
            this.lvBean.setRawDataRequestHandle(this.rawReq);
            this.lvBean.setAgentHost(this.agentHost);
            this.lvBean.setAgentPort(this.agentPort);
            this.lvBean.setModuleName(this.vn.moduleName());
            this.lvBean.setWindowStatusField(this.statusMsg);
            this.lvBean.setElementName(this.vn.rootName());
            this.lvBean.setElementInstance(this.vn.instance());
            if (this.lvFirst) {
                this.lvFirst = false;
                this.lvBean.init();
            } else {
                this.lvBean.reinit();
            }
        } else if (this.vn.category().equals(pvCate)) {
            CardLayout cardLayout = (CardLayout)this.vpPanel.getLayout();
            cardLayout.show(this.vpPanel, this.pvItem);
            this.pvBean.setRawDataRequestHandle(this.rawReq);
            this.pvBean.setAgentHost(this.agentHost);
            this.pvBean.setAgentPort(this.agentPort);
            this.pvBean.setModuleName(this.vn.moduleName());
            this.pvBean.setWindowStatusField(this.statusMsg);
            this.pvBean.setElementName(this.vn.rootName());
            this.pvBean.setElementInstance(this.vn.instance());
            if (this.pvFirst) {
                this.pvFirst = false;
                this.pvBean.init();
            } else {
                this.pvBean.reinit();
            }
        } else if (this.vn.category().equals(sumCate)) {
            CardLayout cardLayout = (CardLayout)this.vpPanel.getLayout();
            cardLayout.show(this.vpPanel, this.sumItem);
        }
        this.lastview = this.vn;
        this.pvBean.busyProcessEnd();
    }

    public void getHdregTable() {
        this.postStatus(this.getI18NString("loadingHdres"));
        String string = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/hdreg/hdreg-table/hdreg-entry";
        String[] stringArray = new String[]{string + "/" + "modname", string + "/" + "rootoid", string + "/" + "label", string + "/" + "svflag"};
        try {
            SMTableRequest sMTableRequest = new SMTableRequest(this.rawReq);
            this.hdtabThread = sMTableRequest.getTableFieldRequest(stringArray, true, "0", (SMTableResponse)this, null);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)sMAPIException.getMessage());
        }
    }

    public void getTableFieldResponse(SMRequestStatus sMRequestStatus, String[][] stringArray, Object object) {
        try {
            this.rawReq.removeURLRequest(this.hdtabThread);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = sMRequestStatus.getReturnCode();
        String string = this.getI18NString("system");
        if (n != 0) {
            this.addLvView(this.configdName, "system", string, "S", 0, this.lvNode);
            this.addPvView(this.configdName, "system", string, "S", 0, this.pvNode);
            this.postStatus(this.getI18NString("loadingHdregFailed"));
            return;
        }
        int n2 = 0;
        while (n2 < stringArray[0].length) {
            if (stringArray[0][n2].equals(this.configdName)) break;
            ++n2;
        }
        boolean bl = false;
        boolean bl2 = false;
        if (n2 < stringArray[0].length) {
            String string2;
            string = this.getI18NString(stringArray[2][n2]);
            if (string.startsWith(string2 = "com.sun.symon.apps.hardview.console.presentation.HardView:")) {
                string = stringArray[2][n2];
            }
            bl = this.addLvView(stringArray[0][n2], stringArray[1][n2], string, stringArray[3][n2], 0, this.lvNode);
            bl2 = this.addPvView(stringArray[0][n2], stringArray[1][n2], string, stringArray[3][n2], 0, this.pvNode);
        } else {
            bl = this.addLvView(this.configdName, "system", string, "S", 0, this.lvNode);
            bl2 = this.addPvView(this.configdName, "system", string, "S", 0, this.pvNode);
        }
        n2 = 0;
        while (n2 < stringArray[0].length) {
            if (!stringArray[0][n2].equals(this.configdName)) {
                bl = this.addLvView(stringArray[0][n2], stringArray[1][n2], stringArray[2][n2], stringArray[3][n2], 0, this.lvNode);
                bl2 = this.addPvView(stringArray[0][n2], stringArray[1][n2], stringArray[2][n2], stringArray[3][n2], 0, this.pvNode);
            }
            ++n2;
        }
        if (bl && bl2) {
            this.postStatus("");
        }
    }

    public void getTableLayoutResponse(SMRequestStatus sMRequestStatus, SMTableFormat[] sMTableFormatArray, Object object) {
    }

    public void getTableAlarmStatusResponse(SMRequestStatus sMRequestStatus, SMAlarmStatusData[][] sMAlarmStatusDataArray, Object object) {
    }

    boolean addPvView(String string, String string2, String string3, String string4, int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string5 = string2;
        int n2 = n;
        boolean bl = false;
        String string6 = string + ":" + string5 + ":" + n2;
        String string7 = (String)this.hvCache.get(string6);
        if (string7 == null) {
            boolean bl2 = this.getSmprops(string, string5);
            if (!bl2) {
                return false;
            }
            string7 = (String)this.hvCache.get(string6);
        }
        while (string7 != null) {
            boolean bl3;
            StringTokenizer stringTokenizer = new StringTokenizer(string7, ":");
            if (stringTokenizer.countTokens() != 11) {
                return false;
            }
            String string8 = stringTokenizer.nextToken();
            if (string3 != null) {
                string8 = string3;
            }
            String string9 = stringTokenizer.nextToken();
            String string10 = stringTokenizer.nextToken();
            int n3 = new Integer(stringTokenizer.nextToken());
            int n4 = new Integer(stringTokenizer.nextToken());
            --n4;
            String string11 = string3 != null ? (string4.equals("V") ? string8 + "(" + n2 + ")" : string8) : string8;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ViewNode(string11, string, string5, n2 + 1, pvCate));
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            String string12 = stringTokenizer.nextToken();
            if (string12.equals("-")) {
                if (string9.equals("null")) {
                    this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
                } else {
                    bl3 = this.addPvView(string, string9, null, string4, n3 - 1, defaultMutableTreeNode2);
                    if (!bl3) {
                        this.treeModel.removeNodeFromParent(defaultMutableTreeNode2);
                    }
                }
            }
            if (string10.equals("null")) break;
            string6 = string + ":" + string10 + ":" + n4;
            string7 = (String)this.hvCache.get(string6);
            if (string7 == null) {
                bl3 = this.getSmprops(string, string10);
                if (!bl3) {
                    return false;
                }
                string7 = (String)this.hvCache.get(string6);
            }
            string5 = string10;
            n2 = n4;
        }
        return true;
    }

    boolean addLvView(String string, String string2, String string3, String string4, int n, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string5 = string2;
        int n2 = n;
        String string6 = string + ":" + string5 + ":" + n2;
        String string7 = (String)this.hvCache.get(string6);
        if (string7 == null) {
            boolean bl = this.getSmprops(string, string2);
            if (!bl) {
                return false;
            }
            string7 = (String)this.hvCache.get(string6);
        }
        while (string7 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string7, ":");
            if (stringTokenizer.countTokens() != 11) {
                return false;
            }
            String string8 = stringTokenizer.nextToken();
            if (string3 != null) {
                string8 = string3;
            }
            String string9 = string3 != null ? (string4.equals("V") ? string8 + "(" + n2 + ")" : string8) : string8;
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ViewNode(string9, string, string5, n2 + 1, lvCate));
            this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
            stringTokenizer.nextToken();
            String string10 = stringTokenizer.nextToken();
            if (string10.equals("null")) break;
            stringTokenizer.nextToken();
            int n3 = new Integer(stringTokenizer.nextToken());
            string6 = string + ":" + string10 + ":" + --n3;
            string7 = (String)this.hvCache.get(string6);
            if (string7 == null) {
                boolean bl = this.getSmprops(string, string5);
                if (!bl) {
                    return false;
                }
                string7 = (String)this.hvCache.get(string6);
            }
            string5 = string10;
            n2 = n3;
        }
        return true;
    }

    boolean getSmprops(String string, String string2) {
        String string3 = null;
        boolean bl = true;
        this.mReq = new SMManagedEntityRequest(this.rawReq);
        Vector vector = new Vector();
        String string4 = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + string;
        try {
            vector = this.mReq.getPropertyDataList(string4, string2);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)sMAPIException.getMessage());
            if (sMAPIException.getReasonCode() == 1) {
                String string5 = "base.console.ConsoleGeneric:modules.noaccess";
                this.postStatus(UcInternationalizer.translateKey((String)string5));
            }
            return false;
        }
        int n = 0;
        while (n < vector.size()) {
            string3 = ((SMPropertyData)vector.elementAt(n)).getPropertyName();
            bl = ((SMPropertyData)vector.elementAt(n)).getPropertyType();
            if (string3.endsWith("sunSmTreeProp")) break;
            ++n;
        }
        if (string3 == null) {
            return false;
        }
        int n2 = string3.indexOf("sunSmTreeProp");
        String string6 = new String("");
        String string7 = new String("");
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = new Vector();
        if (n2 > 0) {
            try {
                string7 = string3.substring(0, n2);
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (n2 >= 0) {
            if (bl) {
                try {
                    string6 = SMRawDataRequest.createURL((String)string4, (String)string2, (String)(string7 + "sunSmTreeProp"), (String)"", (String)"");
                }
                catch (Exception exception) {
                    return false;
                }
                vector2.addElement(string6 + "#0");
            } else {
                try {
                    string6 = SMRawDataRequest.createURL((String)string4, (String)string2, (String)(string7 + "sunSmTreeProp"), (String)"", (String)"");
                }
                catch (Exception exception) {
                    return false;
                }
                vector2.addElement(string6);
            }
        }
        try {
            vector3 = this.rawReq.getURLValue(vector2);
        }
        catch (SMAPIException sMAPIException) {
            UcDDL.logWarningMessage((String)sMAPIException.getMessage());
            return false;
        }
        Vector vector4 = (Vector)vector3.elementAt(0);
        String string8 = vector4.elementAt(0).toString();
        if (bl) {
            this.hvCache.put(string + ":" + string2 + ":" + "0", string8);
        } else {
            Vector vector5 = new Vector();
            boolean bl2 = UcListUtil.decomposeList((String)string8, vector5);
            if (!bl2) {
                return false;
            }
            int n3 = 0;
            while (n3 < vector5.size()) {
                this.hvCache.put(string + ":" + string2 + ":" + n3, vector5.elementAt(n3));
                ++n3;
            }
        }
        return true;
    }

    public void postStatus(String string) {
        if (this.statusMsg != null) {
            this.statusMsg.setText(string);
            this.statusMsg.validate();
        }
    }

    public String getI18NString(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.apps.hardview.console.presentation.HardView:" + string));
    }

    public void cleanUp() {
        this.sumBean.cleanUp();
        this.pvBean.cleanup();
        this.lvBean.cleanup();
        Container container = this.getParent();
        if (container != null) {
            container.remove(this);
        }
    }

    public void setWindowStatusField(Object object) {
        this.statusMsg = (JLabel)object;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.rawReq = sMRawDataRequest;
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public void setModuleName(String string) {
        this.configdName = string;
    }

    public SMRawDataRequest getRawRequestHandle() {
        return this.rawReq;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public String getModuleName() {
        return this.configdName;
    }

    public JPanel getCbPanel() {
        return this.cbPanel;
    }

    public static boolean isGreyNode(ListEntry listEntry) {
        if (listEntry.isNode()) {
            return true;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)listEntry.object();
        ViewNode viewNode = (ViewNode)defaultMutableTreeNode.getUserObject();
        return viewNode.category() == greyCate;
    }
}

