/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.dr.console.presentation;

import com.sun.symon.apps.dr.console.presentation.DrException;
import com.sun.symon.apps.dr.console.presentation.DrJFCTable;
import com.sun.symon.apps.dr.console.presentation.DrJFCTableModel;
import com.sun.symon.apps.dr.console.presentation.DrStateDialog;
import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRawDataResponse;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.module.SMModuleRequest;
import com.sun.symon.base.server.types.StObject;
import com.sun.symon.base.server.types.StString;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;

public class SymonDrTable
extends JDialog
implements ActionListener,
SMRawDataResponse {
    public static final String DR_OP_CONNECT = "connect";
    public static final String DR_OP_DISCONNECT = "disconnect";
    public static final String DR_OP_CONFIGURE = "configure";
    public static final String DR_OP_UNCONFIGURE = "unconfigure";
    public static final String DR_OP_TEST = "test";
    public static final String DR_OP_SEC_ERROR = "security_error";
    public static final String DR_STATE_CONNECTED = "connected";
    public static final String DR_STATE_DISCONNECTED = "disconnected";
    public static final String DR_STATE_EMPTY = "empty";
    public static final String DR_STATE_CONFIGURED = "configured";
    public static final String DR_STATE_UNCONFIGURED = "unconfigured";
    public static final String DR_MEMORY = "memory";
    public static final String DR_TESTTYPE = "cmdNode";
    public static final String DR_RECEPTACLE = "Receptacle";
    public static final String DR_OCCUPANT = "Occupant";
    public static final String DR_CMDSTATUSNODE = "cmdStatusNode";
    public static final String DR_BOARD_ID = "Ap_Id";
    public static final String DR_TYPE = "Type";
    public static final String DR_BUSY = "Busy";
    public static final String DR_Y = "y";
    public static final String QUICK_TEST = "quick";
    public static final String NORMAL_TEST = "normal";
    public static final String EXTENDED_TEST = "extended";
    public static final String DR_INFO_COL = "Information";
    public static Object lock = new Object();
    String[] columnNames;
    boolean[] columnVisible;
    int[] columnPosition;
    final String[] columnNamesOld = new String[]{"Ap_Id", "Receptacle", "Occupant", "Condition", "Information", "Type", "Busy", "Phys_Id"};
    final String[] columnNamesNew = new String[]{"Ap_Id", "Receptacle", "Occupant", "Condition", "Information", "When", "Type", "Busy", "Phys_Id", "cmdStatusNode"};
    final boolean[] columnVisibleOld = new boolean[]{true, true, true, false, true, true, true, false};
    final boolean[] columnVisibleNew = new boolean[]{true, true, true, false, true, false, true, true, false, false};
    final int[] columnPositionOld = new int[]{0, 4, 5, -1, 2, 1, 3, -1};
    final int[] columnPositionNew = new int[]{0, 4, 5, -1, 2, -1, 1, 3, -1, -1};
    boolean panelCreated = false;
    private String agentHost = null;
    private int agentPort;
    private SMRawDataRequest reqHandle;
    private SMModuleRequest modRequest;
    private int refreshDuration = 180;
    private JPanel errorPanel;
    private JTextArea errorLabel;
    private JPanel drPanel;
    private JLabel detailLabel;
    private JTextArea detailTextArea;
    private JButton cfgButton;
    private JButton uncfgButton;
    private JButton connButton;
    private JButton disconnButton;
    private JButton testButton;
    private JButton cancelButton;
    private JButton errorCancelButton;
    private JPanel cancelPanel;
    private DrJFCTable drJFCTable = null;
    private JScrollPane scrollPane = null;
    private String[][] tableData;
    Frame parentFrame = null;
    String selectedBoardID;
    private int selectedRowNumber = -1;
    private int boardColumnIndex = -1;
    private int cmdStatusColumnIndex = -1;
    DrStateDialog stateDialog = null;
    String moduleName = "dr";
    String AgentVersion = null;
    Font labelFont = null;
    Font headerFont = null;
    Font hostLabelFont = new Font("Times", 1, 14);
    Color labelBackground = Color.white;
    Color labelForeground = Color.black;
    Color headerBackground = ((Component)this).getBackground();
    Color headerForeground = this.getForeground();
    Color hostLabelBackground = ((Component)this).getBackground();
    Color hostLabelForeground = this.getForeground();
    Object dataUpdateThread = null;
    boolean dr_available = false;

    public SymonDrTable(Frame frame) {
        super(frame);
        this.parentFrame = frame;
        this.setTitle(this.getI18NString("Dynamic_Reconfiguration"));
        this.setModal(true);
    }

    public String getAgentHost() {
        return this.agentHost;
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public void setAgentPort(int n) {
        this.agentPort = n;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getConfigdModuleName() {
        return new String("Config-Reader4u");
    }

    public void setModuleName(String string) {
        this.moduleName = string;
    }

    public void setLabelFont(Font font) {
        this.labelFont = font;
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelBackground(Color color) {
        this.labelBackground = color;
    }

    public Color getLabelBackground() {
        return this.labelBackground;
    }

    public void setLabelForeground(Color color) {
        this.labelForeground = color;
    }

    public Color getLabelForeground() {
        return this.labelForeground;
    }

    public void setHostLabelFont(Font font) {
        this.hostLabelFont = font;
    }

    public Font getHostLabelFont() {
        return this.hostLabelFont;
    }

    public void setHostLabelForeground(Color color) {
        this.hostLabelForeground = color;
    }

    public Color getHostLabelForeground() {
        return this.hostLabelForeground;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.reqHandle = sMRawDataRequest;
    }

    public void setRefreshDuration(int n) {
        this.refreshDuration = n;
    }

    public String getAgentVersion() {
        return this.AgentVersion;
    }

    public void init() {
        this.modRequest = new SMModuleRequest(this.reqHandle);
        try {
            if (this.AgentVersion == null) {
                this.AgentVersion = this.reqHandle.getAgentVersion(this.agentHost, this.agentPort, "overall");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.AgentVersion != null && this.AgentVersion.equals("2.0")) {
            this.columnNames = this.columnNamesOld;
            this.columnVisible = this.columnVisibleOld;
            this.columnPosition = this.columnPositionOld;
        } else {
            this.columnNames = this.columnNamesNew;
            this.columnVisible = this.columnVisibleNew;
            this.columnPosition = this.columnPositionNew;
        }
        this.setLocationRelativeTo(this.parentFrame);
        this.drPanel = new JPanel();
        this.getContentPane().add(this.drPanel);
        this.drPanel.setLayout(new BorderLayout(10, 10));
        this.cancelPanel = new JPanel();
        this.cancelButton = new JButton(this.getI18NString("Close"));
        this.cancelButton.addActionListener(this);
        this.cancelPanel.add(this.cancelButton);
        this.initPanel();
    }

    public void initPanel() {
        this.getDrDataFromAgent();
        if (this.tableData == null) {
            return;
        }
        try {
            this.createPanel();
        }
        catch (DrException drException) {
            drException.printStackTrace();
        }
    }

    public void createPanel() throws DrException {
        Serializable serializable;
        if (this.panelCreated) {
            return;
        }
        this.panelCreated = true;
        String string = null;
        try {
            serializable = InetAddress.getByName(this.agentHost);
            string = ((InetAddress)serializable).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            throw new DrException("UnknownHostException" + this.agentHost);
        }
        serializable = new JPanel();
        JLabel jLabel = string != null ? new JLabel(string + " " + this.getI18NString("sb_") + this.agentHost + this.getI18NString("_sb")) : new JLabel(this.getI18NString("Host_colon_sb_") + this.agentHost + this.getI18NString("_sb"));
        jLabel.setHorizontalAlignment(2);
        jLabel.setFont(this.hostLabelFont);
        jLabel.setForeground(this.hostLabelForeground);
        ((Container)serializable).add(jLabel);
        ((JComponent)serializable).setBorder(BorderFactory.createBevelBorder(0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JLabel jLabel2 = new JLabel(this.getI18NString("System_Boards"));
        jPanel.add("West", jLabel2);
        try {
            this.drJFCTable = new DrJFCTable(this, this.columnNames, this.columnVisible, this.columnPosition);
            this.drJFCTable.setTableData(this.tableData);
            this.drJFCTable.init();
            this.scrollPane = new JScrollPane(this.drJFCTable);
            int n = this.drJFCTable.getColumnModel().getTotalColumnWidth();
            int n2 = 10 * this.drJFCTable.getRowHeight() + 10 * this.drJFCTable.getRowMargin();
            this.scrollPane.setPreferredSize(new Dimension(n + 100, n2));
            this.scrollPane.setMinimumSize(new Dimension(n + 100, n2));
            this.scrollPane.setBorder(UIManager.getBorder("Table.scrollPaneBorder"));
            this.scrollPane.setColumnHeaderView(this.drJFCTable.getTableHeader());
        }
        catch (DrException drException) {
            drException.printStackTrace();
        }
        this.cfgButton = new JButton(this.getI18NString("Configure"));
        this.cfgButton.setMnemonic(this.getI18NString("Configure.mnemonic").charAt(0));
        this.cfgButton.setEnabled(false);
        this.cfgButton.addActionListener(this);
        this.uncfgButton = new JButton(this.getI18NString("UnConfigure"));
        this.uncfgButton.setMnemonic(this.getI18NString("UnConfigure.mnemonic").charAt(0));
        this.uncfgButton.setEnabled(false);
        this.uncfgButton.addActionListener(this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1, 0, 5));
        jPanel2.add(this.cfgButton);
        jPanel2.add(this.uncfgButton);
        this.connButton = new JButton(this.getI18NString("Connect"));
        this.connButton.setMnemonic(this.getI18NString("Connect.mnemonic").charAt(0));
        this.connButton.setEnabled(false);
        this.connButton.addActionListener(this);
        this.disconnButton = new JButton(this.getI18NString("Disconnect"));
        this.disconnButton.setMnemonic(this.getI18NString("Disconnect.mnemonic").charAt(0));
        this.disconnButton.setEnabled(false);
        this.disconnButton.addActionListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 1, 0, 5));
        jPanel3.add(this.connButton);
        jPanel3.add(this.disconnButton);
        this.testButton = new JButton(this.getI18NString("Test_Memory..."));
        this.testButton.setMnemonic(this.getI18NString("Test_Memory..._mnemonic").charAt(0));
        this.testButton.setEnabled(false);
        this.testButton.addActionListener(this);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(2, 1, 0, 5));
        jPanel4.add(this.testButton);
        jPanel4.add(new JLabel());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(3, 1, 0, 30));
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        jPanel5.add(jPanel4);
        JPanel jPanel6 = new JPanel();
        Border border = BorderFactory.createEmptyBorder(50, 0, 0, 0);
        jPanel6.setBorder(border);
        jPanel6.add(jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(0, 10));
        this.detailLabel = new JLabel(this.getI18NString("Details"));
        jPanel7.add("West", this.detailLabel);
        this.detailTextArea = new JTextArea();
        this.detailTextArea.setEditable(false);
        jPanel7.add("South", this.detailTextArea);
        this.detailTextArea.append(this.getI18NString("3newlines"));
        this.drJFCTable.setDetailsList(this.detailTextArea);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout(0, 10));
        jPanel8.add("North", jPanel);
        jPanel8.add("Center", this.scrollPane);
        jPanel8.add("South", jPanel7);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout(10, 0));
        Border border2 = BorderFactory.createEmptyBorder(0, 25, 25, 25);
        jPanel9.setBorder(border2);
        jPanel9.add("East", jPanel6);
        jPanel9.add("Center", jPanel8);
        jPanel9.add("South", this.cancelPanel);
        this.drPanel.add("North", (Component)serializable);
        this.drPanel.add("Center", jPanel9);
        DrJFCTableModel drJFCTableModel = (DrJFCTableModel)this.drJFCTable.getModel();
        int n = 0;
        while (n < drJFCTableModel.getColumnCount()) {
            if (drJFCTableModel.getInternalColumnName(n).equals(DR_BOARD_ID)) {
                this.boardColumnIndex = n;
            } else if (drJFCTableModel.getInternalColumnName(n).equals(DR_CMDSTATUSNODE)) {
                this.cmdStatusColumnIndex = n;
            }
            ++n;
        }
        this.drJFCTable.getSelectionModel().setSelectionInterval(0, 0);
        this.validate();
        this.pack();
        try {
            this.dataUpdateThread = this.startDataUpdateThread();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String[][] getTableData() {
        int n = this.columnNames.length;
        String[][] stringArray = null;
        try {
            StObject[][] stObjectArray;
            String[] stringArray2 = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray2[n2] = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/dr/dr-table.entry." + this.columnNames[n2];
                ++n2;
            }
            try {
                stObjectArray = this.reqHandle.getURLValue(stringArray2);
            }
            catch (Exception exception) {
                throw new DrException("Exception :Unable to read dr data");
            }
            if (stObjectArray == null || stObjectArray.length != n) {
                throw new DrException("Unable to read dr data");
            }
            int n3 = 0;
            while (n3 < n) {
                Vector vector = new Vector();
                UcListUtil.decomposeList((String)stObjectArray[n3][0].toString(), vector);
                if (stringArray == null) {
                    stringArray = new String[vector.size()][n];
                }
                int n4 = 0;
                while (n4 < vector.size()) {
                    stringArray[n4][n3] = vector.elementAt(n4).toString();
                    ++n4;
                }
                ++n3;
            }
            if (stringArray.length == 0) {
                return null;
            }
            return stringArray;
        }
        catch (DrException drException) {
            drException.print();
            return null;
        }
    }

    private String[][] getDummyTableData() {
        String[][] stringArray = new String[8][8];
        stringArray[0][0] = "sysctrl0:slot0";
        stringArray[1][0] = "sysctrl0:slot1";
        stringArray[2][0] = "sysctrl0:slot2";
        stringArray[3][0] = "sysctrl0:slot3";
        stringArray[4][0] = "sysctrl0:slot4";
        stringArray[5][0] = "sysctrl0:slot5";
        stringArray[6][0] = "sysctrl0:slot6";
        stringArray[7][0] = "sysctrl0:slot7";
        stringArray[0][1] = DR_STATE_CONNECTED;
        stringArray[1][1] = DR_STATE_EMPTY;
        stringArray[2][1] = DR_STATE_DISCONNECTED;
        stringArray[3][1] = DR_STATE_DISCONNECTED;
        stringArray[4][1] = DR_STATE_EMPTY;
        stringArray[5][1] = DR_STATE_CONNECTED;
        stringArray[6][1] = DR_STATE_EMPTY;
        stringArray[7][1] = DR_STATE_DISCONNECTED;
        stringArray[0][2] = DR_STATE_CONFIGURED;
        stringArray[1][2] = DR_STATE_UNCONFIGURED;
        stringArray[2][2] = DR_STATE_UNCONFIGURED;
        stringArray[3][2] = DR_STATE_UNCONFIGURED;
        stringArray[4][2] = DR_STATE_UNCONFIGURED;
        stringArray[5][2] = DR_STATE_CONFIGURED;
        stringArray[6][2] = DR_STATE_UNCONFIGURED;
        stringArray[7][2] = DR_STATE_UNCONFIGURED;
        stringArray[0][3] = "ok";
        stringArray[1][3] = "unknown";
        stringArray[2][3] = "unusable";
        stringArray[3][3] = "unusable";
        stringArray[4][3] = "unknown";
        stringArray[5][3] = "ok";
        stringArray[6][3] = "unknown";
        stringArray[7][3] = "unusable";
        stringArray[0][4] = "Feb 27 15:25";
        stringArray[1][4] = "Feb 27 15:25";
        stringArray[2][4] = "Feb 27 15:25";
        stringArray[3][4] = "Feb 27 15:25";
        stringArray[4][4] = "Feb 27 17:17";
        stringArray[5][4] = "Feb 27 15:25";
        stringArray[6][4] = "Feb 27 15:25";
        stringArray[7][4] = "Feb 27 12:25";
        stringArray[0][5] = "cpu/mem";
        stringArray[1][5] = "dual-sbus";
        stringArray[2][5] = "cpu/mem";
        stringArray[3][5] = "disk";
        stringArray[4][5] = "unknown";
        stringArray[5][5] = "unknown";
        stringArray[6][5] = "unknown";
        stringArray[7][5] = "dual-sbus";
        stringArray[0][6] = "n";
        stringArray[1][6] = "n";
        stringArray[2][6] = "n";
        stringArray[3][6] = "n";
        stringArray[4][6] = "n";
        stringArray[5][6] = "n";
        stringArray[6][6] = "n";
        stringArray[7][6] = "n";
        stringArray[0][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot0";
        stringArray[1][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot1";
        stringArray[2][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot2";
        stringArray[3][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot3";
        stringArray[4][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot4";
        stringArray[5][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot5";
        stringArray[6][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot6";
        stringArray[7][7] = "/devices/central@1f,0/fhc@0,f8800000/clock-board@0,900000:slot7";
        return stringArray;
    }

    public void getDrDataFromAgent() {
        this.dr_available = false;
        String[][] stringArray = null;
        boolean bl = false;
        String string = this.getI18NString("DR_Data_is_not_available");
        try {
            if (this.modRequest.isModuleLoaded(this.agentHost, this.agentPort, this.moduleName)) {
                if (!this.getDRAvailability()) {
                    string = this.getI18NString("DR_Module_is_not_available");
                } else {
                    stringArray = this.getTableData();
                }
                bl = true;
            } else {
                string = this.getI18NString("DR_Module_is_not_loaded");
            }
        }
        catch (SMAPIException sMAPIException) {
            try {
                throw new DrException("Is Module Loaded failed");
            }
            catch (DrException drException) {
                drException.print();
            }
        }
        if (stringArray == null) {
            if (this.tableData == null || !bl) {
                if (this.errorPanel == null) {
                    this.errorLabel = new JTextArea(string);
                    this.errorLabel.setOpaque(false);
                    Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
                    this.errorLabel.setFont(this.getFont());
                    this.errorLabel.setEditable(false);
                    this.errorLabel.setBorder(border);
                    this.errorPanel = new JPanel();
                    this.errorPanel.setLayout(new BorderLayout(0, 50));
                    JPanel jPanel = new JPanel();
                    this.errorCancelButton = new JButton(this.getI18NString("Close"));
                    this.errorCancelButton.addActionListener(this);
                    jPanel.add(this.errorCancelButton);
                    this.errorPanel.add("North", this.errorLabel);
                    this.errorPanel.add("South", jPanel);
                    this.errorPanel.setPreferredSize(new Dimension(400, 150));
                } else {
                    this.errorLabel.setText(string);
                }
                this.getContentPane().add(this.errorPanel);
                this.getContentPane().remove(this.drPanel);
                this.getRootPane().setDefaultButton(this.errorCancelButton);
                this.validate();
                this.pack();
                this.repaint();
            }
            return;
        }
        this.dr_available = true;
        this.tableData = stringArray;
        if (this.errorPanel != null) {
            this.getContentPane().remove(this.errorPanel);
        }
        this.getContentPane().add(this.drPanel);
        this.getRootPane().setDefaultButton(this.cancelButton);
        this.validate();
        this.repaint();
    }

    public boolean update() {
        this.getDrDataFromAgent();
        if (this.tableData == null) {
            return false;
        }
        try {
            this.setSelectedBoardID(this.drJFCTable.getSelectedRow());
            this.drJFCTable.setTableData(this.tableData);
            DrJFCTableModel drJFCTableModel = (DrJFCTableModel)this.drJFCTable.getModel();
            int n = 0;
            n = 0;
            while (this.boardColumnIndex != -1 && n < this.drJFCTable.getRowCount()) {
                String string = drJFCTableModel.getStringAt(n, this.boardColumnIndex);
                if (string.equals(this.selectedBoardID)) {
                    this.drJFCTable.getSelectionModel().setSelectionInterval(n, n);
                    break;
                }
                ++n;
            }
            if (n == this.drJFCTable.getRowCount()) {
                this.drJFCTable.getSelectionModel().setSelectionInterval(0, 0);
            }
            this.drJFCTable.tableChanged(new TableModelEvent(this.drJFCTable.getModel()));
            if (this.drJFCTable.getSelectedRows().length != 0) {
                this.drJFCTable.setButtonState(this.drJFCTable.getSelectedRow());
                this.drJFCTable.showDetails(this.drJFCTable.getSelectedRow());
            }
        }
        catch (DrException drException) {
            drException.print();
        }
        return true;
    }

    public void cancelDROperation() {
        this.stateDialog = null;
    }

    public void doDROperation(String string, String string2) throws DrException {
        this.stateDialog = null;
        try {
            String[] stringArray = new String[1];
            int n = -1;
            int n2 = 0;
            while (n2 < this.tableData.length) {
                if (string.compareTo(this.tableData[n2][0]) == 0) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            if (n >= 0) {
                if (this.AgentVersion != null && this.AgentVersion.equals("2.0")) {
                    stringArray[0] = "snmp://" + this.agentHost + ":" + this.agentPort + "/mod/dr/set-obj#0";
                    StObject[][] stObjectArray = new StObject[1][1];
                    stObjectArray[0][0] = new StString("{ " + string2 + " " + string + " }");
                    stObjectArray = this.reqHandle.setURLValue(stringArray, stObjectArray);
                } else {
                    String string3 = SMRawDataRequest.createURL((String)this.getAgentHost(), (int)this.getAgentPort(), (String)this.getModuleName(), (String)"", (String)"", (String)"", (String)"", (String)"");
                    stringArray[0] = string2.equals(DR_OP_CONNECT) || string2.equals(DR_OP_DISCONNECT) ? string3 + "/dr-table.entry." + DR_RECEPTACLE + "#" + string : (string2.equals(DR_OP_CONFIGURE) || string2.equals(DR_OP_UNCONFIGURE) ? string3 + "/dr-table.entry." + DR_OCCUPANT + "#" + string : string3 + "/dr-table.entry." + DR_TESTTYPE + "#" + string);
                    DrJFCTableModel drJFCTableModel = (DrJFCTableModel)this.drJFCTable.getModel();
                    if (this.cmdStatusColumnIndex != -1) {
                        drJFCTableModel.setValueAt(n, this.cmdStatusColumnIndex, string2 + " in progress");
                    }
                    this.drJFCTable.showDetails(this.drJFCTable.getSelectedRow());
                    StObject[][] stObjectArray = new StObject[1][1];
                    stObjectArray[0][0] = new StString(string2);
                    this.reqHandle.setURLValue(stringArray, stObjectArray);
                }
            }
        }
        catch (SMAPIException sMAPIException) {
            if (sMAPIException.getReasonCode() == 1) {
                Toolkit.getDefaultToolkit().beep();
                this.stateDialog = new DrStateDialog(this, this.parentFrame, this.selectedBoardID, DR_OP_SEC_ERROR);
                this.stateDialog.show();
            }
            throw new DrException("Update failed");
        }
    }

    public void setButtonState(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        if (bl) {
            this.connButton.setEnabled(true);
        } else {
            this.connButton.setEnabled(false);
        }
        if (bl2) {
            this.disconnButton.setEnabled(true);
        } else {
            this.disconnButton.setEnabled(false);
        }
        if (bl3) {
            this.cfgButton.setEnabled(true);
        } else {
            this.cfgButton.setEnabled(false);
        }
        if (bl4) {
            this.uncfgButton.setEnabled(true);
        } else {
            this.uncfgButton.setEnabled(false);
        }
        if (bl5) {
            this.testButton.setEnabled(true);
        } else {
            this.testButton.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton || actionEvent.getSource() == this.errorCancelButton) {
            ((Component)this).setVisible(false);
        }
        if (this.stateDialog != null) {
            return;
        }
        if (actionEvent.getSource() == this.cfgButton) {
            this.stateDialog = new DrStateDialog(this, this.parentFrame, this.selectedBoardID, DR_OP_CONFIGURE);
        } else if (actionEvent.getSource() == this.uncfgButton) {
            this.stateDialog = new DrStateDialog(this, this.parentFrame, this.selectedBoardID, DR_OP_UNCONFIGURE);
        } else if (actionEvent.getSource() == this.connButton) {
            this.stateDialog = new DrStateDialog(this, this.parentFrame, this.selectedBoardID, DR_OP_CONNECT);
        } else if (actionEvent.getSource() == this.disconnButton) {
            this.stateDialog = new DrStateDialog(this, this.parentFrame, this.selectedBoardID, DR_OP_DISCONNECT);
        } else if (actionEvent.getSource() == this.testButton) {
            this.stateDialog = new DrStateDialog(this, this.parentFrame, this.selectedBoardID, DR_OP_TEST);
        } else {
            return;
        }
        this.stateDialog.show();
    }

    public void setSelectedBoardID(int n) {
        DrJFCTableModel drJFCTableModel = (DrJFCTableModel)this.drJFCTable.getModel();
        if (n >= 0 && n < drJFCTableModel.getRowCount()) {
            this.selectedBoardID = drJFCTableModel.getStringAt(n, this.boardColumnIndex);
        }
    }

    public void selectBoard(String string) {
        this.initPanel();
        if (string == null) {
            return;
        }
        if (!this.dr_available) {
            return;
        }
        DrJFCTableModel drJFCTableModel = (DrJFCTableModel)this.drJFCTable.getModel();
        int n = 0;
        while (n < drJFCTableModel.getColumnCount()) {
            if (drJFCTableModel.getInternalColumnName(n).equals(DR_BOARD_ID)) {
                int n2 = 0;
                while (n2 < drJFCTableModel.getRowCount()) {
                    String string2 = this.getPVSlotId(drJFCTableModel.getStringAt(n2, n));
                    if (string.equals(string2)) {
                        this.drJFCTable.setRowSelectionInterval(n2, n2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public String getPVSlotId(String string) {
        String string2 = string;
        int n = -1;
        int n2 = 0;
        while (n2 < string.length()) {
            if (string.charAt(n2) == ':') {
                n = n2 + 1;
                break;
            }
            ++n2;
        }
        if (n > 0 && n < string.length() - 4) {
            String string3 = string.substring(n, n + 4);
            String string4 = string.substring(n + 4);
            string2 = string3 + "(" + string4 + ")";
        }
        return string2;
    }

    public String getI18NString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return UcInternationalizer.translateKey((String)("com.sun.symon.apps.dr.console.presentation.DR:" + string));
    }

    private boolean getDRAvailability() {
        Vector vector;
        Vector vector2 = null;
        try {
            vector = new Vector();
            vector.addElement(new String("snmp://" + this.agentHost + ":" + this.agentPort + "/mod/dr/?availstatus"));
            try {
                vector2 = this.reqHandle.getURLValue(vector);
            }
            catch (Exception exception) {
                throw new DrException("Exception :Unable to read dr availability");
            }
        }
        catch (DrException drException) {
            drException.print();
        }
        return vector2 != null && vector2.size() > 0 && (vector = (Vector)vector2.elementAt(0)).elementAt(0).toString().equals("AVAILABLE");
    }

    public Object startDataUpdateThread() throws Exception {
        try {
            if (this.dataUpdateThread != null) {
                this.reqHandle.removeURLRequest(this.dataUpdateThread);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String string = SMRawDataRequest.createURL((String)this.getAgentHost(), (int)this.getAgentPort(), (String)this.getConfigdModuleName(), (String)"", (String)"", (String)"", (String)"", (String)"");
        Vector<String> vector = new Vector<String>();
        String string2 = SMRawDataRequest.createURL((String)string, (String)"system", (String)"total_config_changes#0", (String)"", (String)"");
        String string3 = SMRawDataRequest.createURL((String)this.getAgentHost(), (int)this.getAgentPort(), (String)this.getModuleName(), (String)"", (String)"", (String)"", (String)"", (String)"");
        String string4 = string3 + "/dr-table.entry." + DR_RECEPTACLE;
        String string5 = string3 + "/dr-table.entry." + DR_OCCUPANT;
        vector.addElement(string2);
        vector.addElement(string4);
        vector.addElement(string5);
        return this.reqHandle.getURLValue(vector, String.valueOf(this.refreshDuration), (SMRawDataResponse)this, (Object)"drUpdate");
    }

    public void stopDataUpdateThread() {
        try {
            if (this.dataUpdateThread != null) {
                this.reqHandle.removeURLRequest(this.dataUpdateThread);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void cleanup() {
        this.stopDataUpdateThread();
    }

    public void getURLResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
        if (vector == null || vector.size() == 0 || object == null) {
            return;
        }
        if (object.toString().equals("drUpdate")) {
            this.update();
        }
    }

    public void getURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
    }

    public void setURLResponse(SMRequestStatus sMRequestStatus, StObject[][] stObjectArray, Object object) {
    }

    public void setURLResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
    }
}

