/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.util.result;

import com.sun.netstorage.mgmt.util.result.ESMResult;
import com.sun.netstorage.mgmt.util.result.ESMResultWithArgs;

public class ESMException
extends Exception {
    public String[] debugMessages;
    private final ESMResultWithArgs myResult;
    private int nMsgs = 0;
    private static final int MSGARRAY_SIZE_INCREMENT = 3;

    protected ESMException() {
        this.myResult = new ESMResultWithArgs(this.getClass().getName());
    }

    protected ESMException(Throwable throwable) {
        super(throwable);
        this.myResult = new ESMResultWithArgs(this.getClass().getName());
    }

    public ESMException(String string) {
        super(string);
        this.myResult = new ESMResultWithArgs(this.getPackageName() + string);
    }

    public ESMException(String string, Throwable throwable) {
        super(string, throwable);
        this.myResult = new ESMResultWithArgs(this.getPackageName() + string);
    }

    public ESMException(String string, String string2) {
        super(string2);
        this.myResult = new ESMResultWithArgs(string, string2);
    }

    public ESMException(String string, String string2, Throwable throwable) {
        super(string2, throwable);
        this.myResult = new ESMResultWithArgs(string, string2);
    }

    public ESMException(ESMResult eSMResult) {
        super(eSMResult.getKey());
        this.myResult = eSMResult instanceof ESMResultWithArgs ? (ESMResultWithArgs)eSMResult : new ESMResultWithArgs(eSMResult.getBundleName(), eSMResult.getKey());
    }

    public ESMException(ESMResult eSMResult, Throwable throwable) {
        super(eSMResult.getKey(), throwable);
        this.myResult = eSMResult instanceof ESMResultWithArgs ? (ESMResultWithArgs)eSMResult : new ESMResultWithArgs(eSMResult.getBundleName(), eSMResult.getKey());
    }

    public String getMessage() {
        StringBuffer stringBuffer = new StringBuffer(this.myResult.getDebugMessage());
        int n = 0;
        while (n < this.nMsgs) {
            stringBuffer.append("\n");
            stringBuffer.append(this.debugMessages[n]);
            ++n;
        }
        if (this.getCause() != null) {
            stringBuffer.append("\n Caused by:\n");
            stringBuffer.append(this.getCause().getMessage());
        }
        return stringBuffer.toString();
    }

    public String getLocalizedMessage() {
        return this.myResult.getLocalizedMessage();
    }

    public ESMResult getResult() {
        return this.myResult;
    }

    public int addArgument(Object object, String string) {
        return this.myResult.addArgument(object, string);
    }

    public int getNumberOfArgs() {
        return this.myResult.getNumberOfArgs();
    }

    public int addDebugMessage(String string) {
        if (string == null) {
            return -1;
        }
        if (this.debugMessages == null || this.debugMessages.length >= this.nMsgs) {
            String[] stringArray = new String[this.nMsgs + 3];
            int n = 0;
            while (n < this.nMsgs) {
                stringArray[n] = this.debugMessages[n];
                ++n;
            }
            this.debugMessages = stringArray;
        }
        this.debugMessages[this.nMsgs] = string;
        int n = this.nMsgs++;
        return n;
    }

    public int getNumberOfDebugMessages() {
        return this.nMsgs;
    }

    private String getPackageName() {
        Package package_ = this.getClass().getPackage();
        if (package_ != null) {
            return package_.getName() + ".";
        }
        return "resources.Status:";
    }

    public String toString() {
        return this.getMessage();
    }
}

