/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.util.concurrent;

import com.sun.netstorage.mgmt.util.result.ESMException;
import com.sun.netstorage.mgmt.util.result.ESMResult;

public class Lock {
    String lockingThreadName = null;
    int lockCount = 0;

    public synchronized void lock() throws ESMException {
        this.lock(0L);
    }

    public synchronized void lock(long l) throws ESMException {
        if (this.lockingThreadName == null) {
            this.lockingThreadName = Thread.currentThread().getName();
            this.lockCount = 1;
        } else if (this.currentThreadHasLocked()) {
            ++this.lockCount;
        } else {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                throw new ESMException(ESMResult.FAILED, (Throwable)interruptedException);
            }
            this.lockingThreadName = Thread.currentThread().getName();
            this.lockCount = 1;
        }
    }

    public synchronized void unlock() {
        if (this.currentThreadHasLocked() && --this.lockCount == 0) {
            this.lockingThreadName = null;
            this.notify();
        }
    }

    public synchronized boolean currentThreadHasLocked() {
        return Thread.currentThread().getName().equals(this.lockingThreadName);
    }

    public synchronized boolean isLocked() {
        return this.lockingThreadName != null;
    }
}

