/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n;

import com.sun.netstorage.mgmt.esm.util.l10n.Contract;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;

public final class Message
implements Localizable,
Serializable {
    private static final String SCCS_ID = "@(#)Message.java 1.3   03/08/29 SMI";
    private final Resource myResource;
    private final Serializable[] myArgs;

    public Message(Resource resource, Serializable[] serializableArray) {
        Contract.requires(resource != null, "theResource != null");
        this.myResource = resource;
        this.myArgs = serializableArray;
    }

    public Message(Resource resource) {
        this(resource, null);
    }

    public final Resource getResource() {
        return this.myResource;
    }

    private String getResourceText(Locale locale) {
        String string = null;
        if (locale != null) {
            string = this.myResource.getLocalizedText(locale);
        }
        if (string == null) {
            string = this.myResource.getLiteralText();
        }
        return string;
    }

    private int countResourceArgs(Locale locale) {
        MessageFormat messageFormat;
        Format[] formatArray;
        int n = 0;
        String string = this.getResourceText(locale);
        if (string != null && (formatArray = (messageFormat = new MessageFormat(string)).getFormatsByArgumentIndex()) != null) {
            n = formatArray.length;
        }
        return n;
    }

    public final Serializable[] getArgs() {
        return this.myArgs;
    }

    public final String[] getLiteralArgs() {
        return this.getLiteralArgs(this.myArgs);
    }

    private String[] getLiteralArgs(Serializable[] serializableArray) {
        int n = serializableArray != null ? serializableArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Serializable serializable = serializableArray[n2];
            String string = null;
            string = serializable instanceof String ? (String)((Object)serializable) : (serializable != null ? serializable.toString() : null);
            stringArray[n2] = string;
            ++n2;
        }
        return stringArray;
    }

    public final String[] getLocalizedArgs() {
        return this.getLocalizedArgs(Locale.getDefault());
    }

    public final String[] getLocalizedArgs(Locale locale) {
        return this.getLocalizedArgs(this.myArgs, locale);
    }

    private String[] getLocalizedArgs(Serializable[] serializableArray, Locale locale) {
        int n = serializableArray != null ? serializableArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Serializable serializable = serializableArray[n2];
            if (serializable instanceof Localizable) {
                object = (Localizable)((Object)serializable);
                stringArray[n2] = this.getLocalizedArg((Localizable)object, locale, null);
            } else if (serializable instanceof String) {
                object = (String)((Object)serializable);
                String string = this.myResource.getResourceBundleName();
                Resource resource = new Resource(string, (String)object, (String)object);
                stringArray[n2] = this.getLocalizedArg(resource, locale, (String)object);
            } else if (serializable != null) {
                stringArray[n2] = serializable.toString();
            }
            ++n2;
        }
        Contract.ensures(stringArray != null, "result != null");
        return stringArray;
    }

    private String getLocalizedArg(Localizable localizable, Locale locale, String string) {
        String string2 = null;
        if (localizable != null) {
            string2 = localizable.getLocalizedText(locale);
            if (string2 == null) {
                string2 = localizable.getLocalizedText();
            }
            if (string2 == null) {
                string2 = string;
            }
        }
        return string2;
    }

    private Serializable[] adjustArgs(Locale locale) {
        int n = this.countResourceArgs(locale);
        Serializable[] serializableArray = new Serializable[n];
        int n2 = 0;
        while (n2 < n) {
            serializableArray[n2] = this.myArgs != null && n2 < this.myArgs.length ? this.myArgs[n2] : "null";
            ++n2;
        }
        return serializableArray;
    }

    public final Message toMessage(Serializable[] serializableArray) {
        Message message = new Message(this.myResource, serializableArray);
        return message;
    }

    public String toString(Locale locale) {
        String string = this.getLocalizedText(locale);
        if (string == null) {
            string = this.getLiteralText();
        }
        Contract.ensures(string != null, "String != null");
        return string;
    }

    private String format(Locale locale) {
        String string;
        block7: {
            string = null;
            String string2 = null;
            Object[] objectArray = null;
            if (locale != null) {
                string2 = this.myResource.getLocalizedText(locale);
                objectArray = this.getLocalizedArgs(this.myArgs, locale);
            } else {
                string2 = this.myResource.getLiteralText();
                objectArray = this.getLiteralArgs(this.myArgs);
            }
            if (string2 == null) break block7;
            if (objectArray == null) {
                objectArray = new String[]{};
            }
            try {
                string = MessageFormat.format(string2, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Serializable[] serializableArray = this.adjustArgs(locale);
                objectArray = locale != null ? this.getLocalizedArgs(serializableArray, locale) : this.getLiteralArgs(serializableArray);
                try {
                    string = MessageFormat.format(string2, objectArray);
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    string = this.getResourceText(locale);
                }
            }
        }
        return string;
    }

    public final String getLiteralText() {
        String string = this.format(null);
        return string;
    }

    public final String getLocalizedText() {
        return this.getLocalizedText(Locale.getDefault());
    }

    public final String getLocalizedText(Locale locale) {
        String string = this.format(locale);
        return string;
    }

    public final String toString() {
        return this.toString(Locale.getDefault());
    }
}

