/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n;

import com.sun.netstorage.mgmt.esm.util.l10n.Contract;
import com.sun.netstorage.mgmt.esm.util.l10n.Formattable;
import com.sun.netstorage.mgmt.esm.util.l10n.FormatterException;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.io.Serializable;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Locale;

public class Formatter
implements Formattable,
Serializable {
    private static final String SCCS_ID = "@(#)Formatter.java 1.4   03/08/15 SMI";
    static final long serialVersionUID = 2208663780501649316L;
    private final Resource myResource;

    public Formatter(Resource resource) {
        Contract.requires(resource != null, "theResource != null");
        this.myResource = resource;
    }

    public final Resource getResource() {
        return this.myResource;
    }

    public final String getResourceBundleName() {
        return this.myResource.getResourceBundleName();
    }

    public final String[] getLocalizedArgs(Serializable[] serializableArray, Locale locale) {
        int n = serializableArray != null ? serializableArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Serializable serializable = serializableArray[n2];
            Object var7_7 = null;
            if (serializable instanceof Localizable) {
                object = (Localizable)((Object)serializable);
                stringArray[n2] = this.getLocalizedArg((Localizable)object, locale, null);
            } else if (serializable instanceof String) {
                object = (String)((Object)serializable);
                String string = this.getResourceBundleName();
                Resource resource = new Resource(string, (String)object, (String)object);
                stringArray[n2] = this.getLocalizedArg(resource, locale, (String)object);
            } else if (serializable != null) {
                stringArray[n2] = object = serializable.toString();
            }
            ++n2;
        }
        Contract.ensures(stringArray != null, "result != null");
        return stringArray;
    }

    private String getLocalizedArg(Localizable localizable, Locale locale, String string) {
        String string2 = null;
        if (localizable != null) {
            string2 = localizable.getLocalizedText(locale);
            if (string2 == null) {
                string2 = localizable.getLocalizedText();
            }
            if (string2 == null) {
                string2 = string;
            }
        }
        return string2;
    }

    public final String[] getLiteralArgs(Serializable[] serializableArray) {
        int n = serializableArray != null ? serializableArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            Serializable serializable = serializableArray[n2];
            String string = null;
            string = serializable instanceof String ? (String)((Object)serializable) : (serializable != null ? serializable.toString() : null);
            stringArray[n2] = string;
            ++n2;
        }
        return stringArray;
    }

    public final String getLiteralFormattedText(Serializable[] serializableArray) throws FormatterException {
        String string = this.myResource.getLiteralText();
        String[] stringArray = this.getLiteralArgs(serializableArray);
        String string2 = this.getFormattedText(string, stringArray);
        return string2;
    }

    protected final String getFormattedText(String string, String[] stringArray) throws FormatterException {
        String string2 = null;
        if (string != null) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            try {
                string2 = MessageFormat.format(string, stringArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new FormatterException.IllegalArguments(this, (Throwable)illegalArgumentException, string, stringArray);
            }
        }
        return string2;
    }

    public final String getFormattedText(Serializable[] serializableArray) throws FormatterException {
        return this.getFormattedText(serializableArray, Locale.getDefault());
    }

    public final String getFormattedText(Serializable[] serializableArray, Locale locale) throws FormatterException {
        String string = this.myResource.getLocalizedText(locale);
        String[] stringArray = this.getLocalizedArgs(serializableArray, locale);
        String string2 = this.getFormattedText(string, stringArray);
        return string2;
    }

    public int getFormatArgumentCount() {
        return this.getFormatArgumentCount(Locale.getDefault());
    }

    public int getFormatArgumentCount(Locale locale) {
        MessageFormat messageFormat;
        Format[] formatArray;
        String string;
        int n = 0;
        String string2 = this.myResource.getLocalizedText(locale);
        String string3 = string = string2 != null ? string2 : this.myResource.getLiteralText();
        if (string != null && (formatArray = (messageFormat = new MessageFormat(string)).getFormatsByArgumentIndex()) != null) {
            n = formatArray.length;
        }
        return n;
    }
}

