/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public final class PasswordReader {
    private static final String SCCS_ID = "@(#)PasswordReader.java 1.2   03/04/07 SMI";
    public static final String DEFAULT_PROMPT = "Please enter password: ";
    public static final OutputStream DEFAULT_OUT = System.out;
    public static final InputStream DEFAULT_IN = System.in;
    private final InputStream myInput;
    private final OutputStream myOutput;
    private final String myPrompt;
    private PrintStream myPromptPrinter = null;

    public static void main(String[] stringArray) {
        try {
            PasswordReader passwordReader = new PasswordReader();
            char[] cArray = passwordReader.getPassword();
            String string = new String(cArray);
            System.out.println("password = " + string);
            System.exit(0);
        }
        catch (IOException iOException) {
            System.err.println("PasswordReader: ERROR: " + iOException);
            System.exit(1);
        }
    }

    public PasswordReader(InputStream inputStream, OutputStream outputStream, String string) {
        this.myInput = inputStream;
        this.myOutput = outputStream;
        this.myPrompt = string;
    }

    public PasswordReader(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, DEFAULT_PROMPT);
    }

    public PasswordReader(String string) {
        this(DEFAULT_IN, DEFAULT_OUT, string);
    }

    public PasswordReader() {
        this(DEFAULT_IN, DEFAULT_OUT, DEFAULT_PROMPT);
    }

    private boolean hasPrompt() {
        return this.myPrompt != null;
    }

    private void writePrompt() throws IOException {
        this.getPromptPrinter().print(this.myPrompt);
        this.getPromptPrinter().flush();
    }

    private void rewritePrompt() throws IOException {
        this.getPromptPrinter().print('\r');
        this.getPromptPrinter().print(this.myPrompt);
        this.getPromptPrinter().print("        ");
        this.getPromptPrinter().print('\r');
        this.getPromptPrinter().print(this.myPrompt);
        this.getPromptPrinter().flush();
    }

    private PrintStream getPromptPrinter() {
        if (this.myPromptPrinter == null) {
            this.myPromptPrinter = this.myOutput instanceof PrintStream ? (PrintStream)this.myOutput : new PrintStream(this.myOutput);
        }
        return this.myPromptPrinter;
    }

    public final char[] getPassword() throws IOException {
        char[] cArray = null;
        char[] cArray2 = new char[128];
        int n = cArray2.length;
        int n2 = 0;
        InputMasker inputMasker = new InputMasker();
        if (this.hasPrompt()) {
            this.writePrompt();
            inputMasker.start();
        }
        while (true) {
            int n3 = this.myInput.read();
            if (this.hasPrompt()) {
                inputMasker.setFinished();
            }
            if (n3 == 10 || n3 == -1) break;
            if (n3 == 13) {
                int n4 = this.myInput.read();
                if (n4 == 10 || n4 == -1) break;
                n3 = n4;
                break;
            }
            if (--n < 0) {
                char[] cArray3 = cArray2;
                cArray2 = new char[n2 + 128];
                System.arraycopy(cArray3, 0, cArray2, 0, n2);
                n = cArray2.length - n2 - 1;
                Arrays.fill(cArray3, ' ');
            }
            cArray2[n2++] = (char)n3;
        }
        if (this.hasPrompt()) {
            inputMasker.setFinished();
        }
        if (n2 > 0) {
            cArray = new char[n2];
            System.arraycopy(cArray2, 0, cArray, 0, n2);
            Arrays.fill(cArray2, ' ');
        }
        return cArray;
    }

    private class InputMasker
    extends Thread {
        private final long mySleepMillis;
        private boolean myFinished = false;

        public InputMasker(long l) {
            super("InputMasker");
            this.mySleepMillis = l;
        }

        public InputMasker() {
            this(10L);
        }

        public synchronized void setFinished() {
            this.myFinished = true;
        }

        public synchronized void run() {
            while (!this.myFinished) {
                try {
                    Thread.sleep(this.mySleepMillis);
                    if (this.myFinished) continue;
                    PasswordReader.this.rewritePrompt();
                }
                catch (IOException iOException) {
                    this.myFinished = true;
                }
                catch (InterruptedException interruptedException) {
                    this.myFinished = true;
                }
            }
        }
    }
}

