/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.context;

import java.io.Serializable;
import java.util.Locale;
import javax.security.auth.Subject;

public class Context
implements Serializable {
    static final long serialVersionUID = 8863107404674095386L;
    public static final Context EMPTY_CONTEXT = new EmptyContext();
    protected Subject subject;
    protected Locale locale;
    private static final ContextThreadLocal contexts = new ContextThreadLocal();

    public Context(Subject subject) {
        this(subject, null);
    }

    public Context(Subject subject, Locale locale) {
        if (subject != null) {
            subject.setReadOnly();
        }
        this.subject = subject;
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static Context getContext() {
        return contexts.getContext();
    }

    public static Context setContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        return contexts.setContext(context);
    }

    public static Context setDefaultContext(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context == null");
        }
        return contexts.setDefault(context);
    }

    public boolean equals(Object object) {
        try {
            Context context = (Context)object;
            return Context.isEqual(this.subject, context.subject);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        int n = 0;
        if (this.subject != null) {
            n ^= this.subject.hashCode();
        }
        return n;
    }

    public String toString() {
        return "Context{" + this.subject + "}";
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null || object2 == null ? object == object2 : object.equals(object2);
    }

    private static class ContextThreadLocal
    extends InheritableThreadLocal {
        private Context defaultContext = EMPTY_CONTEXT;

        private ContextThreadLocal() {
        }

        public synchronized Context setDefault(Context context) {
            Context context2 = this.defaultContext;
            this.defaultContext = context;
            return context2;
        }

        public synchronized Context getContext() {
            return (Context)this.get();
        }

        public synchronized Context setContext(Context context) {
            Context context2 = this.getContext();
            this.set(context);
            return context2;
        }

        public Object initialValue() {
            return this.defaultContext;
        }
    }

    public static final class EmptyContext
    extends Context {
        static final long serialVersionUID = 129377845795717386L;

        EmptyContext() {
            super(null, Locale.getDefault());
        }
    }
}

