/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.component;

import com.sun.netstorage.mgmt.esm.common.component.AbstractComponentDelegate;
import com.sun.netstorage.mgmt.esm.common.component.ComponentTracer;
import com.sun.netstorage.mgmt.esm.common.component.Contract;
import com.sun.netstorage.mgmt.esm.util.trace.StackTrace;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;

public class ComponentTracerDelegate
extends AbstractComponentDelegate
implements ComponentTracer {
    private static final String SCCS_ID = "@(#)ComponentTracerDelegate.java 1.3   03/11/15 SMI";
    public static final String TRACE_PACKAGE_PREFIX = "trace.";
    public static final String TRACE_EXPRESSION_PROPERTY = "component.trace";
    public static final String TRACE_FILE_PROPERTY = "component.traceFile";
    public static final String TRACE_LEVEL_PROPERTY = "component.traceLevel";
    public static final String TRACE_LEVEL_DEFAULT = "all";
    private static final int TRACE_FILE_LIMIT = 500000;
    private static final int TRACE_FILE_COUNT = 10;
    private static final String TRACE_FACILITY_INTERFACE_NAME = "org.jini.project.component.TraceFacility";
    private static final String TRACE_FACILITY_SINGLETON_NAME = "org.jini.project.component.TraceFacility$Singleton";
    private static final HashMap ourLevelMap = new HashMap();
    private static Handler ourHandler = null;
    private final Properties myConfig;
    private final Logger myLogger;
    static /* synthetic */ Class class$java$lang$Package;

    private static Level getLevel(String string) {
        String string2 = string.toLowerCase();
        if (ourLevelMap.size() == 0) {
            ComponentTracerDelegate.initLevelMap();
        }
        return (Level)ourLevelMap.get(string2);
    }

    private static void initLevelMap() {
        ourLevelMap.put("severe", Level.SEVERE);
        ourLevelMap.put("error", Level.SEVERE);
        ourLevelMap.put("warning", Level.WARNING);
        ourLevelMap.put("warn", Level.WARNING);
        ourLevelMap.put("info", Level.INFO);
        ourLevelMap.put("default", Level.INFO);
        ourLevelMap.put("config", Level.CONFIG);
        ourLevelMap.put("fine", Level.FINE);
        ourLevelMap.put("debug", Level.FINE);
        ourLevelMap.put("finer", Level.FINER);
        ourLevelMap.put("methods", Level.FINER);
        ourLevelMap.put("finest", Level.FINEST);
        ourLevelMap.put("verbose", Level.FINEST);
    }

    public static Level parseLevel(String string) {
        Level level = Level.ALL;
        if (string != null && string.length() > 0 && (level = ComponentTracerDelegate.getLevel(string)) == null) {
            level = Level.ALL;
        }
        return level;
    }

    private static Handler getHandler(String string, Level level) {
        if (ourHandler == null) {
            if (string != null && string.length() > 0) {
                try {
                    ourHandler = new FileHandler(string, 500000, 10);
                }
                catch (IOException iOException) {
                    ourHandler = new ConsoleHandler();
                }
            } else {
                ourHandler = new ConsoleHandler();
            }
            if (ourHandler != null) {
                ourHandler.setLevel(level);
                ourHandler.setFilter(null);
                ourHandler.setFormatter(new SimpleFormatter());
            }
        }
        return ourHandler;
    }

    public ComponentTracerDelegate(Class clazz, Properties properties) {
        super(clazz);
        if (properties == null) {
            properties = System.getProperties();
        }
        this.myConfig = properties;
        this.myLogger = this.createLogger();
    }

    public ComponentTracerDelegate(Class clazz) {
        this(clazz, null);
    }

    protected final Properties getConfig() {
        return this.myConfig;
    }

    protected final String getConfigProperty(String string, String string2) {
        String string3 = this.myConfig.getProperty(string, string2);
        if (string3 == null) {
            string3 = System.getProperty(string, string2);
        }
        return string3;
    }

    protected final String getTraceExpressionProperty() {
        return this.getConfigProperty(TRACE_EXPRESSION_PROPERTY, null);
    }

    protected final String getTraceFileProperty() {
        return this.getConfigProperty(TRACE_FILE_PROPERTY, null);
    }

    protected final String getTraceLevelProperty() {
        return this.getConfigProperty(TRACE_LEVEL_PROPERTY, TRACE_LEVEL_DEFAULT);
    }

    private String getLoggerPackageName() {
        return TRACE_PACKAGE_PREFIX + this.getComponentPackageName();
    }

    private String getLoggerClassName() {
        String string = this.getComponentBasename();
        return string;
    }

    private Logger createLogger() {
        Logger logger = this.getTraceFacilityLogger();
        if (logger == null) {
            logger = this.createLoggerFromScatch();
        }
        return logger;
    }

    private Logger createLoggerFromScatch() {
        Level level;
        String string;
        Handler handler;
        String string2;
        Pattern pattern;
        Logger logger = null;
        String string3 = this.getTraceExpressionProperty();
        if (string3 != null && (pattern = Pattern.compile(string3)).matcher(string2 = this.getLoggerPackageName()).matches() && (logger = Logger.getLogger(string2)) != null && logger.getHandlers().length == 0 && (handler = ComponentTracerDelegate.getHandler(string = this.getTraceFileProperty(), level = ComponentTracerDelegate.parseLevel(this.getTraceLevelProperty()))) != null) {
            logger.addHandler(handler);
            logger.setLevel(level);
            logger.setFilter(null);
            logger.setUseParentHandlers(false);
        }
        return logger;
    }

    private Logger getTraceFacilityLogger() {
        Logger logger;
        block3: {
            logger = null;
            try {
                Object[] objectArray;
                Class<?> clazz = Class.forName(TRACE_FACILITY_SINGLETON_NAME);
                Class[] classArray = new Class[]{};
                Method method = clazz.getDeclaredMethod("get", classArray);
                Object[] objectArray2 = new Object[]{};
                Object object = method.invoke(null, objectArray2);
                if (object == null) break block3;
                Class<?> clazz2 = Class.forName(TRACE_FACILITY_INTERFACE_NAME);
                Class[] classArray2 = new Class[]{class$java$lang$Package == null ? (class$java$lang$Package = ComponentTracerDelegate.class$("java.lang.Package")) : class$java$lang$Package};
                Method method2 = clazz2.getMethod("getTracer", classArray2);
                Object object2 = method2.invoke(object, objectArray = new Object[]{this.getComponentPackage()});
                if (object2 != null) {
                    String string = this.getLoggerPackageName();
                    logger = LogManager.getLogManager().getLogger(string);
                }
            }
            catch (Exception exception) {}
        }
        return logger;
    }

    protected final boolean hasLogger() {
        return this.myLogger != null;
    }

    protected final boolean isLoggable(Level level) {
        return this.myLogger != null && this.myLogger.isLoggable(level);
    }

    protected final Logger getLogger() {
        return this.myLogger;
    }

    public final String traceEntry(String string) {
        Contract.requires(string != null, "theMethod != null");
        if (this.hasLogger()) {
            this.getLogger().entering(this.getLoggerClassName(), string);
        }
        return string;
    }

    public final String traceEntry(String string, Object object) {
        Contract.requires(string != null, "theMethod != null");
        if (this.hasLogger()) {
            this.getLogger().entering(this.getLoggerClassName(), string, object);
        }
        return string;
    }

    public final String traceEntry(String string, Object[] objectArray) {
        Contract.requires(string != null, "theMethod != null");
        if (this.hasLogger()) {
            this.getLogger().entering(this.getLoggerClassName(), string, objectArray);
        }
        return string;
    }

    public final void traceReturn(String string) {
        this.traceReturn(string, "void");
    }

    public final void traceReturn(String string, Object object) {
        Contract.requires(string != null, "theMethod != null");
        if (this.hasLogger()) {
            this.getLogger().exiting(this.getLoggerClassName(), string, object);
        }
    }

    public final void traceThrow(String string, Throwable throwable) {
        Contract.requires(string != null, "theMethod != null");
        Contract.requires(throwable != null, "theCause != null");
        if (this.hasLogger()) {
            this.getLogger().throwing(this.getLoggerClassName(), string, throwable);
            if (this.isTraceFinest()) {
                String string2 = StackTrace.asString(throwable);
                this.getLogger().logp(Level.FINEST, this.getLoggerClassName(), string, string2);
            }
        }
    }

    public final void traceError(String string, String string2) {
        Contract.requires(string != null, "theMethod != null");
        if (this.hasLogger()) {
            this.getLogger().logp(Level.SEVERE, this.getLoggerClassName(), string, string2);
        }
    }

    public final void traceWarning(String string, String string2) {
        if (this.hasLogger()) {
            this.getLogger().logp(Level.WARNING, this.getLoggerClassName(), string, string2);
        }
    }

    public final void traceInfo(String string, String string2) {
        if (this.hasLogger()) {
            this.getLogger().logp(Level.INFO, this.getLoggerClassName(), string, string2);
        }
    }

    public final void traceConfig(String string, String string2) {
        if (this.hasLogger()) {
            this.getLogger().logp(Level.CONFIG, this.getLoggerClassName(), string, string2);
        }
    }

    public final void traceFine(String string, String string2) {
        if (this.hasLogger()) {
            this.getLogger().logp(Level.FINE, this.getLoggerClassName(), string, string2);
        }
    }

    public final void traceFiner(String string, String string2) {
        if (this.hasLogger()) {
            this.getLogger().logp(Level.FINER, this.getLoggerClassName(), string, string2);
        }
    }

    public final void traceFinest(String string, String string2) {
        if (this.hasLogger()) {
            this.getLogger().logp(Level.FINEST, this.getLoggerClassName(), string, string2);
        }
    }

    public final boolean isTraceError() {
        return this.isLoggable(Level.SEVERE);
    }

    public final boolean isTraceWarning() {
        return this.isLoggable(Level.WARNING);
    }

    public final boolean isTraceInfo() {
        return this.isLoggable(Level.INFO);
    }

    public final boolean isTraceConfig() {
        return this.isLoggable(Level.CONFIG);
    }

    public final boolean isTraceFine() {
        return this.isLoggable(Level.FINE);
    }

    public final boolean isTraceFiner() {
        return this.isLoggable(Level.FINER);
    }

    public final boolean isTraceFinest() {
        return this.isLoggable(Level.FINEST);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

