/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.array;

import com.sun.netstorage.mgmt.esm.common.array.Contract;
import com.sun.netstorage.mgmt.esm.common.array.Localization;
import com.sun.netstorage.mgmt.esm.common.array.StorageSettingFactory;
import java.io.Serializable;
import java.util.Locale;
import java.util.StringTokenizer;

public class StorageSettingId
implements Serializable,
Comparable {
    private static final String SCCS_ID = "@(#)StorageSettingId.java 1.4   04/02/23 SMI";
    static final long serialVersionUID = 3549570099167385095L;
    public static final String VENDOR_DEFAULT = "any";
    public static final String MODEL_DEFAULT = "any";
    public static final String SEPARATOR_PROPERTY = "StorageSettingId.separator";
    public static final String SEPARATOR_DEFAULT = "/";
    public static final char ESCAPE_TO = '_';
    private static String ourSeparator = null;
    private final String myVendor;
    private final String myModel;
    private final String myName;
    private String myId = null;
    private int myIdHashCode = Integer.MIN_VALUE;

    public static final String getSeparator() {
        if (ourSeparator == null && (ourSeparator = System.getProperty(SEPARATOR_PROPERTY, SEPARATOR_DEFAULT)).length() != 1) {
            ourSeparator = SEPARATOR_DEFAULT;
        }
        return ourSeparator;
    }

    public static StorageSettingId create(String string, String string2, String string3) {
        Contract.requires(string3 != null, "theName != null");
        return new StorageSettingId(string, string2, string3);
    }

    public static StorageSettingId create(String string) {
        return StorageSettingId.create("any", "any", string);
    }

    public static StorageSettingId parse(String string) {
        Contract.requires(string != null, "theId != null");
        String string2 = "any";
        String string3 = "any";
        String string4 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, StorageSettingId.getSeparator());
        int n = stringTokenizer.countTokens();
        Contract.guarantees(n == 1 || n == 3, "tokens == 1 || tokens == 3");
        if (n == 3) {
            string2 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            string4 = stringTokenizer.nextToken();
        }
        return StorageSettingId.create(string2, string3, string4);
    }

    public static void main(String[] stringArray) {
        StorageSettingId storageSettingId = StorageSettingId.create("RAID0");
        StorageSettingId storageSettingId2 = StorageSettingId.create("SUN", "T3+", "RAID5 w/spare");
        String string = "sun/t3+/raid5_w_spare";
        String string2 = "sun|t3+|raid5_w/spare";
        String string3 = StorageSettingId.getSeparator();
        String string4 = SEPARATOR_DEFAULT.equals(string3) ? string : string2;
        System.out.println("Instance toString():");
        System.out.println("raid0 = " + storageSettingId);
        System.out.println("raid5s = " + storageSettingId2);
        System.out.println();
        System.out.println("Id parse():");
        System.out.println("raid0 = " + StorageSettingId.parse("raid0"));
        System.out.println("raid5s = " + StorageSettingId.parse(string4));
    }

    private StorageSettingId(String string, String string2, String string3) {
        Contract.requires(string3 != null, "theName != null");
        this.myVendor = string != null ? string : "any";
        this.myModel = string2 != null ? string2 : "any";
        this.myName = string3;
    }

    public final String getVendor() {
        return this.myVendor;
    }

    public final String getModel() {
        return this.myModel;
    }

    public final String getName() {
        return this.myName;
    }

    public final String getId() {
        if (this.myId == null) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.myVendor != "any") {
                stringBuffer.append(this.escape(this.getDisplayVendor(null)));
                stringBuffer.append(StorageSettingId.getSeparator());
            }
            if (this.myModel != "any") {
                stringBuffer.append(this.escape(this.getDisplayModel(null)));
                stringBuffer.append(StorageSettingId.getSeparator());
            }
            stringBuffer.append(this.escape(this.myName));
            this.myId = stringBuffer.toString();
        }
        return this.myId;
    }

    private int getIdHashCode() {
        if (this.myIdHashCode == Integer.MIN_VALUE) {
            this.myIdHashCode = this.getId().toLowerCase().hashCode();
        }
        return this.myIdHashCode;
    }

    private String escape(String string) {
        String string2 = string;
        if (string != null) {
            int n = string.length();
            StringBuffer stringBuffer = new StringBuffer(n);
            char c = StorageSettingId.getSeparator().charAt(0);
            int n2 = 0;
            while (n2 < n) {
                char c2 = string.charAt(n2);
                if (c2 == c || c2 == ' ') {
                    c2 = '_';
                }
                stringBuffer.append(c2);
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        return string2;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public final String getDisplayName(Locale locale) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.escape(this.getDisplayVendor(locale)));
        stringBuffer.append(StorageSettingId.getSeparator());
        stringBuffer.append(this.escape(this.getDisplayModel(locale)));
        stringBuffer.append(StorageSettingId.getSeparator());
        stringBuffer.append(this.escape(this.myName));
        return stringBuffer.toString();
    }

    public final String getDisplayVendor(Locale locale) {
        String string = this.myVendor;
        if (this.myVendor == "any") {
            String string2 = Localization.RES_VENDOR_DEFAULT.getLocalizedText(locale);
            if (string2 != null) {
                string = string2;
            }
        } else {
            String string3 = StorageSettingFactory.getCanonicalVendor(this.myVendor);
            if (string3 != null) {
                string = string3;
            }
        }
        return string;
    }

    public final String getDisplayModel(Locale locale) {
        String string = this.myModel;
        if (this.myModel == "any") {
            String string2 = Localization.RES_MODEL_DEFAULT.getLocalizedText(locale);
            if (string2 != null) {
                string = string2;
            }
        } else {
            String string3 = StorageSettingFactory.getCanonicalModel(this.myModel);
            if (string3 != null) {
                string = string3;
            }
        }
        return string;
    }

    public int compareTo(Object object) {
        int n = -1;
        if (object instanceof StorageSettingId) {
            StorageSettingId storageSettingId = (StorageSettingId)object;
            n = this.getId().compareToIgnoreCase(storageSettingId.getId());
        }
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof StorageSettingId) {
            StorageSettingId storageSettingId = (StorageSettingId)object;
            if (this.getId().equalsIgnoreCase(storageSettingId.getId())) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.getIdHashCode();
    }

    public final String toString() {
        return this.getId();
    }
}

