/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.array;

import com.sun.netstorage.mgmt.esm.common.array.Contract;
import com.sun.netstorage.mgmt.esm.common.array.Localization;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;

public final class StoragePermission
implements Serializable,
Localizable {
    private static final String SCCS_ID = "@(#)StoragePermission.java 1.5   04/02/10 SMI";
    static final long serialVersionUID = -253786655883664284L;
    public static final String STORAGE_PERMISSION_TITLE = "Storage Permission";
    public static final String ALL_NAME = "rw";
    public static final String READ_NAME = "r-";
    public static final String WRITE_NAME = "-w";
    public static final String NONE_NAME = "--";
    public static final String ALL_DISPLAY_NAME = "Read/Write";
    public static final String READ_DISPLAY_NAME = "Read Only";
    public static final String WRITE_DISPLAY_NAME = "Write Only";
    public static final String NONE_DISPLAY_NAME = "None";
    public static final StoragePermission ALL = new StoragePermission(true, true, "rw");
    public static final StoragePermission READ = new StoragePermission(true, false, "r-");
    public static final StoragePermission WRITE = new StoragePermission(false, true, "-w");
    public static final StoragePermission NONE = new StoragePermission(false, false, "--");
    private static final HashMap ourPermissions = new HashMap();
    private static final HashMap ourResources = new HashMap(23);
    private final boolean myRead;
    private final boolean myWrite;
    private final String myName;

    private static StoragePermission getPermission(String string) {
        String string2;
        String string3 = string2 = string != null ? string.toLowerCase() : null;
        if (ourPermissions.size() == 0) {
            StoragePermission.initPermissions();
        }
        return (StoragePermission)ourPermissions.get(string2);
    }

    private static void mapPermission(String string, StoragePermission storagePermission) {
        ourPermissions.put(string, storagePermission);
    }

    private static void initPermissions() {
        StoragePermission.mapPermission(ALL_NAME, ALL);
        StoragePermission.mapPermission(READ_NAME, READ);
        StoragePermission.mapPermission(WRITE_NAME, WRITE);
        StoragePermission.mapPermission(NONE_NAME, NONE);
        StoragePermission.mapPermission(ALL_DISPLAY_NAME.toLowerCase(), ALL);
        StoragePermission.mapPermission(READ_DISPLAY_NAME.toLowerCase(), READ);
        StoragePermission.mapPermission(WRITE_DISPLAY_NAME.toLowerCase(), WRITE);
        StoragePermission.mapPermission(NONE_DISPLAY_NAME.toLowerCase(), NONE);
        StoragePermission.mapPermission("all", ALL);
        StoragePermission.mapPermission("full", ALL);
        StoragePermission.mapPermission("read,write", ALL);
        StoragePermission.mapPermission("write,read", ALL);
        StoragePermission.mapPermission("rd,wr", ALL);
        StoragePermission.mapPermission("wr,rd", ALL);
        StoragePermission.mapPermission("read", READ);
        StoragePermission.mapPermission("rd", READ);
        StoragePermission.mapPermission("write", WRITE);
        StoragePermission.mapPermission("wr", WRITE);
        StoragePermission.mapPermission("deny", NONE);
        StoragePermission.mapPermission("", NONE);
    }

    private static Resource getResource(String string) {
        String string2 = string;
        if (ourResources.size() == 0) {
            StoragePermission.initResources();
        }
        return (Resource)ourResources.get(string2);
    }

    private static void mapResource(String string, Resource resource) {
        ourResources.put(string, resource);
    }

    private static void initResources() {
        StoragePermission.mapResource(ALL_NAME, Localization.RES_ALL_DISPLAY_NAME);
        StoragePermission.mapResource(READ_NAME, Localization.RES_READ_DISPLAY_NAME);
        StoragePermission.mapResource(WRITE_NAME, Localization.RES_WRITE_DISPLAY_NAME);
        StoragePermission.mapResource(NONE_NAME, Localization.RES_NONE_DISPLAY_NAME);
    }

    public static String getLocalizedTitle() {
        return Localization.RES_STORAGE_PERMISSION_TITLE.getLocalizedText();
    }

    public static String getLocalizedTitle(Locale locale) {
        return Localization.RES_STORAGE_PERMISSION_TITLE.getLocalizedText(locale);
    }

    public static StoragePermission parsePermission(String string) {
        Contract.requires(string != null, "thePermissionName != null");
        StoragePermission storagePermission = StoragePermission.getPermission(string);
        if (storagePermission == null) {
            // empty if block
        }
        Contract.ensures(storagePermission != null, "result != null");
        return storagePermission;
    }

    public static StoragePermission valueOf(String string) {
        return StoragePermission.parsePermission(string);
    }

    private StoragePermission(boolean bl, boolean bl2, String string) {
        this.myRead = bl;
        this.myWrite = bl2;
        this.myName = string;
    }

    public final boolean hasRead() {
        return this.myRead;
    }

    public final boolean hasWrite() {
        return this.myWrite;
    }

    public final String getName() {
        return this.myName;
    }

    public final boolean hasAll() {
        return this.myRead && this.myWrite;
    }

    public final boolean hasNone() {
        return !this.myRead && !this.myWrite;
    }

    private Resource getResource() {
        return StoragePermission.getResource(this.myName);
    }

    public final String getLocalizedText() {
        return this.getLocalizedText(Locale.getDefault());
    }

    public final String getLocalizedText(Locale locale) {
        String string = null;
        Resource resource = this.getResource();
        if (resource != null) {
            string = resource.getLocalizedText(locale);
            if (string == null) {
                string = resource.getLocalizedText();
            }
            if (string == null) {
                string = resource.getLiteralText();
            }
        } else {
            string = this.myName;
        }
        return string;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof StoragePermission) {
            StoragePermission storagePermission = (StoragePermission)object;
            if (this.myRead == storagePermission.myRead && this.myWrite == storagePermission.myWrite) {
                bl = true;
            }
        }
        return bl;
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

