/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.array;

import com.sun.netstorage.mgmt.esm.common.array.Contract;
import com.sun.netstorage.mgmt.esm.common.array.StoragePermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LunMaskingInfo
implements Serializable {
    private static final String SCCS_ID = "@(#)LunMaskingInfo.java 1.3   04/02/10 SMI";
    static final long serialVersionUID = -6942792072560871607L;
    private final String myVolumeName;
    private final HashMap myMap = new HashMap();

    public LunMaskingInfo(String string) {
        Contract.requires(string != null, "theVolumeName != null");
        this.myVolumeName = string;
    }

    public final String getVolumeName() {
        return this.myVolumeName;
    }

    private EntryMap getEntryMap(String string) {
        String string2 = string.toUpperCase();
        return (EntryMap)this.myMap.get(string2);
    }

    private EntryMap createEntryMap(String string) {
        String string2 = string.toUpperCase();
        EntryMap entryMap = new EntryMap();
        this.myMap.put(string2, entryMap);
        return entryMap;
    }

    public final StoragePermission getPermission(String string, String string2) {
        Contract.requires(string != null, "theTarget != null");
        Contract.requires(string2 != null, "theInitiator != null");
        StoragePermission storagePermission = null;
        EntryMap entryMap = this.getEntryMap(string);
        if (entryMap != null) {
            storagePermission = entryMap.getPermission(string2);
        }
        if (storagePermission == null) {
            // empty if block
        }
        return storagePermission;
    }

    public final void setPermission(String string, String string2, StoragePermission storagePermission) {
        Contract.requires(string != null, "theTarget != null");
        Contract.requires(string2 != null, "theInitiator != null");
        Contract.requires(storagePermission != null, "thePerm != null");
        EntryMap entryMap = this.getEntryMap(string);
        if (entryMap == null) {
            entryMap = this.createEntryMap(string);
        }
        entryMap.setPermission(string2, storagePermission);
    }

    public final boolean containsInitiator(String string, String string2) {
        Contract.requires(string != null, "theTarget != null");
        Contract.requires(string2 != null, "theInitiator != null");
        boolean bl = false;
        EntryMap entryMap = this.getEntryMap(string);
        if (entryMap != null) {
            bl = entryMap.getPermission(string2) != null;
        }
        return bl;
    }

    public String[] getTargets() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.myMap.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String[] getInitiators(String string) {
        Contract.requires(string != null, "theTarget != null");
        String[] stringArray = null;
        EntryMap entryMap = this.getEntryMap(string);
        stringArray = entryMap != null ? entryMap.getInitiators() : new String[]{};
        return stringArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getTargets();
        stringBuffer.append("Volume: ");
        stringBuffer.append(this.getVolumeName());
        stringBuffer.append('\n');
        int n = 0;
        while (n < stringArray.length) {
            String[] stringArray2 = this.getInitiators(stringArray[n]);
            stringBuffer.append("Target Port: ");
            stringBuffer.append(stringArray[n]);
            stringBuffer.append('\n');
            int n2 = 0;
            while (n2 < stringArray2.length) {
                stringBuffer.append(stringArray2[n2]);
                stringBuffer.append(':');
                stringBuffer.append(this.getPermission(stringArray[n], stringArray2[n2]));
                stringBuffer.append('\n');
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static class EntryMap {
        private final HashMap myMap = new HashMap();

        private EntryMap() {
        }

        public final StoragePermission getPermission(String string) {
            Contract.requires(string != null, "theInitiator != null");
            String string2 = string.toUpperCase();
            StoragePermission storagePermission = (StoragePermission)this.myMap.get(string2);
            return storagePermission;
        }

        public final void setPermission(String string, StoragePermission storagePermission) {
            Contract.requires(string != null, "theInitiator != null");
            Contract.requires(storagePermission != null, "thePerm != null");
            String string2 = string.toUpperCase();
            this.myMap.put(string2, storagePermission);
        }

        public String[] getInitiators() {
            ArrayList arrayList = new ArrayList();
            Iterator iterator = this.myMap.keySet().iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }
}

