/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.common.array;

import com.sun.netstorage.mgmt.esm.common.array.AbstractStorageSetting;
import com.sun.netstorage.mgmt.esm.common.array.Contract;
import com.sun.netstorage.mgmt.esm.common.array.Localization;
import com.sun.netstorage.mgmt.esm.common.array.StorageSetting;
import com.sun.netstorage.mgmt.esm.common.array.StorageSettingId;
import com.sun.netstorage.mgmt.esm.common.array.StorageSettingType;
import com.sun.netstorage.mgmt.esm.util.l10n.Localizable;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;

public class GenericStorageSetting
extends AbstractStorageSetting
implements StorageSetting {
    private static final HashMap ourInstances = new HashMap(23);
    private static final String SCCS_ID = "@(#)GenericStorageSetting.java 1.5   04/03/01 SMI";
    static final long serialVersionUID = -1207372502213143940L;
    public static final String DISPLAYABLE_SETTING_TITLE = "Storage Setting";
    public static final String NSPOF_NAME = "No Single Point of Failure";
    public static final String NSPOF_DESCRIPTION = "Indicates the desired value for No Single Point of Failure.\nPossible values are:\n\tfalse = single point of failure, and\n\ttrue = no single point of failure.";
    public static final String NSPOF_VALUE_TRUE = "true";
    public static final String NSPOF_VALUE_FALSE = "false";
    public static final String[] NSPOF_VALUES = new String[]{"true", "false"};
    public static final boolean NSPOF_DEFAULT = false;
    public static final String DATA_REDUNDANCY_NAME = "Data Redundancy";
    public static final String DATA_REDUNDANCY_DESCRIPTION = "Data Redundancy describes the desired number of complete\ncopies of data to be maintained.  Examples would be RAID 5\nwhere 1 copy is maintained and RAID 1 where 2 or more copies\nare maintained.  Possible values are 1 to n.";
    public static final int DATA_REDUNDANCY_MIN = 1;
    public static final int DATA_REDUNDANCY_MAX = Integer.MAX_VALUE;
    public static final String PACKAGE_REDUNDANCY_NAME = "Package Redundancy";
    public static final String PACKAGE_REDUNDANCY_DESCRIPTION = "Package Redundancy describes the number of redundant\npackages to be used.  For example, in the storage domain,\npackage redundancy describes how many disk spindles can\nfail without data loss including, at most, one spare.\nAn example would be RAID5 with a spare disk which would\nhave a Package Redundancy of 2.  Possible values are 0 to n.";
    public static final int PACKAGE_REDUNDANCY_MIN = 0;
    public static final int PACKAGE_REDUNDANCY_MAX = Integer.MAX_VALUE;
    public static final String DELTA_RESERVATION_NAME = "Delta Reservation";
    public static final String DELTA_RESERVATION_DESCRIPTION = "Delta Reservation is a number between 1 (1%) and a 100 (100%)\nwhich specifies the maximum amount of space that should\nbe reserved in a replica for caching changes. For a complete\ncopy this would be 100%.";
    public static final int DELTA_RESERVATION_MIN = 1;
    public static final int DELTA_RESERVATION_MAX = 100;
    public static final String RAID0_DESCRIPTION = "Striping";
    public static final String RAID1_DESCRIPTION = "Mirroring";
    public static final String RAID2_DESCRIPTION = "Hamming Code ECC";
    public static final String RAID3_DESCRIPTION = "Striping with parity";
    public static final String RAID4_DESCRIPTION = "Striping with shared parity disk";
    public static final String RAID5_DESCRIPTION = "Striping with distributed parity";
    public static final String RAID6_DESCRIPTION = "Striping with two independent distributed parity schemes";
    public static final String RAID7_DESCRIPTION = "Optimized Asynchrony for High I/O Rates as well as High Data Transfer Rates";
    public static final String RAID10_DESCRIPTION = "Striping over RAID1";
    public static final String RAID30_DESCRIPTION = "Striping over RAID3";
    public static final String RAID50_DESCRIPTION = "Striping over RAID5";
    public static final String RAID0PLUS1_DESCRIPTION = "Striping over Mirroring";
    public static final String RAID1S_DESCRIPTION = "RAID1 with hot spare";
    public static final String RAID5S_DESCRIPTION = "RAID5 with hot spare";
    public static final StorageSetting RAID0 = GenericStorageSetting.createRAID("RAID0", false, 1, 0, 1, Localization.RES_RAID0_DESCRIPTION);
    public static final StorageSetting RAID1 = GenericStorageSetting.createRAID("RAID1", true, 2, 1, 30, Localization.RES_RAID1_DESCRIPTION);
    public static final StorageSetting RAID1S = GenericStorageSetting.createRAID("RAID1S", true, 2, 2, 30, Localization.RES_RAID1S_DESCRIPTION);
    public static final StorageSetting RAID5 = GenericStorageSetting.createRAID("RAID5", true, 1, 1, 30, Localization.RES_RAID5_DESCRIPTION);
    public static final StorageSetting RAID5S = GenericStorageSetting.createRAID("RAID5S", true, 1, 2, 30, Localization.RES_RAID5S_DESCRIPTION);
    private final BooleanData myNoSinglePointOfFailure = new BooleanData(Localization.RES_NSPOF_NAME, Localization.RES_NSPOF_DESCRIPTION, false);
    private final IntegerData myDataRedundancy = new IntegerData(Localization.RES_DATA_REDUNDANCY_NAME, Localization.RES_DATA_REDUNDANCY_DESCRIPTION, 1, Integer.MAX_VALUE);
    private final IntegerData myPackageRedundancy = new IntegerData(Localization.RES_PACKAGE_REDUNDANCY_NAME, Localization.RES_PACKAGE_REDUNDANCY_DESCRIPTION, 0, Integer.MAX_VALUE);
    private final IntegerData myDeltaReservation = new IntegerData(Localization.RES_DELTA_RESERVATION_NAME, Localization.RES_DELTA_RESERVATION_DESCRIPTION, 1, 100);
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$common$array$GenericStorageSetting;

    public static GenericStorageSetting getInstance(String string) {
        GenericStorageSetting genericStorageSetting = null;
        if (string != null) {
            String string2 = string.toLowerCase();
            genericStorageSetting = (GenericStorageSetting)ourInstances.get(string2);
        }
        return genericStorageSetting;
    }

    private static void internInstance(GenericStorageSetting genericStorageSetting) {
        String string = genericStorageSetting.getName().toLowerCase();
        ourInstances.put(string, genericStorageSetting);
    }

    public static String getLocalizedTitle() {
        return Localization.RES_DISPLAYABLE_SETTING_TITLE.getLocalizedText();
    }

    public static String getLocalizedTitle(Locale locale) {
        return Localization.RES_DISPLAYABLE_SETTING_TITLE.getLocalizedText(locale);
    }

    public static GenericStorageSetting createRAID(String string, boolean bl, int n, int n2, int n3, Resource resource) {
        GenericStorageSetting genericStorageSetting = GenericStorageSetting.getInstance(string);
        if (genericStorageSetting == null) {
            genericStorageSetting = new GenericStorageSetting(string, resource, bl, n, n2, n3);
        }
        return genericStorageSetting;
    }

    public static GenericStorageSetting createRAID(String string, boolean bl, int n, int n2, int n3) {
        return GenericStorageSetting.createRAID(string, bl, n, n2, n3, GenericStorageSetting.toResource(string));
    }

    static Resource toResource(String string) {
        String string2 = (class$com$sun$netstorage$mgmt$esm$common$array$GenericStorageSetting == null ? (class$com$sun$netstorage$mgmt$esm$common$array$GenericStorageSetting = GenericStorageSetting.class$("com.sun.netstorage.mgmt.esm.common.array.GenericStorageSetting")) : class$com$sun$netstorage$mgmt$esm$common$array$GenericStorageSetting).getName();
        return new Resource(string2, "fubar", string);
    }

    private GenericStorageSetting(String string, Resource resource, boolean bl, int n, int n2, int n3) {
        super(StorageSettingId.create(string), StorageSettingType.GENERIC, string, resource);
        this.myNoSinglePointOfFailure.set(bl);
        this.myDataRedundancy.setGoal(n);
        this.myPackageRedundancy.setGoal(n2);
        this.myDeltaReservation.setGoal(n3);
        GenericStorageSetting.internInstance(this);
    }

    private GenericStorageSetting(String string, boolean bl, int n, int n2, int n3) {
        this(string, GenericStorageSetting.toResource(string), bl, n, n2, n3);
    }

    public final BooleanData getNoSinglePointOfFailureData() {
        return this.myNoSinglePointOfFailure;
    }

    public final IntegerData getDataRedundancyData() {
        return this.myDataRedundancy;
    }

    public final IntegerData getPackageRedundancyData() {
        return this.myPackageRedundancy;
    }

    public final IntegerData getDeltaReservationData() {
        return this.myDeltaReservation;
    }

    public Properties getProperties(Locale locale) {
        Properties properties = new Properties();
        String string = null;
        String string2 = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        string = this.getNoSinglePointOfFailureData().getLocalizedText(locale);
        string2 = String.valueOf(this.getNoSinglePointOfFailureData().getGoal());
        properties.setProperty(string, string2);
        string = this.getDataRedundancyData().getLocalizedText(locale);
        string2 = String.valueOf(this.getDataRedundancyData().getGoal());
        properties.setProperty(string, string2);
        string = this.getPackageRedundancyData().getLocalizedText(locale);
        string2 = String.valueOf(this.getPackageRedundancyData().getGoal());
        properties.setProperty(string, string2);
        string = this.getDeltaReservationData().getLocalizedText(locale);
        string2 = String.valueOf(this.getDeltaReservationData().getGoal());
        properties.setProperty(string, string2);
        return properties;
    }

    public boolean isNoSinglePointOfFailure() {
        return this.getNoSinglePointOfFailureData().getGoal();
    }

    public int getDataRedundancy() {
        return this.getDataRedundancyData().getGoal();
    }

    public int getPackageRedundancy() {
        return this.getPackageRedundancyData().getGoal();
    }

    public int getDeltaReservation() {
        return this.getDeltaReservationData().getGoal();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getId());
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class IntegerData
    extends Data {
        private final int myMinBound;
        private final int myMaxBound;
        private int myGoal;
        private int myMin;
        private int myMax;

        public IntegerData(Resource resource, Resource resource2, int n, int n2) {
            super(resource, resource2);
            this.myMinBound = n;
            this.myMaxBound = n2;
            this.myGoal = n;
            this.myMin = n;
            this.myMax = n;
        }

        public final int getMinBound() {
            return this.myMinBound;
        }

        public final int getMaxBound() {
            return this.myMaxBound;
        }

        public final int getGoal() {
            return this.myGoal;
        }

        public final void setGoal(int n) {
            Contract.requires(n >= this.getMinBound(), "theGoal >= getMinBound()");
            Contract.requires(n <= this.getMaxBound(), "theGoal <= getMaxBound()");
            this.myGoal = n;
        }

        public final int getMin() {
            return this.myMin;
        }

        public final void setMin(int n) {
            Contract.requires(n >= this.getMinBound(), "theMin >= getMinBound()");
            Contract.requires(n <= this.getMaxBound(), "theMin <= getMaxBound()");
            this.myMin = n;
        }

        public final int getMax() {
            return this.myMax;
        }

        public final void setMax(int n) {
            Contract.requires(n >= this.getMinBound(), "theMax >= getMinBound()");
            Contract.requires(n <= this.getMaxBound(), "theMax <= getMaxBound()");
            this.myMax = n;
        }

        public final boolean matches(int n) {
            return this.myMin <= n && n <= this.myMax;
        }

        public final void set(int n) {
            this.setGoal(n);
            this.setMin(n);
            this.setMax(n);
        }

        public final void set(int n, int n2, int n3) {
            Contract.requires(n >= n2, "theGoal >= theMin");
            Contract.requires(n <= n3, "theGoal <= theMax");
            Contract.requires(n3 >= n2, "theMax >= theMin");
            this.setGoal(n);
            this.setMin(n2);
            this.setMax(n3);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append('{');
            stringBuffer.append(this.myGoal);
            stringBuffer.append(',');
            stringBuffer.append(this.myMin);
            stringBuffer.append(',');
            stringBuffer.append(this.myMax);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof IntegerData) {
                IntegerData integerData = (IntegerData)object;
                if (this.myGoal == integerData.myGoal && this.myMin == integerData.myMin && this.myMax == integerData.myMax) {
                    bl = true;
                }
            }
            return bl;
        }

        public final int hashCode() {
            return this.myGoal + this.myMin + this.myMax;
        }
    }

    public static class BooleanData
    extends Data {
        private final boolean myDefault;
        private boolean myGoal;

        public BooleanData(Resource resource, Resource resource2, boolean bl) {
            super(resource, resource2);
            this.myDefault = bl;
            this.myGoal = bl;
        }

        public final boolean getDefault() {
            return this.myDefault;
        }

        public final boolean getGoal() {
            return this.myGoal;
        }

        public final void setGoal(boolean bl) {
            this.myGoal = bl;
        }

        public final boolean matches(boolean bl) {
            return this.myGoal == bl;
        }

        public final void set(boolean bl) {
            this.setGoal(bl);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(this.myGoal);
            return stringBuffer.toString();
        }

        public final boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof BooleanData) {
                BooleanData booleanData = (BooleanData)object;
                if (this.myGoal == booleanData.myGoal) {
                    bl = true;
                }
            }
            return bl;
        }

        public final int hashCode() {
            return this.myGoal ? 1 : -1;
        }
    }

    public static abstract class Data
    implements Localizable,
    Serializable {
        private final Resource myName;
        private final Resource myDescription;

        public Data(Resource resource, Resource resource2) {
            this.myName = resource;
            this.myDescription = resource2;
        }

        public final String getLocalizedName() {
            return this.getLocalizedName(Locale.getDefault());
        }

        public final String getLocalizedName(Locale locale) {
            String string = this.myName.getLocalizedText(locale);
            if (string == null) {
                string = this.myName.getLocalizedText();
            }
            if (string == null) {
                string = this.myName.getLiteralText();
            }
            return string;
        }

        public final String getLocalizedDescription() {
            return this.getLocalizedDescription(Locale.getDefault());
        }

        public final String getLocalizedDescription(Locale locale) {
            String string = this.myDescription.getLocalizedText(locale);
            if (string == null) {
                string = this.myDescription.getLocalizedText();
            }
            if (string == null) {
                string = this.myDescription.getLiteralText();
            }
            return string;
        }

        public final String getLocalizedText() {
            return this.getLocalizedText(Locale.getDefault());
        }

        public final String getLocalizedText(Locale locale) {
            return this.getLocalizedName(locale);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getLocalizedText());
            stringBuffer.append(" = ");
            return stringBuffer.toString();
        }
    }
}

