/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.unittest;

import com.sun.jade.util.unittest.UnitTest;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class Run {
    private int verbose;
    private Class c;
    private static final int VERBOSE_NONE = 0;
    private static final int VERBOSE_LOW = 1;
    private static final int VERBOSE_HIGH = 2;
    private static int NO_TESTS;
    private static int PASSED;
    private static int FAILED;
    static /* synthetic */ Class class$com$sun$jade$util$unittest$UnitTest;

    public Run(Class clazz) {
        this.c = clazz;
    }

    public int runUnitTests() throws Exception {
        Object object;
        Object object2;
        int n = 0;
        if (this.c.isInterface()) {
            return 0;
        }
        Method[] methodArray = this.c.getDeclaredMethods();
        boolean bl = true;
        int n2 = 0;
        while (n2 < methodArray.length) {
            object2 = methodArray[n2];
            object = ((Method)object2).getName();
            if (((Method)object2).getName().equals("main")) {
                bl = false;
                break;
            }
            ++n2;
        }
        object2 = this.c.getDeclaredClasses();
        object = null;
        int n3 = 0;
        while (n3 < ((Object)object2).length) {
            if ((class$com$sun$jade$util$unittest$UnitTest == null ? Run.class$("com.sun.jade.util.unittest.UnitTest") : class$com$sun$jade$util$unittest$UnitTest).isAssignableFrom((Class<?>)object2[n3])) {
                object = object2[n3];
                break;
            }
            ++n3;
        }
        if (object == null) {
            if (!bl) {
                return 0;
            }
            ++NO_TESTS;
            if (this.verbose > 1) {
                System.err.println(this.c.getName() + ": No Unit Test");
            }
            return 1;
        }
        if (!Modifier.isStatic(((Class)object).getModifiers()) || !Modifier.isPublic(((Class)object).getModifiers())) {
            ++NO_TESTS;
            if (this.verbose > 1) {
                System.err.println(this.c.getName() + ": No public static Unit Test.");
            }
            return 1;
        }
        if (this.verbose > 0) {
            System.out.println(this.c.getName() + ": Running Unit Test.");
        }
        this.runTestMethods((Class)object);
        return n;
    }

    private void runTestMethods(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        Object var3_3 = null;
        try {
            var3_3 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Failed to create " + clazz);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println("Not allowed to create " + clazz);
            return;
        }
        if (var3_3 != null) {
            ((UnitTest)var3_3).init();
        }
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            String string = method.getName();
            if (!string.equals("cleanup") && !string.equals("init")) {
                Throwable throwable = null;
                if (method.getParameterTypes().length == 0 && method.getReturnType() == Void.TYPE && Modifier.isPublic(method.getModifiers())) {
                    try {
                        method.invoke(var3_3, new Object[0]);
                        if (this.verbose > 1) {
                            System.out.println("\t" + string + " passed.");
                        }
                        ++PASSED;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throwable = invocationTargetException.getCause();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                    }
                    if (throwable != null) {
                        System.out.println("###");
                        System.out.println(clazz.getName() + ":" + method.getName() + " FAILED.");
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        throwable.printStackTrace(printWriter);
                        String string2 = stringWriter.toString();
                        int n2 = string2.indexOf("at java.lang.reflect.Method.invoke");
                        if (n2 > 0) {
                            string2 = string2.substring(0, n2 - 1);
                        }
                        System.out.println(string2);
                        ++FAILED;
                    }
                }
            }
            ++n;
        }
        if (var3_3 != null) {
            ((UnitTest)var3_3).cleanup();
        }
    }

    public Class getTestClass() {
        return this.c;
    }

    public void setTestClass(Class clazz) {
        this.c = clazz;
    }

    static ArrayList getClassesFromPath(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(string);
        if (file.isDirectory()) {
            Object object;
            String[] stringArray = file.list();
            int n = stringArray.length;
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                String string2 = string + File.separator + stringArray[n2];
                object = new File(string2);
                if (((File)object).isDirectory()) {
                    arrayList.add(string2);
                }
                if (stringArray[n2].endsWith(".class")) {
                    bl = true;
                }
                ++n2;
            }
            if (!bl) {
                return arrayList;
            }
            int n3 = string.indexOf("com/sun");
            if (n3 < 0) {
                return arrayList;
            }
            object = string.substring(n3).replace(File.separatorChar, '.');
            if (!((String)object).endsWith(".")) {
                object = (String)object + ".";
            }
            n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].endsWith(".class") && -1 == stringArray[n2].indexOf(36) && !stringArray[n2].endsWith("_Stub.class") && !stringArray[n2].endsWith("Proxy.class") && !stringArray[n2].endsWith("_Skel.class")) {
                    int n4 = stringArray[n2].length() - 6;
                    arrayList.add((String)object + stringArray[n2].substring(0, n4));
                }
                ++n2;
            }
        } else {
            arrayList.add(string);
        }
        return arrayList;
    }

    private static void runTest(Run run, String string) throws Exception {
        ClassLoader classLoader = run.getClass().getClassLoader();
        File file = new File(string);
        if (file.isDirectory()) {
            ArrayList arrayList = Run.getClassesFromPath(string);
            int n = 0;
            while (n < arrayList.size()) {
                Run.runTest(run, (String)arrayList.get(n));
                ++n;
            }
            return;
        }
        try {
            try {
                System.out.println("Finding unit tests for class: " + string);
                run.setTestClass(Class.forName(string, false, classLoader));
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                System.err.println("No UnitTest for " + string + " (Unsatisfied Link)");
            }
            run.runUnitTests();
        }
        catch (Throwable throwable) {
            System.err.println("Run failed.");
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public static void usage() {
        System.out.println("Usage: Run [options] <qualified class | package dir>");
        System.out.println("Options:\n\t-v  Verbose output");
    }

    public static void main(String[] stringArray) {
        try {
            CharSequence charSequence;
            Run run = new Run(null);
            long l = System.currentTimeMillis();
            int n = 0;
            while (n < stringArray.length) {
                charSequence = stringArray[n];
                if (!((String)charSequence).startsWith("-") || ((String)charSequence).equals("-")) break;
                if (((String)charSequence).equals("-v")) {
                    run.verbose = 1;
                } else if (((String)charSequence).equals("-V")) {
                    run.verbose = 2;
                } else {
                    Run.usage();
                    System.exit(-1);
                }
                ++n;
            }
            if (stringArray.length - 1 != n) {
                Run.usage();
                System.exit(1);
            }
            Run.runTest(run, stringArray[n]);
            charSequence = new StringBuffer();
            long l2 = System.currentTimeMillis() - l;
            ((StringBuffer)charSequence).append("Time: ");
            ((StringBuffer)charSequence).append("" + l2 / 1000L + ".");
            long l3 = l2 % 1000L;
            if (l3 > 100L) {
                ((StringBuffer)charSequence).append("" + l3);
            } else if (l3 > 10L) {
                ((StringBuffer)charSequence).append("0" + l3);
            } else {
                ((StringBuffer)charSequence).append("00" + l3);
            }
            ((StringBuffer)charSequence).append("\n\n");
            if (FAILED > 0) {
                ((StringBuffer)charSequence).append("OK (");
                ((StringBuffer)charSequence).append(PASSED);
                ((StringBuffer)charSequence).append(" tests)\n");
                ((StringBuffer)charSequence).append("FAIL (" + FAILED + "tests)\n");
            } else {
                ((StringBuffer)charSequence).append("OK (");
                ((StringBuffer)charSequence).append(PASSED);
                ((StringBuffer)charSequence).append(" tests)\n");
            }
            System.out.println(((StringBuffer)charSequence).toString());
            System.exit(FAILED);
        }
        catch (Throwable throwable) {
            System.out.println("Fatal Test runner error.");
            System.out.println("Exception thrown outside of unit test.");
            throwable.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            Run run = new Run(null);
        }
    }
}

