/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util;

import com.sun.jade.util.PropertiesPersistenceException;
import com.sun.jade.util.Propertizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;

public class PropertiesPersister {
    public static final String SAVE_DIR_PROP = "storade.propsSaveDir";
    private static String saveDir = System.getProperty("storade.propsSaveDir");

    public static String getSaveDir() {
        return saveDir;
    }

    public static void saveProperties(Properties properties, String string) throws PropertiesPersistenceException {
        string = PropertiesPersister.getFilename(string);
        try {
            properties.store(new FileOutputStream(string), null);
        }
        catch (Exception exception) {
            throw new PropertiesPersistenceException("Failed to save properties to file " + string, exception);
        }
    }

    public static void saveProperties(Propertizable propertizable, String string) throws PropertiesPersistenceException {
        PropertiesPersister.saveProperties(propertizable.toProperties(), string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Properties restoreProperties(String string) throws PropertiesPersistenceException {
        Properties properties;
        string = PropertiesPersister.getFilename(string);
        FileInputStream fileInputStream = null;
        try {
            try {
                Properties properties2 = new Properties();
                fileInputStream = new FileInputStream(string);
                properties2.load(fileInputStream);
                properties = properties2;
                Object var5_5 = null;
                if (fileInputStream == null) return properties;
            }
            catch (Exception exception) {
                throw new PropertiesPersistenceException("Failed to restore properties from file " + string, exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception exception) {
            // empty catch block
            return properties;
        }
        fileInputStream.close();
        return properties;
    }

    public static void restoreProperties(Propertizable propertizable, String string) throws PropertiesPersistenceException {
        Properties properties = PropertiesPersister.restoreProperties(string);
        try {
            propertizable.fromProperties(properties);
        }
        catch (Exception exception) {
            throw new PropertiesPersistenceException("Failed to restore properties from file " + string, propertizable, exception);
        }
    }

    public static void deleteProperties(String string) throws PropertiesPersistenceException {
        File file = new File(PropertiesPersister.getFilename(string));
        if (!file.exists()) {
            throw new PropertiesPersistenceException("File " + string + " does not exist.");
        }
        file.delete();
    }

    private static String getFilename(String string) {
        return saveDir + "/" + string;
    }
}

