/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.service.api;

import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.service.api.Contract;
import com.sun.netstorage.mgmt.esm.logic.service.api.ElementSummary;
import com.sun.netstorage.mgmt.esm.logic.service.api.ElementTransferObject;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.PropertyMap;
import java.util.LinkedHashMap;
import java.util.Set;

public class ElementDetails
extends ElementTransferObject {
    private static final String SCCS_ID = "@(#)ElementDetails.java 1.6   03/07/24 SMI";
    public static final String ASSET_PROPERTIES = "asset";
    public static final String HEALTH_PROPERTIES = "health";
    public static final String CONTROL_PROPERTIES = "control";
    public static final String ALARM_SUMMARIES = "alarms";
    public static final String EVENT_SUMMARIES = "events";
    public static final String PHYSICAL_SUMMARIES = "physical";
    public static final String LOGICAL_SUMMARIES = "logical";
    private final LinkedHashMap myPropertiesMap = new LinkedHashMap();
    private final LinkedHashMap myComponentsMap = new LinkedHashMap();

    public ElementDetails(Identity identity, ElementType elementType) {
        super(identity, elementType);
    }

    public ElementDetails(Identity identity) {
        this(identity, null);
    }

    public final boolean hasProperties(String string) {
        PropertyMap propertyMap;
        Contract.requires((string != null ? 1 : 0) != 0, (String)"thePropertiesFlavor != null");
        boolean bl = this.myPropertiesMap.containsKey(string);
        if (bl && (propertyMap = this.getProperties(string)).isEmpty()) {
            bl = false;
        }
        return bl;
    }

    public final PropertyMap getProperties(String string) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"thePropertiesFlavor != null");
        return (PropertyMap)this.myPropertiesMap.get(string);
    }

    void setProperties(String string, PropertyMap propertyMap) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"thePropertiesFlavor != null");
        Contract.requires((propertyMap != null ? 1 : 0) != 0, (String)"theProperties != null");
        Contract.requires((boolean)this.isMutable(), (String)"isMutable()");
        this.myPropertiesMap.put(string, propertyMap);
    }

    public final String[] getPropertyFlavors() {
        Set set = this.myPropertiesMap.keySet();
        int n = set.size();
        String[] stringArray = new String[n];
        if (n > 0) {
            set.toArray(stringArray);
        }
        Contract.ensures((stringArray != null ? 1 : 0) != 0, (String)"result != null");
        return stringArray;
    }

    public final boolean hasAssetProperties() {
        return this.hasProperties(ASSET_PROPERTIES);
    }

    public final PropertyMap getAssetProperties() {
        return this.getProperties(ASSET_PROPERTIES);
    }

    public final boolean hasHealthProperties() {
        return this.hasProperties(HEALTH_PROPERTIES);
    }

    public final PropertyMap getHealthProperties() {
        return this.getProperties(HEALTH_PROPERTIES);
    }

    public final boolean hasControlProperties() {
        return this.hasProperties(CONTROL_PROPERTIES);
    }

    public final PropertyMap getControlProperties() {
        return this.getProperties(CONTROL_PROPERTIES);
    }

    public final boolean hasComponents(String string) {
        ElementSummary[] elementSummaryArray;
        boolean bl = this.myComponentsMap.containsKey(string);
        if (bl && ((elementSummaryArray = this.getComponents(string)) == null || elementSummaryArray.length == 0)) {
            bl = false;
        }
        return bl;
    }

    public final ElementSummary[] getComponents(String string) {
        ElementSummary[] elementSummaryArray = (ElementSummary[])this.myComponentsMap.get(string);
        if (elementSummaryArray == null) {
            return new ElementSummary[0];
        }
        return elementSummaryArray;
    }

    void setComponents(String string, ElementSummary[] elementSummaryArray) {
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theElementFlavor != null");
        Contract.requires((elementSummaryArray != null ? 1 : 0) != 0, (String)"theComponents != null");
        Contract.requires((boolean)this.isMutable(), (String)"isMutable()");
        this.myComponentsMap.put(string, elementSummaryArray);
    }

    public final String[] getComponentFlavors() {
        Set set = this.myComponentsMap.keySet();
        int n = set.size();
        String[] stringArray = new String[n];
        if (n > 0) {
            set.toArray(stringArray);
        }
        return stringArray;
    }

    public final boolean hasAlarmComponents() {
        return this.hasComponents(ALARM_SUMMARIES);
    }

    public final ElementSummary[] getAlarmComponents() {
        return this.getComponents(ALARM_SUMMARIES);
    }

    public final boolean hasEventComponents() {
        return this.hasComponents(EVENT_SUMMARIES);
    }

    public final ElementSummary[] getEventComponents() {
        return this.getComponents(EVENT_SUMMARIES);
    }

    public final boolean hasPhysicalComponents() {
        return this.hasComponents(PHYSICAL_SUMMARIES);
    }

    public final ElementSummary[] getPhysicalComponents() {
        return this.getComponents(PHYSICAL_SUMMARIES);
    }

    public final boolean hasLogicalComponents() {
        return this.hasComponents(LOGICAL_SUMMARIES);
    }

    public final ElementSummary[] getLogicalComponents() {
        return this.getComponents(LOGICAL_SUMMARIES);
    }
}

