/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.revanalysis.api;

import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.revanalysis.api.Revision;
import com.sun.netstorage.mgmt.esm.logic.revanalysis.api.UpgradeAction;
import com.sun.netstorage.mgmt.esm.logic.revanalysis.api.UpgradeDetails;
import java.io.Serializable;
import java.util.Date;

public class UpgradeDetailsReport
implements Serializable {
    private UpgradeDetails[] upgradeDetails;
    private Identity elementID;
    private String elementName;
    private Date analysisDate;
    private boolean isOutOfDate;
    private String alarmID;

    public UpgradeDetailsReport(Identity identity, String string, Date date, boolean bl, String string2) {
        this.setElementID(identity);
        this.setElementName(string);
        this.setAnalysisDate(date);
        this.setIsOutOfDate(bl);
        this.setAlarmID(string2);
    }

    public UpgradeDetailsReport(Identity identity, String string, Date date, UpgradeDetails[] upgradeDetailsArray) {
        this.setElementID(identity);
        this.setElementName(string);
        this.setAnalysisDate(date);
        this.setDetails(upgradeDetailsArray);
    }

    public UpgradeDetailsReport(Identity identity, String string, Date date, UpgradeDetails[] upgradeDetailsArray, boolean bl, String string2) {
        this.setElementID(identity);
        this.setElementName(string);
        this.setAnalysisDate(date);
        this.setDetails(upgradeDetailsArray);
        this.setIsOutOfDate(bl);
        this.setAlarmID(string2);
    }

    public Identity getElementID() {
        return this.elementID;
    }

    public void setElementID(Identity identity) {
        this.elementID = identity;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String string) {
        this.elementName = string;
    }

    public Date getAnalysisDate() {
        return this.analysisDate;
    }

    public void setAnalysisDate(Date date) {
        this.analysisDate = date;
    }

    public UpgradeDetails[] getDetails() {
        return this.upgradeDetails;
    }

    public void setDetails(UpgradeDetails[] upgradeDetailsArray) {
        this.upgradeDetails = upgradeDetailsArray;
    }

    public void addDetails(UpgradeDetails upgradeDetails) {
        if (this.upgradeDetails == null) {
            this.upgradeDetails = new UpgradeDetails[]{upgradeDetails};
        } else {
            UpgradeDetails[] upgradeDetailsArray = new UpgradeDetails[this.upgradeDetails.length + 1];
            System.arraycopy(this.upgradeDetails, 0, upgradeDetailsArray, 0, this.upgradeDetails.length);
            upgradeDetailsArray[upgradeDetailsArray.length - 1] = upgradeDetails;
            this.upgradeDetails = upgradeDetailsArray;
        }
    }

    public boolean isOutOfDate() {
        return this.isOutOfDate;
    }

    public void setIsOutOfDate(boolean bl) {
        this.isOutOfDate = bl;
    }

    public String getAlarmID() {
        return this.alarmID;
    }

    public void setAlarmID(String string) {
        this.alarmID = string;
    }

    public String toString() {
        String string = "UpgradeDetailsReport for device " + this.getElementName() + " (" + this.getElementID() + "):\n";
        string = string + "\tGenerated at " + this.getAnalysisDate() + ", Out Of Date? " + this.isOutOfDate() + "\n";
        if (this.getDetails() == null || this.getDetails().length == 0) {
            string = string + "\tNo upgrades required.";
        } else {
            UpgradeDetails[] upgradeDetailsArray = this.getDetails();
            int n = upgradeDetailsArray.length;
            string = string + "\t" + n + " frus Analyzed: ";
            int n2 = 0;
            while (n2 < n) {
                UpgradeAction upgradeAction = upgradeDetailsArray[n2].getUpgradeAction();
                Revision revision = upgradeDetailsArray[n2].getCurrentRevision();
                Revision revision2 = upgradeDetailsArray[n2].getTargetRevision();
                string = string + "\n\t\tUpgrade:\n\t\t\tComponentID=" + upgradeDetailsArray[n2].getComponentID() + "\n" + "\t\t\tComponentName=" + upgradeDetailsArray[n2].getComponentName() + "\n" + "\t\t\tComponentFlavor=" + upgradeDetailsArray[n2].getComponentFlavor() + "\n" + "\t\t\tCurrentRevision=" + revision.getName() + "/" + revision.getValue() + "\n" + "\t\t\tStatus=" + upgradeDetailsArray[n2].getStatus() + "\n";
                string = revision2 != null ? string + "\t\t\tUpgradeType=" + upgradeDetailsArray[n2].getUpgradeType() + "\n" + "\t\t\tTargetRevision=" + revision2.getName() + "/" + revision2.getValue() + "\n" + "\t\t\tUpgradeAction=" + upgradeAction.getID() + "/" + upgradeAction.getShortDescription() + "/" + upgradeAction.getAuthorityName() : string + "\t\t\tTargetRevision=null\n\t\t\tUpgradeAction=null";
                ++n2;
            }
        }
        return string;
    }
}

