/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.identity.api;

import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class IdentityMap
implements Serializable {
    private int size;
    private Hashtable ids = new Hashtable(3);

    public int containsIdentity(String string) {
        return this.containsIdentity(IdentityType.getInstance(string));
    }

    public int containsIdentity(IdentityType identityType) {
        if (this.ids.containsKey(identityType = IdentityType.getInstance(identityType.getName()))) {
            Identity[] identityArray = (Identity[])this.ids.get(identityType);
            return identityArray.length;
        }
        return 0;
    }

    public boolean containsIdentity(Identity identity) {
        Collection collection = this.ids.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identity[] identityArray = (Identity[])iterator.next();
            int n = 0;
            while (n < identityArray.length) {
                if (identityArray[n].equals(identity)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public Identity[] get(IdentityType identityType) {
        return (Identity[])this.ids.get(identityType);
    }

    public void put(Identity identity) {
        Identity[] identityArray = (Identity[])this.ids.get(identity.getType());
        if (identityArray != null) {
            if (this.containsIdentity(identity)) {
                return;
            }
            Identity[] identityArray2 = new Identity[identityArray.length + 1];
            System.arraycopy(identityArray, 0, identityArray2, 0, identityArray.length);
            identityArray2[identityArray2.length - 1] = identity;
            this.ids.put(identity.getType(), identityArray2);
        } else {
            Identity[] identityArray3 = new Identity[]{identity};
            this.ids.put(identity.getType(), identityArray3);
        }
        ++this.size;
    }

    public void remove(Identity identity) {
        Identity[] identityArray = (Identity[])this.ids.get(identity.getType());
        Vector<Identity> vector = new Vector<Identity>();
        if (identityArray != null) {
            int n = 0;
            while (n < identityArray.length) {
                if (!identity.equals(identityArray[n])) {
                    vector.addElement(identityArray[n]);
                }
                ++n;
            }
            if (vector.size() == identityArray.length) {
                return;
            }
            if (vector.size() == 0) {
                this.ids.remove(identity.getType());
            } else {
                Object[] objectArray = new Identity[vector.size()];
                vector.copyInto(objectArray);
                this.ids.put(identity.getType(), objectArray);
            }
            --this.size;
        }
    }

    public int size() {
        return this.size;
    }

    public Enumeration getTypes() {
        return this.ids.keys();
    }

    public Map getIDs() {
        return new Hashtable(this.ids);
    }

    public String toString() {
        if (this.ids.size() == 0) {
            return null;
        }
        String string = "";
        Enumeration enumeration = this.ids.keys();
        while (enumeration.hasMoreElements()) {
            IdentityType identityType = (IdentityType)enumeration.nextElement();
            Identity[] identityArray = (Identity[])this.ids.get(identityType);
            string = string + "Type: " + identityType + " ";
            int n = 0;
            while (n < identityArray.length) {
                string = string + "Value: " + identityArray[n].getValue() + " ";
                ++n;
            }
            if (!enumeration.hasMoreElements()) continue;
            string = string + "\n";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        Identity identity = new Identity("foo", IdentityType.HOSTNAME);
        Identity identity2 = new Identity("bar", IdentityType.HOSTNAME);
        Identity identity3 = new Identity("123.456.78.9", IdentityType.IPV4);
        IdentityMap identityMap = new IdentityMap();
        identityMap.put(identity);
        identityMap.put(identity2);
        identityMap.put(identity3);
        System.out.println("The map after 3 identities have been added is: \n" + identityMap);
        identityMap.remove(identity);
        System.out.println("The map after removing 1 id is: \n" + identityMap);
        identityMap.remove(identity3);
        System.out.println("The map after removing another id is: \n" + identityMap);
        identityMap.remove(identity2);
        System.out.println("The map after removing the last id is: \n" + identityMap);
        identityMap.put(identity);
        System.out.println("The map after adding 1 id is: \n" + identityMap);
    }
}

