/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.identity.api;

import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Localization;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.io.Serializable;

public abstract class IdentityException
extends LocalizableException {
    private static final String SCCS_ID = "@(#)IdentityException.java 1.4   03/05/01 SMI";
    public static final String INVALID_IDENTITY = "the specified identity ({0}) is invalid";
    public static final String UNKNOWN_IDENTITY = "the specified identity ({0}) is unknown by the application";
    public static final String AMBIGUOUS_IDENTITY = "\tthe specified identity ({0}) is ambiguous in the application\n\twhere the list of matching identities is the following:\n";
    private final Identity myIdentity;

    protected IdentityException(Identity identity) {
        this.myIdentity = identity;
        if (identity != null) {
            super.getSupport().addMessageArg((Serializable)identity);
        }
    }

    protected IdentityException() {
        this(null);
    }

    public final Identity getIdentity() {
        return this.myIdentity;
    }

    public static final class AmbiguousIdentity
    extends IdentityException {
        private final Identity[] myCollisions;

        public AmbiguousIdentity(Identity identity, Identity[] identityArray) {
            super(identity);
            this.myCollisions = identityArray;
            StringBuffer stringBuffer = new StringBuffer();
            if (identityArray != null) {
                int n = 0;
                while (n < identityArray.length) {
                    if (n > 0) {
                        stringBuffer.append('\n');
                    }
                    stringBuffer.append('\t');
                    stringBuffer.append(identityArray[n]);
                    ++n;
                }
            } else {
                stringBuffer.append("none");
            }
            super.getSupport().addMessageArg((Serializable)((Object)stringBuffer.toString()));
            this.getSupport().initMessage(Localization.FMT_AMBIGUOUS_IDENTITY);
        }

        public final Identity[] getCollisions() {
            return this.myCollisions;
        }
    }

    public static final class UnknownIdentity
    extends IdentityException {
        public UnknownIdentity(Identity identity) {
            super(identity);
            this.getSupport().initMessage(Localization.FMT_UNKNOWN_IDENTITY);
        }
    }

    public static final class InvalidIdentity
    extends IdentityException {
        public InvalidIdentity(Identity identity) {
            super(identity);
            this.getSupport().initMessage(Localization.FMT_INVALID_IDENTITY);
        }
    }
}

