/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.device.api;

import com.sun.netstorage.mgmt.esm.logic.device.api.ConfigItem;
import com.sun.netstorage.mgmt.esm.logic.device.api.IdElement;
import com.sun.netstorage.mgmt.esm.logic.device.api.PackageUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DeviceConfig {
    private String type;
    private static final String PROPS_DIR = "storade.propsSaveDir";
    private ConfigItem mfItem;
    private List components;
    private List probes;
    private List elements;
    public static final String sccs_id = "@(#)DeviceConfig.java\t1.7 05/16/03 SMI";

    public DeviceConfig(String string) {
        block2: {
            this.type = string;
            try {
                this.parseConfig();
            }
            catch (Exception exception) {
                if (!PackageUtil.logger.isLoggable(Level.WARNING)) break block2;
                PackageUtil.logger.log(Level.WARNING, "Parse Error ", exception);
            }
        }
    }

    public ConfigItem getDevice() {
        return this.mfItem;
    }

    public Collection getComponents() {
        return this.components;
    }

    public Collection getProbes() {
        return this.probes;
    }

    public Collection getIds() {
        return this.elements;
    }

    public String toString() {
        ConfigItem configItem;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Management Facade:\n");
        this.mfItem.list(stringBuffer);
        stringBuffer.append("Components:\n");
        Iterator iterator = this.components.iterator();
        while (iterator.hasNext()) {
            configItem = (ConfigItem)iterator.next();
            if (configItem == null) continue;
            configItem.list(stringBuffer);
        }
        stringBuffer.append("Probes:\n");
        iterator = this.probes.iterator();
        while (iterator.hasNext()) {
            configItem = (ConfigItem)iterator.next();
            if (configItem == null) continue;
            configItem.list(stringBuffer);
        }
        return stringBuffer.toString();
    }

    private void parseConfig() throws IOException, SAXException, ParserConfigurationException {
        Object object;
        Object object2;
        Object object3;
        this.mfItem = new ConfigItem();
        this.components = new LinkedList();
        this.probes = new LinkedList();
        this.elements = new LinkedList();
        String string = DeviceConfig.getConfigFileName(this.type);
        File file = new File(string);
        if (file.exists()) {
            object3 = new FileInputStream(string);
            object2 = null;
            object = SAXParserFactory.newInstance();
            ((SAXParserFactory)object).setValidating(false);
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            object2 = sAXParser.getXMLReader();
            object2.setContentHandler(new ConfigHandler());
            object2.setErrorHandler(new DebugErrorHandler());
            object2.parse(new InputSource((InputStream)object3));
        }
        object3 = new Properties();
        object2 = new File(DeviceConfig.getPropertyFileName(this.type));
        if (((File)object2).exists()) {
            object = new FileInputStream((File)object2);
            ((Properties)object3).load((InputStream)object);
            DeviceConfig.mergeProperties((Properties)object3, this.mfItem.getProps());
            this.mfItem.setProps((Properties)object3);
        }
    }

    private static void mergeProperties(Properties properties, Properties properties2) {
        if (properties2 == null) {
            return;
        }
        TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>(properties2);
        Set<Map.Entry<Object, Object>> set = treeMap.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            properties.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    static String getDeviceDirName() {
        String string = System.getProperty(PROPS_DIR);
        return string + File.separator + "device";
    }

    static String getConfigFileName(String string) {
        return DeviceConfig.getDeviceDirName() + File.separator + string + ".xml";
    }

    static String getPropertyFileName(String string) {
        return DeviceConfig.getDeviceDirName() + File.separator + string + ".properties";
    }

    public static String[] getDeviceTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = DeviceConfig.getDeviceDirName();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                int n2 = stringArray[n].indexOf(".xml");
                if (n2 > 0) {
                    String string2 = stringArray[n].substring(0, n2);
                    arrayList.add(string2);
                }
                ++n;
            }
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        return stringArray2;
    }

    public static void main(String[] stringArray) {
        try {
            System.setProperty(PROPS_DIR, stringArray[0]);
            DeviceConfig deviceConfig = new DeviceConfig(stringArray[1]);
            System.out.println(stringArray[0]);
            deviceConfig.parseConfig();
            System.out.println(deviceConfig.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class DebugErrorHandler
    implements ErrorHandler {
        private DebugErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            if (PackageUtil.logger.isLoggable(Level.WARNING)) {
                PackageUtil.logger.log(Level.WARNING, "Parse Error" + this.locate(sAXParseException), sAXParseException);
            }
        }

        public void warning(SAXParseException sAXParseException) {
            if (PackageUtil.logger.isLoggable(Level.WARNING)) {
                PackageUtil.logger.log(Level.WARNING, "Parse warning " + this.locate(sAXParseException), sAXParseException);
            }
        }

        public void fatalError(SAXParseException sAXParseException) {
            if (PackageUtil.logger.isLoggable(Level.WARNING)) {
                PackageUtil.logger.log(Level.WARNING, "Parse fatal Error " + this.locate(sAXParseException), sAXParseException);
            }
        }

        private String locate(SAXParseException sAXParseException) {
            return "(Line " + sAXParseException.getLineNumber() + " Char " + sAXParseException.getColumnNumber() + ")";
        }
    }

    private class ConfigHandler
    implements ContentHandler {
        public static final String CLASS = "class";
        public static final String COMPONENT = "Component";
        public static final String TYPE = "type";
        public static final String PROBE = "Probe";
        public static final String PROPERTIES = "properties";
        public static final String KEYVALUE = "keyvalue";
        public static final String KEY = "key";
        public static final String VALUE = "value";
        public static final String MF = "ManagementFacade";
        public static final String IDENTITY = "Identity";
        public static final String ELEMENT = "Element";
        public static final String ID = "ID";
        String currentElement;
        ConfigItem item;
        IdElement idElem;

        ConfigHandler() {
            this.item = DeviceConfig.this.mfItem;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (CLASS.equals(this.currentElement)) {
                this.item.setClassName(new String(cArray, n, n2).trim());
            }
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.currentElement = null;
        }

        public void endPrefixMapping(String string) {
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
        }

        public void processingInstruction(String string, String string2) {
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void skippedEntity(String string) {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.currentElement = string3;
            if (COMPONENT.equals(string3)) {
                this.item = new ConfigItem();
                this.item.setType(attributes.getValue(TYPE));
                DeviceConfig.this.components.add(this.item);
            } else if (PROBE.equals(string3)) {
                this.item = new ConfigItem();
                this.item.setType(attributes.getValue(TYPE));
                this.item.setAttribute("load", attributes.getValue("load"));
                DeviceConfig.this.probes.add(this.item);
            } else if (PROPERTIES.equals(string3)) {
                this.item.setProps(new Properties());
            } else if (KEYVALUE.equals(string3)) {
                this.item.getProps().setProperty(attributes.getValue(KEY), attributes.getValue(VALUE));
            } else if (MF.equals(string3)) {
                this.item.setType(attributes.getValue(TYPE));
            } else if (ELEMENT.equals(string3)) {
                this.idElem = new IdElement(attributes.getValue(CLASS));
                DeviceConfig.this.elements.add(this.idElem);
            } else if (ID.equals(string3)) {
                this.idElem.addID(attributes.getValue(TYPE), attributes.getValue(VALUE));
            }
        }

        public void startPrefixMapping(String string, String string2) {
        }
    }
}

