/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.array.api;

import com.sun.netstorage.mgmt.esm.common.array.StoragePermission;
import com.sun.netstorage.mgmt.esm.logic.array.api.Contract;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;

public class LunMasking
implements Serializable {
    private static final String SCCS_ID = "@(#)LunMasking.java 1.2   03/09/11 SMI";
    private final Identity myVolumeId;
    private final HashMap myMap = new HashMap();

    public LunMasking(Identity identity) {
        Contract.requires((identity != null ? 1 : 0) != 0, (String)"theVolumeId != null");
        this.myVolumeId = identity;
    }

    public final Identity getVolumeId() {
        return this.myVolumeId;
    }

    private Entry getEntry(Identity identity) {
        Entry entry = (Entry)this.myMap.get(identity);
        if (entry == null) {
            entry = new Entry();
            this.myMap.put(identity, entry);
        }
        return entry;
    }

    public final Identity[] getTargetIds() {
        Set set = this.myMap.keySet();
        int n = set.size();
        Identity[] identityArray = new Identity[n];
        identityArray = set.toArray(identityArray);
        return identityArray;
    }

    public final Identity[] getInitiatorIds(Identity identity) {
        Contract.requires((identity != null ? 1 : 0) != 0, (String)"theTargetId != null");
        Entry entry = this.getEntry(identity);
        Identity[] identityArray = entry.getInitiatorIds();
        return identityArray;
    }

    public final StoragePermission getPermission(Identity identity, Identity identity2) {
        Contract.requires((identity != null ? 1 : 0) != 0, (String)"theTargetId != null");
        Contract.requires((identity2 != null ? 1 : 0) != 0, (String)"theInitiatorId != null");
        Entry entry = this.getEntry(identity);
        StoragePermission storagePermission = entry.getPermission(identity2);
        if (storagePermission == null) {
            storagePermission = null;
        }
        Contract.requires((storagePermission != null ? 1 : 0) != 0, (String)"result != null");
        return storagePermission;
    }

    public final void setPermission(Identity identity, Identity identity2, StoragePermission storagePermission) {
        Contract.requires((identity != null ? 1 : 0) != 0, (String)"theTargetId != null");
        Contract.requires((identity2 != null ? 1 : 0) != 0, (String)"theInitiatorId != null");
        Entry entry = this.getEntry(identity);
        entry.setPermission(identity2, storagePermission);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Identity[] identityArray = this.getTargetIds();
        stringBuffer.append(this.getVolumeId().getValue());
        stringBuffer.append(" : ");
        int n = 0;
        while (n < identityArray.length) {
            Identity identity = identityArray[n];
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(identity.getValue());
            stringBuffer.append(" : ");
            stringBuffer.append(this.getEntry(identity));
            ++n;
        }
        return stringBuffer.toString();
    }

    private class Entry {
        private final HashMap myMap = new HashMap();

        Entry() {
        }

        public final Identity[] getInitiatorIds() {
            Set set = this.myMap.keySet();
            int n = set.size();
            Identity[] identityArray = new Identity[n];
            identityArray = set.toArray(identityArray);
            return identityArray;
        }

        public final StoragePermission getPermission(Identity identity) {
            Contract.requires((identity != null ? 1 : 0) != 0, (String)"theInitiatorId != null");
            StoragePermission storagePermission = null;
            if (identity != null) {
                storagePermission = (StoragePermission)this.myMap.get(identity);
            }
            if (storagePermission == null) {
                storagePermission = null;
            }
            Contract.requires((storagePermission != null ? 1 : 0) != 0, (String)"result != null");
            return storagePermission;
        }

        public final void setPermission(Identity identity, StoragePermission storagePermission) {
            Contract.requires((identity != null ? 1 : 0) != 0, (String)"theInitiatorId != null");
            Contract.requires((storagePermission != null ? 1 : 0) != 0, (String)"thePermission != null");
            this.myMap.put(identity, storagePermission);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            Identity[] identityArray = this.getInitiatorIds();
            int n = 0;
            while (n < identityArray.length) {
                Identity identity = identityArray[n];
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(identity.getValue());
                stringBuffer.append(" = ");
                stringBuffer.append(this.getPermission(identity));
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

