/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Search;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.StorADESearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.StorADEProbe;
import com.sun.netstorage.mgmt.fm.storade.client.StoradeClient;
import com.sun.netstorage.mgmt.fm.storade.client.StoradeDeviceSummary;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Properties;

public class StorADESearch
implements Search {
    private SearchResultImpl result;
    private StorADESearchConfig searchConfig;
    private StorADESearchRun job;
    public static final String sccs_id = "@(#)StorADESearch.java 1.7     03/11/07 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;

    public StorADESearch(StorADESearchConfig storADESearchConfig) {
        this.searchConfig = storADESearchConfig;
    }

    public SearchConfig getSearchConfig() {
        return this.searchConfig;
    }

    public SearchResult runSearch() {
        SearchResultImpl searchResultImpl = new SearchResultImpl(this.searchConfig);
        searchResultImpl.setStatus(1);
        this.result = searchResultImpl;
        this.job = new StorADESearchRun();
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)this.job);
        return searchResultImpl;
    }

    public void stopSearch() {
        this.job.abort();
    }

    public SearchResult getSearchResult() {
        return this.result;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class Test
    extends UnitTest {
        public static void main(String[] stringArray) {
            try {
                if (stringArray.length != 1) {
                    System.err.println("usage StorADESearch <host>");
                    System.exit(1);
                }
                StorADESearchConfig storADESearchConfig = new StorADESearchConfig();
                storADESearchConfig.setHost(stringArray[0]);
                storADESearchConfig.setPort(7654);
                storADESearchConfig.setTimeout(20);
                StorADESearch storADESearch = new StorADESearch(storADESearchConfig);
                SearchResultImpl searchResultImpl = (SearchResultImpl)storADESearch.runSearch();
                searchResultImpl.waitForComplete();
                String string = searchResultImpl.getErrorMsg();
                if (string == null) {
                    System.out.println("Search done");
                    Iterator iterator = searchResultImpl.getResults();
                    while (iterator.hasNext()) {
                        Properties properties = (Properties)iterator.next();
                        properties.list(System.out);
                    }
                } else {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
    }

    private class StorADESearchRun
    implements Runnable {
        private boolean stop;

        private StorADESearchRun() {
        }

        public void run() {
            try {
                StoradeClient storadeClient = new StoradeClient(StorADESearch.this.searchConfig.getHost());
                StoradeDeviceSummary[] storadeDeviceSummaryArray = storadeClient.getDeviceList();
                StorADEProbe storADEProbe = new StorADEProbe();
                int n = 0;
                while (n < storadeDeviceSummaryArray.length) {
                    Properties properties;
                    if (!this.isDiscovered(storadeDeviceSummaryArray[n]) && (properties = this.getProperties(storadeDeviceSummaryArray[n])) != null) {
                        ProbeResult probeResult = storADEProbe.probe(properties);
                        Iterator iterator = probeResult.getDevices().iterator();
                        while (iterator.hasNext()) {
                            Properties properties2 = (Properties)iterator.next();
                            this.installDevice(properties2);
                            StorADESearch.this.result.addElement(properties2);
                        }
                    }
                    if (this.stop) break;
                    StorADESearch.this.result.setPercentComplete(n * 100 / storadeDeviceSummaryArray.length);
                    ++n;
                }
                StorADESearch.this.result.setPercentComplete(100);
                StorADESearch.this.result.setComplete();
            }
            catch (Exception exception) {
                StorADESearch.this.result.setError(exception);
            }
        }

        private boolean isDiscovered(StoradeDeviceSummary storadeDeviceSummary) {
            DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
            if (deviceConfig != null && storadeDeviceSummary != null) {
                Properties properties = deviceConfig.findDevice("sa.key", storadeDeviceSummary.getKey());
                return properties != null;
            }
            return false;
        }

        private Properties getProperties(StoradeDeviceSummary storadeDeviceSummary) {
            try {
                Properties properties = new Properties();
                String string = StorADESearch.this.searchConfig.getHost();
                InetAddress inetAddress = InetAddress.getByName(string);
                properties.setProperty("sa.key", storadeDeviceSummary.getKey());
                properties.setProperty("sa.type", storadeDeviceSummary.getType());
                properties.setProperty("sa.name", storadeDeviceSummary.getName());
                properties.setProperty("sa.wwn", storadeDeviceSummary.getWWN());
                properties.setProperty("sa.ip", inetAddress.getHostName());
                properties.setProperty("sa.ipno", inetAddress.getHostAddress());
                properties.setProperty("sa.port", "" + StorADESearch.this.searchConfig.getPort());
                return properties;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public void abort() {
            this.stop = true;
        }

        private void installDevice(Properties properties) {
            try {
                FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = StorADESearch.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
                if (facadeFactory == null) {
                    Report.error.log((Object)"Error finding MF factory.");
                    return;
                }
                facadeFactory.discoverDevice(properties);
            }
            catch (Exception exception) {
                Report.error.log("error loading device.", (Object)exception);
            }
        }
    }
}

