/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.util.OID;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class SearchResultImpl
implements SearchResult {
    private String errorMsg;
    private int status;
    private int percent;
    private Date start;
    private Date end;
    private SearchConfig searchConfig;
    private String id;
    private List elements = new LinkedList();
    public static final String sccs_id = "@(#)SearchResultImpl.java\t1.5 11/24/03 SMI";

    public SearchResultImpl(SearchConfig searchConfig) {
        this.start = new Date();
        this.searchConfig = searchConfig;
        this.id = OID.getKey();
    }

    public synchronized void setFinished() {
        this.end = new Date();
        this.notifyAll();
    }

    public void setPercentComplete(int n) {
        this.percent = n;
    }

    public synchronized void addElement(Properties properties) {
        this.elements.add(properties);
    }

    public int getPercentComplete() {
        return this.percent;
    }

    public Date getStartTime() {
        return this.start;
    }

    public Date getCompletionTime() {
        return this.end;
    }

    public SearchConfig getSearchConfig() {
        return this.searchConfig;
    }

    public String getId() {
        return this.id;
    }

    public synchronized Iterator getResults() {
        return Collections.unmodifiableCollection(this.elements).iterator();
    }

    public LocalizedMessage getErrorMessage() {
        return new LocalizedString(this.errorMsg);
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String string) {
        this.errorMsg = string;
        this.setPercentComplete(100);
        this.setStatus(3);
        this.setFinished();
    }

    public void setError(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        this.setErrorMsg(stringWriter.toString());
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public void setComplete() {
        this.setPercentComplete(100);
        this.setStatus(2);
        this.setFinished();
    }

    public synchronized void waitForComplete() {
        while (this.status == 1) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

