/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.logic.mf.ServiceHelper;
import com.sun.jade.util.OID;
import com.sun.netstorage.mgmt.esm.logic.device.cim.CimomFacade;
import com.sun.netstorage.mgmt.esm.logic.device.cim.CimomFacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.device.cim.CimomServiceHelper;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SMISSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SMISClassProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SMISSearch;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import java.util.Iterator;
import java.util.Properties;

public class SMISSearchRun
implements Runnable {
    private SMISSearchConfig config;
    private SearchResultImpl searchResult;
    private boolean stop;
    private static long count = 0L;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;

    public SMISSearchRun(SearchResultImpl searchResultImpl) {
        this.searchResult = searchResultImpl;
        this.config = (SMISSearchConfig)this.searchResult.getSearchConfig();
    }

    public void run() {
        try {
            this.discoverCimoms();
        }
        catch (Exception exception) {
            this.searchResult.setError(exception);
            PACKAGE.ERROR("SMIS discovery error.", exception);
        }
        catch (Throwable throwable) {
            this.searchResult.setError(new RuntimeException(throwable));
            PACKAGE.ERROR("SMIS discovery error.", throwable);
        }
    }

    public void abort() {
        this.stop = true;
    }

    private void discoverCimoms() {
        PACKAGE.DEBUG("ENTER: SMISSearchRun.discoverCimoms()");
        CimomFacadeFactory cimomFacadeFactory = CimomFacadeFactory.getInstance();
        if (count++ == 0L) {
            cimomFacadeFactory.load();
        }
        cimomFacadeFactory.search();
        CimomFacade[] cimomFacadeArray = cimomFacadeFactory.getCimomFacades();
        int n = 0;
        while (cimomFacadeArray != null && n < cimomFacadeArray.length) {
            CimomFacade cimomFacade = cimomFacadeArray[n];
            String string = cimomFacade.getKey();
            PACKAGE.DEBUG("INFO: SMISSearchRun.discoverCimoms() -- found: " + string);
            this.discoverDevices(cimomFacade);
            this.searchResult.setPercentComplete(n * 100 / cimomFacadeArray.length);
            if (this.stop) break;
            ++n;
        }
        this.searchResult.setPercentComplete(100);
        this.searchResult.setComplete();
    }

    private void discoverDevices(CimomFacade cimomFacade) {
        PACKAGE.DEBUG("ENTER: SMISSearchRun.discoverDevices()");
        if (cimomFacade != null) {
            Properties[] propertiesArray = cimomFacade.discover();
            SMISClassProbe sMISClassProbe = new SMISClassProbe();
            int n = 0;
            while (propertiesArray != null && n < propertiesArray.length) {
                ProbeResult probeResult = sMISClassProbe.probe(propertiesArray[n]);
                Iterator iterator = probeResult.getDevices().iterator();
                while (iterator.hasNext()) {
                    Properties properties = (Properties)iterator.next();
                    PACKAGE.DEBUG("INFO: SMISSearchRun.discoverDevices() -- found: " + properties);
                    if (this.checkProperties(properties)) {
                        this.installDevice(properties);
                        this.searchResult.addElement(properties);
                    }
                    if (this.stop) break;
                }
                if (this.stop) break;
                ++n;
            }
        }
    }

    private boolean checkProperties(Properties properties) {
        String string;
        String string2 = properties.getProperty("type");
        if (string2 == null || string2.equals("")) {
            return false;
        }
        if (null == properties.getProperty("OID")) {
            properties.setProperty("OID", OID.getKey());
        }
        if ((string = properties.getProperty("search.oob")) == null || string.equals("")) {
            properties.setProperty("search.oob", "" + System.currentTimeMillis());
        }
        properties.setProperty("active", "Y");
        return true;
    }

    private void installDevice(Properties properties) {
        block5: {
            try {
                ServiceHelper[] serviceHelperArray;
                FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = SMISSearchRun.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
                if (facadeFactory == null) {
                    PACKAGE.ERROR("Error finding MF factory. Unable to create MF for " + properties.toString());
                    return;
                }
                MF mF = facadeFactory.discoverDevice(properties);
                if (mF == null || (serviceHelperArray = mF.getServiceHelpers()) == null) break block5;
                int n = 0;
                while (n < serviceHelperArray.length) {
                    ServiceHelper serviceHelper = serviceHelperArray[n];
                    if (serviceHelper instanceof CimomServiceHelper) {
                        CimomServiceHelper cimomServiceHelper = (CimomServiceHelper)serviceHelper;
                        cimomServiceHelper.cimomDiscoveryOccurred();
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                PACKAGE.ERROR("error loading device.", exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        SMISSearchConfig sMISSearchConfig = new SMISSearchConfig();
        SMISSearch sMISSearch = new SMISSearch(sMISSearchConfig);
        SearchResult searchResult = sMISSearch.runSearch();
        System.out.println("SearchResult: " + searchResult);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

