/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SMISSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Search;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SMISSearchRun;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import java.util.Iterator;
import java.util.Properties;

public class SMISSearch
implements Search {
    private SearchResultImpl result;
    private SMISSearchConfig searchConfig;
    private SMISSearchRun job;
    public static final String sccs_id = "";

    public SMISSearch(SMISSearchConfig sMISSearchConfig) {
        this.searchConfig = sMISSearchConfig;
    }

    public SearchConfig getSearchConfig() {
        return this.searchConfig;
    }

    public SearchResult getSearchResult() {
        return this.result;
    }

    public SearchResult runSearch() {
        SearchResultImpl searchResultImpl = new SearchResultImpl(this.searchConfig);
        searchResultImpl.setStatus(1);
        this.result = searchResultImpl;
        this.job = new SMISSearchRun(searchResultImpl);
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)this.job);
        return searchResultImpl;
    }

    public void stopSearch() {
        this.job.abort();
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            SMISSearch sMISSearch = new SMISSearch(new SMISSearchConfig());
        }

        public static void main(String[] stringArray) {
            try {
                if (stringArray.length != 1) {
                    System.err.println("usage SMISSearch <agent>");
                    System.exit(1);
                }
                SMISSearchConfig sMISSearchConfig = new SMISSearchConfig();
                SMISSearch sMISSearch = new SMISSearch(sMISSearchConfig);
                SearchResultImpl searchResultImpl = (SearchResultImpl)sMISSearch.runSearch();
                searchResultImpl.waitForComplete();
                String string = searchResultImpl.getErrorMsg();
                if (string == null) {
                    System.out.println("Search done");
                    Iterator iterator = searchResultImpl.getResults();
                    while (iterator.hasNext()) {
                        Properties properties = (Properties)iterator.next();
                        properties.list(System.out);
                    }
                } else {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
    }
}

