/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.util.OID;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.IPSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DiscoveryStatusEvent;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.IPProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.ProbeLoader;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SNMPProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import com.sun.netstorage.mgmt.esm.util.system.Configuration;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Iterator;
import java.util.Properties;

class IPSearchRun
implements Runnable {
    private boolean stop;
    private static final int MAX_THREADS = 10;
    private int numThreads = 0;
    private int numSearch = 0;
    private int numProbed = 0;
    private int timeout;
    private BigInteger startInt;
    private BigInteger endInt;
    private String slaveIP;
    private IPProbe ipProbe;
    private Properties properties;
    private IPSearchConfig config;
    private SearchResultImpl sr;
    private int numFound;
    public static final String sccs_id = "@(#)IPSearchRun.java\t1.25 03/26/04 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;

    IPSearchRun(SearchResultImpl searchResultImpl) {
        this.sr = searchResultImpl;
        this.config = (IPSearchConfig)searchResultImpl.getSearchConfig();
    }

    public void run() {
        if (!this.parseInput()) {
            return;
        }
        this.init();
        this.doDiscovery();
    }

    public void abort() {
        this.stop = true;
    }

    private boolean parseInput() {
        try {
            BigInteger bigInteger;
            this.slaveIP = this.config.getSlaveIP();
            String string = this.config.getIpStart();
            String string2 = this.config.getIpEnd();
            if (string2 == null || "".equals(string2)) {
                string2 = string;
            }
            InetAddress inetAddress = InetAddress.getByName(string);
            InetAddress inetAddress2 = InetAddress.getByName(string2);
            byte[] byArray = inetAddress.getAddress();
            byte[] byArray2 = inetAddress2.getAddress();
            this.startInt = new BigInteger(1, byArray);
            this.endInt = new BigInteger(1, byArray2);
            if (this.startInt.compareTo(this.endInt) > 0) {
                bigInteger = this.startInt;
                this.startInt = this.endInt;
                this.endInt = bigInteger;
            }
            bigInteger = this.endInt.subtract(this.startInt);
            this.numSearch = bigInteger.intValue() + 1;
            this.timeout = this.config.getTimeout();
            if (this.timeout <= 0) {
                this.timeout = 10;
            }
        }
        catch (Exception exception) {
            Report.error.log("Error validating input.", (Object)exception);
            DiscoveryStatusEvent.postFailedStatus("OOB", this.getSubject(), new LocalizedString(exception));
            this.sr.setErrorMsg("invalid_input");
            return false;
        }
        return true;
    }

    private String getSubject() {
        if (this.config == null) {
            return "?";
        }
        return this.config.getIpStart() + "/" + this.config.getIpEnd();
    }

    private void doRemoteDiscovery() {
        DiscoveryService discoveryService = null;
        System.out.println("doRemoteDiscovery");
        try {
            this.config.setSlaveIP(null);
            Registry registry = LocateRegistry.getRegistry("localhost", Configuration.getRMIRegistryPort());
            discoveryService = (DiscoveryService)registry.lookup((class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService == null ? (class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService = IPSearchRun.class$("com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService")) : class$com$sun$netstorage$mgmt$esm$logic$discovery$api$DiscoveryService).getPackage().getName());
            discoveryService.runSearch(this.config);
        }
        catch (Exception exception) {
            Report.error.log("Error getting discovery.", (Object)exception);
            return;
        }
    }

    private void doDiscovery() {
        if (this.slaveIP != null && !"localhost".equals(this.slaveIP)) {
            this.doRemoteDiscovery();
            return;
        }
        byte[] byArray = new byte[4];
        ThreadPool threadPool = ThreadPool.getThreadPool();
        BigInteger bigInteger = this.startInt;
        while (bigInteger.compareTo(this.endInt) < 1) {
            if (this.stop) break;
            byte[] byArray2 = bigInteger.toByteArray();
            int n = byArray2.length - 1;
            int n2 = 3;
            while (n >= 0 && n2 >= 0) {
                byArray[n2] = byArray2[n];
                --n;
                --n2;
            }
            try {
                InetAddress inetAddress = InetAddress.getByAddress(byArray);
                if (!this.isDiscovered(inetAddress.getHostAddress())) {
                    Properties properties = new Properties();
                    properties.setProperty("ip", inetAddress.getHostAddress());
                    properties.setProperty("timeout", "" + this.timeout);
                    SingleIPJob singleIPJob = new SingleIPJob(properties);
                    threadPool.runJob((Runnable)singleIPJob);
                    this.incrementNumThreads();
                    this.waitForThreads();
                } else {
                    ++this.numProbed;
                    this.sr.setPercentComplete(this.numProbed * 100 / this.numSearch);
                }
            }
            catch (UnknownHostException unknownHostException) {
                Report.error.log("Unknown host", (Object)unknownHostException);
            }
            bigInteger = bigInteger.add(BigInteger.ONE);
        }
        this.waitForFinish();
        DiscoveryStatusEvent.postStatus("OOB", this.getSubject(), this.numFound);
    }

    private synchronized int getNumThreads() {
        return this.numThreads;
    }

    private synchronized void incrementNumThreads() {
        this.numThreads = this.getNumThreads() + 1;
    }

    private synchronized void decrementNumThreads() {
        this.numThreads = this.getNumThreads() - 1;
    }

    private synchronized void waitForFinish() {
        while (this.getNumThreads() > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.sr.setComplete();
    }

    private synchronized void waitForThreads() {
        while (this.getNumThreads() >= 10) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void completeSingleProbe(ProbeResult probeResult) {
        Iterator iterator = probeResult.getDevices().iterator();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            if (!this.checkProperties(properties)) continue;
            this.installDevice(properties);
            this.sr.addElement(properties);
        }
        ++this.numProbed;
        this.decrementNumThreads();
        this.sr.setPercentComplete(this.numProbed * 100 / this.numSearch);
        this.notify();
    }

    private boolean isDiscovered(String string) {
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        if (deviceConfig != null && string != null) {
            Properties properties = deviceConfig.findDevice("ipno", string);
            return properties != null;
        }
        return false;
    }

    private boolean checkProperties(Properties properties) {
        String string;
        String string2;
        String string3 = properties.getProperty("type");
        if (string3 == null || string3.equals("")) {
            return false;
        }
        if (null == properties.getProperty("OID")) {
            properties.setProperty("OID", OID.getKey());
        }
        if ((string2 = properties.getProperty("search.oob")) == null || string2.equals("")) {
            properties.setProperty("search.oob", "" + System.currentTimeMillis());
        }
        if ((string = properties.getProperty("logicalName")) == null || string.equals("")) {
            properties.setProperty("logicalName", properties.getProperty("ip"));
        }
        properties.setProperty("active", "Y");
        return true;
    }

    private void installDevice(Properties properties) {
        try {
            FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = IPSearchRun.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
            if (facadeFactory == null) {
                Report.error.log((Object)"Error finding MF factory.");
                return;
            }
            facadeFactory.discoverDevice(properties);
        }
        catch (Exception exception) {
            Report.error.log("error loading device.", (Object)exception);
        }
        ++this.numFound;
    }

    private void init() {
        this.ipProbe = new IPProbe();
        this.ipProbe.addSubProbe(new SNMPProbe(), this.ipProbe.getName(), "ANY");
        ProbeLoader probeLoader = new ProbeLoader(this.ipProbe);
        probeLoader.loadProbes();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SingleIPJob
    implements Runnable {
        private Properties p;

        SingleIPJob(Properties properties) {
            this.p = properties;
        }

        public void run() {
            ProbeResult probeResult = IPSearchRun.this.ipProbe.probe(this.p);
            IPSearchRun.this.completeSingleProbe(probeResult);
        }
    }
}

