/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.ProbeRootImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Properties;

public class IPProbe
extends ProbeRootImpl {
    public static final String PROBE_NAME = "IP";
    public static final String IP_TIMEOUT = "timeout";
    public static final String IP_ALIVE = "alive";
    public static final String IS_ALIVE = "Y";
    public static final String NO_RESPONSE = "N";
    private static final String PING = "/usr/sbin/ping";
    public static final String sccs_id = "@(#)IPProbe.java\t1.8 05/12/03 SMI";

    public IPProbe() {
        super(PROBE_NAME);
    }

    public ProbeResult probe(Properties properties) {
        String string = NO_RESPONSE;
        String string2 = properties.getProperty("ip");
        if (string2 == null) {
            return new ProbeResult(properties, new LinkedList());
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string2);
            string = this.doPing(inetAddress.getHostAddress(), properties.getProperty(IP_TIMEOUT));
            properties.setProperty(IP_ALIVE, string);
        }
        catch (UnknownHostException unknownHostException) {
            new ProbeResult(properties, new LinkedList());
        }
        if (inetAddress != null) {
            properties.setProperty("ip", inetAddress.getHostName());
            properties.setProperty("ipno", inetAddress.getHostAddress());
        }
        if (IS_ALIVE.equals(string)) {
            return super.probe(properties);
        }
        return new ProbeResult(properties, new LinkedList());
    }

    private String doPing(String string, String string2) {
        try {
            String string3 = "/usr/sbin/ping " + string + " " + string2;
            CommandExec commandExec = new CommandExec(string3);
            commandExec.exec();
            int n = commandExec.getReturnValue();
            if (n == 0) {
                return IS_ALIVE;
            }
        }
        catch (IOException iOException) {}
        return NO_RESPONSE;
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            IPProbe iPProbe = new IPProbe();
            Properties properties = new Properties();
            properties.setProperty("ip", "localhost");
            this.assertNotNull(iPProbe.probe(properties));
        }
    }
}

