/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.apps.topology.FabricSummary;
import com.sun.jade.apps.topology.TopologyService;
import com.sun.jade.util.OID;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.FabricSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.FabricProbe;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceFlavor;
import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolver;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.TypeResolutionException;
import com.sun.netstorage.mgmt.esm.logic.identity.api.TypeResolver;
import com.sun.netstorage.mgmt.esm.logic.registry.api.RMIRegistryFacility;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

class FabricSearchRun
implements Runnable {
    private TopologyService topologyService;
    private FabricProbe fabricProbe;
    protected static IdentityResolver idResolver;
    private FabricSearchConfig config;
    private SearchResultImpl sr;
    private boolean stop;
    public static final String sccs_id = "@(#)FabricSearchRun.java\t1.2 10/20/03 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver;

    FabricSearchRun(SearchResultImpl searchResultImpl) {
        this.sr = searchResultImpl;
        this.config = (FabricSearchConfig)searchResultImpl.getSearchConfig();
    }

    public void run() {
        this.init();
        this.doDiscovery();
    }

    public void abort() {
        this.stop = true;
    }

    private void init() {
        this.fabricProbe = new FabricProbe();
    }

    private void doDiscovery() {
        ArrayList arrayList = new ArrayList();
        try {
            FabricSummary[] fabricSummaryArray = this.getTopologyService().getFabrics();
            PACKAGE.DEBUG("Fabric Search. # of fabrics = " + fabricSummaryArray.length);
            int n = 0;
            while (n < fabricSummaryArray.length) {
                PACKAGE.DEBUG("Fabric Search. Fabric info:\n\n    Display Name = " + fabricSummaryArray[n].getDisplayName() + "\n    IP Name = " + fabricSummaryArray[n].getIPName() + "\n    Identity = " + fabricSummaryArray[n].getIdentity());
                Identity[] identityArray = this.getTopologyService().getDevicesInFabric(fabricSummaryArray[n].getIdentity());
                PACKAGE.DEBUG("Fabric Search. # of devices found = " + identityArray.length);
                int n2 = 0;
                while (n2 < identityArray.length) {
                    try {
                        ElementType elementType = TypeResolver.getType((Identity)identityArray[n2]);
                        DeviceFlavor deviceFlavor = (DeviceFlavor)elementType.getFlavor();
                        if (deviceFlavor.equals((Object)DeviceFlavor.SWITCH)) {
                            Identity identity = FabricSearchRun.getIDResolver().getAlternateIdentifier(identityArray[n2], IdentityType.IPV4);
                            PACKAGE.DEBUG("Fabric Search. Found a switch:\n\n    Vendor = " + elementType.getVendor() + "\n    Model = " + elementType.getModel() + "\n    ID = " + identity);
                            this.probeFabric(identity);
                        }
                    }
                    catch (TypeResolutionException typeResolutionException) {
                        PACKAGE.ERROR("Fabric Search Problem", typeResolutionException);
                        this.sr.setErrorMsg(typeResolutionException.toString());
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            PACKAGE.ERROR("Fabric Search Failed", exception);
            this.sr.setErrorMsg(exception.toString());
            return;
        }
        this.sr.setComplete();
    }

    private void probeFabric(Identity identity) {
        Properties properties = new Properties();
        this.setProperty(properties, "snmp.ip", identity.getValue());
        this.setProperty(properties, "deep", "true");
        this.setProperty(properties, "timeout", "1000");
        ProbeResult probeResult = this.fabricProbe.probe(properties);
        PACKAGE.DEBUG("Probe Fabric. result:\n\n" + probeResult);
        Iterator iterator = probeResult.getDevices().iterator();
        while (iterator.hasNext()) {
            Properties properties2 = (Properties)iterator.next();
            if (!this.checkProperties(properties2)) continue;
            PACKAGE.DEBUG("Probe Fabric. Installing:\n    " + properties2);
            this.installDevice(properties2);
            this.sr.addElement(properties2);
        }
    }

    private void setProperty(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    private boolean checkProperties(Properties properties) {
        String string;
        String string2 = properties.getProperty("type");
        if (string2 == null || string2.equals("")) {
            return false;
        }
        if (null == properties.getProperty("OID")) {
            properties.setProperty("OID", OID.getKey());
        }
        if ((string = properties.getProperty("search.ib")) == null || string.equals("")) {
            properties.setProperty("search.ib", "" + System.currentTimeMillis());
        }
        properties.setProperty("active", "Y");
        return true;
    }

    private void installDevice(Properties properties) {
        try {
            FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = FabricSearchRun.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
            if (facadeFactory == null) {
                PACKAGE.ERROR("Error finding MF factory.");
                return;
            }
            facadeFactory.discoverDevice(properties);
        }
        catch (Exception exception) {
            PACKAGE.ERROR("error loading device.", exception);
        }
    }

    private TopologyService getTopologyService() throws NotBoundException, RemoteException {
        if (this.topologyService == null) {
            this.topologyService = (TopologyService)RMIRegistryFacility.Singleton.get().lookup("com.sun.jade.apps.topology");
        }
        return this.topologyService;
    }

    protected static IdentityResolver getIDResolver() throws RemoteException, NotBoundException {
        if (idResolver == null) {
            idResolver = (IdentityResolver)RMIRegistryFacility.Singleton.get().lookup((class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver == null ? (class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver = FabricSearchRun.class$("com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolver")) : class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver).getPackage().getName());
        }
        return idResolver;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Test
    extends UnitTest {
        public void test() throws Exception {
            SearchResultImpl searchResultImpl = new SearchResultImpl(new FabricSearchConfig());
            FabricSearchRun fabricSearchRun = new FabricSearchRun(searchResultImpl);
        }
    }
}

