/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DeviceDetail;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SMISSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Search;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.StorADESearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DeviceDetailImpl;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DiscoveryScheduler;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class DiscoveryServiceImpl
implements DiscoveryService {
    private DiscoveryScheduler scheduler;
    private Properties discoProps;
    private int purgeMin = 90;
    private LinkedList configs = new LinkedList();
    private LinkedList searches = new LinkedList();
    private Object searches_lock = new Object();
    public static final String sccs_id = "@(#)DiscoveryServiceImpl.java\t1.27 03/25/04 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;

    public DiscoveryServiceImpl(Properties properties) {
        Object object;
        this.discoProps = properties;
        try {
            object = properties.getProperty("purgeMin");
            if (object != null) {
                this.purgeMin = Integer.parseInt((String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new StorADESearchConfig();
        ((StorADESearchConfig)object).setHost("localhost");
        this.configs.add(object);
        SMISSearchConfig sMISSearchConfig = new SMISSearchConfig();
        this.configs.add(sMISSearchConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult runSearch(SearchConfig searchConfig) {
        Search search = searchConfig.newSearch();
        SearchResult searchResult = search.runSearch();
        Object object = this.searches_lock;
        synchronized (object) {
            this.searches.add(search);
        }
        return searchResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSearch(String string) {
        Object object = this.searches_lock;
        synchronized (object) {
            Iterator iterator = this.searches.iterator();
            while (iterator.hasNext()) {
                Search search = (Search)iterator.next();
                SearchResult searchResult = search.getSearchResult();
                if (!string.equals(searchResult.getId())) continue;
                search.stopSearch();
                this.searches.remove(search);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult[] getRunningSearches() {
        SearchResult[] searchResultArray;
        this.purgeSearches(this.purgeMin);
        LinkedList<SearchResult> linkedList = new LinkedList<SearchResult>();
        Object object = this.searches_lock;
        synchronized (object) {
            searchResultArray = this.searches.iterator();
            while (searchResultArray.hasNext()) {
                Search search = (Search)searchResultArray.next();
                SearchResult searchResult = search.getSearchResult();
                linkedList.add(searchResult);
            }
        }
        searchResultArray = new SearchResult[linkedList.size()];
        linkedList.toArray(searchResultArray);
        return searchResultArray;
    }

    public SearchConfig[] getConfiguredSearches() {
        this.purgeSearches(this.purgeMin);
        SearchConfig[] searchConfigArray = new SearchConfig[this.configs.size()];
        this.configs.toArray(searchConfigArray);
        return searchConfigArray;
    }

    public synchronized void addSearch(SearchConfig searchConfig) {
        this.configs.add(searchConfig);
        if (StoradeEnvironment.getState() == 1) {
            this.runSearch(searchConfig);
        }
    }

    public synchronized void removeSearch(SearchConfig searchConfig) {
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            SearchConfig searchConfig2 = (SearchConfig)iterator.next();
            if (!searchConfig.equals(searchConfig2)) continue;
            this.configs.remove(searchConfig2);
            return;
        }
    }

    public DeviceDetail[] getDiscoveredDevices(int n) throws RemoteException {
        Object object;
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        Collection collection = deviceConfig.getConfigProperties();
        Iterator iterator = collection.iterator();
        LinkedList<DeviceDetailImpl> linkedList = new LinkedList<DeviceDetailImpl>();
        block7: while (iterator.hasNext()) {
            object = (Properties)iterator.next();
            String string = ((Properties)object).getProperty("search.oob");
            String string2 = ((Properties)object).getProperty("search.ib");
            switch (n) {
                case 2: {
                    if (string == null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 3: {
                    if (string == null || string2 != null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 4: {
                    if (string2 == null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 5: {
                    if (string2 == null || string != null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 6: {
                    if (string2 == null || string == null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                default: {
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                }
            }
        }
        object = new DeviceDetail[linkedList.size()];
        linkedList.toArray((T[])object);
        return object;
    }

    public void setDeviceMonitoring(String string, boolean bl) {
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        Collection collection = deviceConfig.getConfigProperties();
        Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty("OID");
            if (!string.equals(string2)) continue;
            properties.setProperty("active", bl ? "Y" : "N");
            deviceConfig.store();
            try {
                FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = DiscoveryServiceImpl.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
                if (facadeFactory == null) {
                    PACKAGE.ERROR("Error finding MF factory.");
                    return;
                }
                if (bl) {
                    facadeFactory.installDevice(properties);
                } else {
                    facadeFactory.shutdownDevice(properties);
                }
            }
            catch (Exception exception) {
                PACKAGE.ERROR("Error setting device active flag.");
                return;
            }
            return;
        }
    }

    public void bootStart(int n) throws RemoteException {
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)new BootStarter(this, n));
    }

    public void removeUnmonitoredDevices() throws RemoteException {
        Object object;
        Object object2;
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        Collection collection = deviceConfig.getConfigProperties();
        Iterator iterator = collection.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iterator.hasNext()) {
            object2 = (Properties)iterator.next();
            object = ((Properties)object2).getProperty("active");
            if ("Y".equals(object)) continue;
            arrayList.add(object2);
        }
        object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (Properties)object2.next();
            deviceConfig.removeDevice((Properties)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeSearches(int n) {
        LinkedList<Search> linkedList = new LinkedList<Search>();
        Object object = this.searches_lock;
        synchronized (object) {
            Iterator iterator = this.searches.iterator();
            while (iterator.hasNext()) {
                long l;
                long l2;
                Date date;
                Search search = (Search)iterator.next();
                SearchResult searchResult = search.getSearchResult();
                if (searchResult.getStatus() == 1) {
                    linkedList.add(search);
                    continue;
                }
                if (n <= 0 || (date = searchResult.getCompletionTime()) == null || (l2 = System.currentTimeMillis()) >= (l = date.getTime() + (long)(n * 60000))) continue;
                linkedList.add(search);
            }
            this.searches = linkedList;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BootStarter
    implements Runnable {
        DiscoveryServiceImpl ds;
        int interval = 1;

        BootStarter(DiscoveryServiceImpl discoveryServiceImpl2, int n) {
            this.interval = n;
            this.ds = discoveryServiceImpl2;
        }

        public void run() {
            DiscoveryServiceImpl.this.scheduler = new DiscoveryScheduler(this.ds, this.interval);
        }
    }
}

