/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.util.log.Report;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DiscoveryServiceImpl;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import java.util.Timer;
import java.util.TimerTask;

public class DiscoveryScheduler {
    static final int MILLISECONDS_IN_MINUTE = 60000;
    private Timer timer;
    private PollingTask polling;
    private int pollInterval = 86400000;
    private int delayInterval = 0;
    private int interval;
    private DiscoveryServiceImpl disco;
    public static final String sccs_id = "@(#)DiscoveryScheduler.java\t1.6 03/25/04 SMI";

    DiscoveryScheduler(DiscoveryServiceImpl discoveryServiceImpl, int n) {
        this.disco = discoveryServiceImpl;
        this.interval = n;
        this.startPolling();
    }

    public void startPolling() {
        if (this.timer == null) {
            this.timer = new Timer(true);
            this.polling = new PollingTask();
            this.polling.run();
            this.pollInterval = this.interval * 60000 * 60;
            Report.info.log((Object)("Discovery polling interval is " + this.interval));
            this.timer.schedule((TimerTask)this.polling, this.delayInterval, (long)this.pollInterval);
        }
    }

    private class PollingTask
    extends TimerTask {
        private PollingTask() {
        }

        public void run() {
            SearchConfig[] searchConfigArray = DiscoveryScheduler.this.disco.getConfiguredSearches();
            if (searchConfigArray != null) {
                int n = 0;
                while (n < searchConfigArray.length) {
                    try {
                        SearchConfig searchConfig = searchConfigArray[n];
                        DiscoveryScheduler.this.disco.removeUnmonitoredDevices();
                        DiscoveryScheduler.this.disco.runSearch(searchConfig);
                    }
                    catch (Throwable throwable) {
                        PACKAGE.ERROR("Error running interval search", throwable);
                    }
                    ++n;
                }
            }
        }
    }
}

