/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.AgentSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Search;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.AgentSearchRun;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SearchResultImpl;
import java.util.Iterator;
import java.util.Properties;

public class AgentSearch
implements Search {
    private SearchResultImpl result;
    private AgentSearchConfig searchConfig;
    private AgentSearchRun job;
    public static final String sccs_id = "@(#)AgentSearch.java\t1.3 05/02/03 SMI";

    public AgentSearch(AgentSearchConfig agentSearchConfig) {
        this.searchConfig = agentSearchConfig;
    }

    public SearchConfig getSearchConfig() {
        return this.searchConfig;
    }

    public SearchResult runSearch() {
        SearchResultImpl searchResultImpl = new SearchResultImpl(this.searchConfig);
        searchResultImpl.setStatus(1);
        this.result = searchResultImpl;
        this.job = new AgentSearchRun(searchResultImpl);
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)this.job);
        return searchResultImpl;
    }

    public void stopSearch() {
        this.job.abort();
    }

    public SearchResult getSearchResult() {
        return this.result;
    }

    public static class Test
    extends UnitTest {
        public void test() throws Exception {
            AgentSearch agentSearch = new AgentSearch(new AgentSearchConfig());
        }

        public static void main(String[] stringArray) {
            try {
                if (stringArray.length != 1) {
                    System.err.println("usage AgentSearch <agent>");
                    System.exit(1);
                }
                AgentSearchConfig agentSearchConfig = new AgentSearchConfig();
                agentSearchConfig.setHost(stringArray[0]);
                AgentSearch agentSearch = new AgentSearch(agentSearchConfig);
                SearchResultImpl searchResultImpl = (SearchResultImpl)agentSearch.runSearch();
                searchResultImpl.waitForComplete();
                String string = searchResultImpl.getErrorMsg();
                if (string == null) {
                    System.out.println("Search done");
                    Iterator iterator = searchResultImpl.getResults();
                    while (iterator.hasNext()) {
                        Properties properties = (Properties)iterator.next();
                        properties.list(System.out);
                    }
                } else {
                    System.out.println(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.exit(0);
        }
    }
}

