/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.zones;

import com.sun.jade.device.util.DeviceClass;

public class ZoneHelperMergeForMarcy {
    private String wwn;
    private String zoneSetName;
    private String zoneName;
    private int noOfZonesSet;
    private int noOfZones;
    private int noOfZoneMembers;
    public static final String sccs_id = "@(#)ZoneHelperMergeForMarcy.java 1.3     03/09/26 SMI";

    public ZoneHelperMergeForMarcy() {
        this.init();
    }

    private DeviceClass populateZones() {
        DeviceClass deviceClass = new DeviceClass("Zone");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("REF", this.zoneName);
        deviceClass.setProperty("Name", this.zoneName);
        deviceClass.setProperty("ElementName", this.zoneName);
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("OtherZoneTypeDescription", "Soft - WWN");
        deviceClass.setProperty("Active", "true");
        deviceClass.setProperty("ProtocolType", "1");
        return deviceClass;
    }

    private DeviceClass populateZoneMembers(String[] stringArray) {
        DeviceClass deviceClass = null;
        if (stringArray.length > 0) {
            deviceClass = new DeviceClass("ZoneMember");
            deviceClass.setProperty("ZoneMemberType", "5");
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("Collection");
            deviceClass2.setProperty("REF", this.zoneName);
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (string != null) {
                    DeviceClass deviceClass3 = deviceClass.newSubInstance();
                    deviceClass3.setClassName("Member");
                    if (string.length() == 16) {
                        deviceClass3.setProperty("CreationClassName", "CIM_ProtocolEndpoint");
                        deviceClass3.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
                        deviceClass3.setProperty("SystemName", this.wwn);
                        deviceClass3.setProperty("Name", string);
                        deviceClass3.setProperty("NameFormat", "WWN");
                        deviceClass3.setProperty("ProtocolType", "Fibre Channel");
                        deviceClass3.setAlias("ProtocolEndPoint");
                    } else {
                        deviceClass3.setProperty("REF", string);
                    }
                }
                ++n;
            }
        }
        return deviceClass;
    }

    private DeviceClass populateZoneSet() {
        DeviceClass deviceClass = new DeviceClass("ZoneSet");
        deviceClass.setProperty("SystemName", this.wwn);
        deviceClass.setProperty("REF", this.zoneSetName);
        deviceClass.setProperty("Name", this.zoneSetName);
        deviceClass.setProperty("ElementName", this.zoneSetName);
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Active", "true");
        return deviceClass;
    }

    public void updateDeviceReport(DeviceClass deviceClass) {
    }

    public void init() {
        this.noOfZonesSet = 1;
        this.wwn = "10000000c0dd02";
        this.zoneSetName = "MARCY_ZONE_SET";
        DeviceClass deviceClass = null;
        int n = 0;
        while (n < this.noOfZonesSet) {
            deviceClass = this.populateZoneSet();
            this.updateDeviceReport(deviceClass);
            ++n;
        }
        this.noOfZones = 1;
        this.zoneName = "MARCY_ZONE";
        int n2 = 0;
        while (n2 < this.noOfZones) {
            deviceClass = this.populateZones();
            this.updateDeviceReport(deviceClass);
            ++n2;
        }
        this.noOfZoneMembers = 2;
        String[] stringArray = new String[]{"1", "2"};
        int n3 = 0;
        while (n3 < this.noOfZoneMembers) {
            deviceClass = this.populateZoneMembers(stringArray);
            this.updateDeviceReport(deviceClass);
            ++n3;
        }
        DeviceClass deviceClass2 = null;
        DeviceClass deviceClass3 = null;
        DeviceClass deviceClass4 = null;
        int n4 = 0;
        while (n4 < this.noOfZonesSet) {
            deviceClass2 = this.populateZoneSet();
            int n5 = 0;
            while (n5 < this.noOfZones) {
                deviceClass3 = this.populateZones();
                int n6 = 0;
                while (n6 < this.noOfZoneMembers) {
                    deviceClass4 = this.populateZoneMembers(stringArray);
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        this.updateDeviceReport(deviceClass2);
        this.updateDeviceReport(deviceClass3);
        this.updateDeviceReport(deviceClass4);
    }
}

