/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.device.fcswitch.util.snmp.FCMGMT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.MibRepository;
import com.sun.jade.device.fcswitch.util.snmp.SNMPHexValueHandler;
import com.sun.jade.device.fcswitch.util.snmp.SystemUpTimeParser;
import com.sun.jade.device.protocol.snmp.RFC1213_MIBOidTable;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.jdmk.snmp.SnmpOidTableSupport;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import javax.management.snmp.SnmpOid;
import javax.management.snmp.SnmpOidRecord;
import javax.management.snmp.SnmpOidTable;
import javax.management.snmp.SnmpStatusException;
import javax.management.snmp.SnmpString;
import javax.management.snmp.SnmpValue;
import javax.management.snmp.SnmpVarBind;
import javax.management.snmp.SnmpVarBindList;
import javax.management.snmp.manager.SnmpParameters;
import javax.management.snmp.manager.SnmpPeer;
import javax.management.snmp.manager.SnmpRequest;
import javax.management.snmp.manager.SnmpSession;

public class Generic_Mibsnmp {
    private String wwn;
    private String ipno;
    private static int TIMEOUT = 60000;
    private static int MAX_TRIES = 3;
    private SnmpPeer agent = null;
    private static final String IP = "ip";
    private static final String SNMP_WWN = "wwnSnmp";
    private static final String DOT = ".";
    private static final String ZERO = "0";
    private static final String LOG_TAG = "MIB";
    private static MibRepository oidDB = null;
    private static SnmpSession session = null;
    private static String[] upTime = new String[]{"sysUpTime"};
    private String sysUpTime;
    public static final String sccs_id = "@(#)Generic_Mibsnmp.java\t1.11 09/30/03 SMI";

    public Generic_Mibsnmp(String string) {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            this.ipno = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.initializePeer(this.ipno);
        session = SingleSnmpSession.getSnmpSession();
        oidDB = MibRepository.getMibStorage();
    }

    public void addOidTable(SnmpOidTableSupport snmpOidTableSupport) {
        oidDB.addOidTable(snmpOidTableSupport);
    }

    protected void initializePeer(String string) {
        try {
            this.agent = SingleSnmpSession.newSnmpPeer((String)this.ipno);
        }
        catch (UnknownHostException unknownHostException) {
            Report.error.log((Throwable)unknownHostException, (Object)"host not found");
            return;
        }
    }

    public void initializePeer(SnmpPeer snmpPeer) {
        this.agent = snmpPeer;
    }

    protected void getProperties(HashMap hashMap, String[] stringArray, String string) {
        this.getProperties(hashMap, stringArray, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getProperties(HashMap hashMap, String[] stringArray, String string, String string2) {
        SnmpRequest snmpRequest;
        block23: {
            block22: {
                snmpRequest = null;
                boolean bl = false;
                try {
                    try {
                        int n;
                        SnmpOid.setSnmpOidTable((SnmpOidTable)oidDB);
                        if (this.agent == null) {
                            this.initializePeer(this.ipno);
                        }
                        SnmpParameters snmpParameters = new SnmpParameters("public", "private");
                        this.agent.setSnmpParam(snmpParameters);
                        session.setDefaultPeer(this.agent);
                        SnmpVarBindList snmpVarBindList = new SnmpVarBindList("SNMP.System_Properties");
                        try {
                            int n2 = 0;
                            while (n2 < stringArray.length) {
                                if (string != null) {
                                    snmpVarBindList.addVarBind(stringArray[n2] + DOT + string);
                                } else {
                                    snmpVarBindList.addVarBind(stringArray[n2]);
                                }
                                ++n2;
                            }
                        }
                        catch (SnmpStatusException snmpStatusException) {
                            Report.debug.log(LOG_TAG, (Object)snmpStatusException.getLocalizedMessage());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Report.debug.log(LOG_TAG, (Object)illegalArgumentException.getLocalizedMessage());
                        }
                        int n3 = 0;
                        while (n3 < MAX_TRIES && !(bl = (snmpRequest = session.snmpGetRequest(this.agent, null, snmpVarBindList)).waitForCompletion((long)(n = this.agent.getTimeout() * this.agent.getMaxTries())))) {
                            try {
                                this.wait(TIMEOUT);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++n3;
                        }
                        if (!bl) {
                            if (snmpRequest != null) {
                                return;
                            }
                            Object var19_18 = null;
                            if (snmpRequest == null) return;
                            return;
                        }
                        int n4 = snmpRequest.getErrorStatus();
                        if (n4 != 0) {
                            if (snmpRequest.getErrorIndex() != 0) {
                                Report.error.log((Object)("Error status = " + SnmpRequest.snmpErrorToString((int)n4)));
                                Report.error.log((Object)("Error index = " + snmpRequest.getErrorIndex()));
                            }
                            Report.debug.log(LOG_TAG, (Object)("Returning with errorStatus = " + n4 + " for ip " + this.ipno));
                            break block22;
                        }
                        SnmpVarBindList snmpVarBindList2 = snmpRequest.getResponseVarBindList();
                        int n5 = snmpVarBindList2.getVarBindCount();
                        int n6 = 0;
                        while (n6 < n5) {
                            block24: {
                                SnmpVarBind snmpVarBind;
                                block25: {
                                    block26: {
                                        snmpVarBind = snmpVarBindList2.getVarBindAt(n6);
                                        if (snmpVarBind == null || !snmpVarBind.isValidValue()) break block24;
                                        SnmpValue snmpValue = snmpVarBind.getSnmpValue();
                                        if (!(snmpValue instanceof SnmpString)) break block25;
                                        long[] lArray = snmpValue.toOid().longValue();
                                        StringBuffer stringBuffer = new StringBuffer();
                                        if ((lArray.length != 8 && lArray.length != 16 || stringArray[n6].startsWith("connUnitRevs")) && !stringArray[n6].endsWith("DomainId")) break block26;
                                        if (string2 != null) {
                                            if (string2.equalsIgnoreCase("Hex")) {
                                                hashMap.put(stringArray[n6], SNMPHexValueHandler.toHexString(lArray));
                                            }
                                            break block24;
                                        } else {
                                            hashMap.put(stringArray[n6], SNMPHexValueHandler.toString(lArray));
                                        }
                                        break block24;
                                    }
                                    hashMap.put(stringArray[n6], snmpVarBind.getStringValue());
                                    break block24;
                                }
                                hashMap.put(stringArray[n6], snmpVarBind.getStringValue());
                            }
                            ++n6;
                        }
                        break block23;
                    }
                    catch (SnmpStatusException snmpStatusException) {
                        Report.warning.log((Object)(snmpStatusException.getLocalizedMessage() + " for device " + this.ipno));
                        Object var19_21 = null;
                        if (snmpRequest == null) return;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    if (snmpRequest == null) throw throwable;
                    snmpRequest = null;
                    throw throwable;
                }
            }
            Object var19_19 = null;
            if (snmpRequest == null) return;
            return;
        }
        Object var19_20 = null;
        if (snmpRequest == null) return;
    }

    public String getSystemUpTimeString() {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, upTime, ZERO);
        if (hashMap.size() == 0) {
            this.addOidTable((SnmpOidTableSupport)new RFC1213_MIBOidTable());
            this.getProperties(hashMap, upTime, ZERO);
        }
        this.sysUpTime = (String)hashMap.get("sysUpTime");
        return this.sysUpTime;
    }

    public long getSystemUpTime() {
        long l = 0L;
        if (this.sysUpTime == null) {
            this.sysUpTime = this.getSystemUpTimeString();
        }
        l = SystemUpTimeParser.parseSNMPSystemUpTime(this.sysUpTime);
        return l;
    }

    public SnmpOidRecord resolveVarName(String string) throws SnmpStatusException {
        SnmpOidRecord snmpOidRecord = oidDB.resolveVarName(string);
        return snmpOidRecord;
    }

    public static void main(String[] stringArray) {
        Generic_Mibsnmp generic_Mibsnmp = new Generic_Mibsnmp("172.20.103.90");
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        generic_Mibsnmp.addOidTable(new FCMGMT_MIBOidTable());
        System.out.println(generic_Mibsnmp.getSystemUpTime());
    }

    public static class Test
    extends UnitTest {
        public void test_McData_FA_MIB() {
            this.assertNotNull(new Generic_Mibsnmp(null));
        }
    }
}

