/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchOOBProbe;
import com.sun.jade.device.fcswitch.util.inband.InbandDataParser;
import com.sun.jade.device.util.GUIDGenerator;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Probe;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.SNMPProbe;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class SwitchIBProbe
implements Probe {
    private static final String SNMP_URL = "snmp://";
    private static final String HTTP_URL = "http://";
    private static final String ZERO_IP = "0.0.0.0";
    private static final String COMMA = ",";
    private static final String SERACK_INTERNAL_SWITCH_NAME = "<sysName undefined>";
    private Properties probeProps;
    private String inbandDiscoveryEnabled;
    public static final String sccs_id = "@(#)SwitchIBProbe.java\t1.15 04/01/04 SMI";

    public SwitchIBProbe(Properties properties) {
        this.probeProps = properties;
        this.inbandDiscoveryEnabled = properties.getProperty("INBAND_DISCOVERY_ENABLED");
    }

    public ProbeResult probe(Properties properties) {
        Object object;
        Object object2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = properties.getProperty("RHBA.IE.Address");
        String string2 = properties.getProperty("RHBA.IE.DomainId");
        if (string != null) {
            object2 = new SNMPProbe();
            object = new SwitchOOBProbe(this.probeProps);
            StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA);
            object2.addSubProbe((Probe)object, object2.getName(), "ANY");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = SwitchIBProbe.getIpAddress(string3);
                if (string4 == null) continue;
                try {
                    Properties properties2 = new Properties();
                    InetAddress inetAddress = InetAddress.getByName(string4);
                    properties2.setProperty("ip", inetAddress.getHostName());
                    properties2.setProperty("ipno", inetAddress.getHostAddress());
                    properties2.setProperty("timeout", "30");
                    ProbeResult probeResult = object2.probe(properties2);
                    Iterator iterator = probeResult.getDevices().iterator();
                    boolean bl = true;
                    if (!iterator.hasNext()) continue;
                    while (iterator.hasNext()) {
                        Properties properties3 = (Properties)iterator.next();
                        long l = System.currentTimeMillis();
                        properties3.setProperty("search.ib", "" + l);
                        properties3.setProperty("search.oob", "" + l);
                        String string5 = properties3.getProperty("DomainId");
                        if (string5 == null && string2 != null) {
                            properties3.setProperty("DomainId", string2);
                        }
                        arrayList.add(properties3);
                        if (properties3.getProperty("wwn") != null) continue;
                        bl = false;
                    }
                    if (!bl) continue;
                    return new ProbeResult(properties, arrayList);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Report.error.log("Error probing " + string3, (Object)exception);
                }
            }
        }
        if ("yes".equalsIgnoreCase(this.inbandDiscoveryEnabled)) {
            object2 = new IBProbeDataCollector(properties);
            object = ((IBProbeDataCollector)object2).getDeviceProperties();
            if (((Properties)object).size() > 0) {
                long l = System.currentTimeMillis();
                ((Properties)object).setProperty("search.ib", "" + l);
                if (string2 != null) {
                    ((Properties)object).setProperty("DomainId", string2);
                }
                arrayList.add(object);
            }
            return new ProbeResult(properties, arrayList);
        }
        return new ProbeResult(properties, arrayList);
    }

    public String getName() {
        return "switch";
    }

    private static String getIpAddress(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SwitchIBProbe.getIpAddress(string, SNMP_URL);
        if (string2 == null) {
            string2 = SwitchIBProbe.getIpAddress(string, HTTP_URL);
        }
        if (ZERO_IP.equalsIgnoreCase(string2)) {
            return null;
        }
        return string2;
    }

    private static String getIpAddress(String string, String string2) {
        int n;
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return null;
        }
        String string3 = string.substring(n2 + string2.length());
        int n3 = string3.indexOf("/");
        if (n3 > 0) {
            string3 = string3.substring(0, n3);
        }
        if ((n = string3.indexOf(":")) > 0) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    public static class Test
    extends UnitTest {
        public void test_getIpAddress() {
            String string = "snmp://12.34.56.78";
            String string2 = "snmp://12.34.56.78/";
            String string3 = " snmp://12.34.56.78";
            String string4 = "http://12.34.56.78";
            String string5 = "12.34.56.78";
            String string6 = "snmp://12.34.56.78:161";
            String string7 = "snmp://0.0.0.0";
            this.assertEquals(string5, SwitchIBProbe.getIpAddress(string));
            this.assertEquals(string5, SwitchIBProbe.getIpAddress(string2));
            this.assertEquals(string5, SwitchIBProbe.getIpAddress(string3));
            this.assertEquals(string5, SwitchIBProbe.getIpAddress(string6));
            this.assertNull(SwitchIBProbe.getIpAddress(string7));
        }
    }

    protected static interface InbandSwitchVendor {
        public static final String QLOGIC = "QLogic";
        public static final String BROCADE = "Brocade";
        public static final String MCDATA = "MCDATA";
        public static final String SUN = "Sun";
        public static final String INRANGE = "Inrange";
    }

    private class IBProbeDataCollector
    implements InbandSwitchVendor {
        private Properties deviceProps;
        private Properties prp;
        private String ibWWN;
        private String fabricName;
        private static final String DEFAULT_VENDOR = "Unknown";
        private static final String DEFAULT_MODEL = "Fibre Channel Switch";

        public IBProbeDataCollector(Properties properties) throws IllegalArgumentException {
            this.prp = properties;
            this.ibWWN = properties.getProperty("RHBA.IE.WWN");
            if (this.ibWWN == null) {
                throw new IllegalArgumentException("Invalid WWN passed to IB Probe");
            }
            this.fabricName = properties.getProperty("RHBA.IE.FabricName");
            if (this.fabricName == null) {
                Report.warning.log((Object)("Invalid fabric name (Inband) for switch " + this.ibWWN));
            }
            if (this.prp != null) {
                this.deviceProps = new Properties();
                this.setDeviceProperties(this.prp, this.deviceProps);
            }
        }

        private void setDeviceProperties(Properties properties, Properties properties2) {
            String string = null;
            String string2 = null;
            String string3 = null;
            if (this.ibWWN != null) {
                properties2.setProperty("wwn", this.ibWWN);
                properties2.setProperty("FabricName", this.fabricName);
                string3 = properties.getProperty("RHBA.IE.LogicalName");
                string = string3.compareToIgnoreCase(SwitchIBProbe.SERACK_INTERNAL_SWITCH_NAME) == 0 ? this.ibWWN.toUpperCase() : string3;
                properties2.setProperty("logicalName", string == null ? "-" : string);
                properties2.setProperty("Name", string == null ? "-" : string);
                properties2.setProperty("type", "switch");
                string = properties.getProperty("RHBA.IE.ReleaseCode");
                properties2.setProperty("FirmwareVersion", string == null ? "-" : string);
                string = properties.getProperty("RHBA.IE.ModelName");
                properties2.setProperty("MODEL", string == null ? DEFAULT_MODEL : string);
                string = properties.getProperty("RHBA.IE.VendorName");
                properties2.setProperty("VENDOR", string == null ? DEFAULT_VENDOR : string);
                String string4 = this.getVendorProperty(string);
                String string5 = GUIDGenerator.generateGUID((String)"fc-switch", (String)(string4 == null ? DEFAULT_VENDOR : string4), (String)"wwn", (String)this.ibWWN);
                properties2.setProperty("GUID", string5);
                Iterator iterator = this.getSwitchOnlinePortWWNList(this.ibWWN);
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    if (string6 == null) continue;
                    string2 = string2 == null ? string6 + SwitchIBProbe.COMMA : string2 + string6 + SwitchIBProbe.COMMA;
                }
                if (string2 != null) {
                    string2 = string2.trim();
                    string2 = string2.substring(0, string2.length() - 1);
                    properties2.setProperty("wwnList", string2);
                }
            }
        }

        public Properties getDeviceProperties() {
            return this.deviceProps;
        }

        private Iterator getSwitchOnlinePortWWNList(String string) {
            InbandDataParser inbandDataParser = new InbandDataParser(string);
            return inbandDataParser.getSwitchOnlinePortWWN();
        }

        private String getVendorProperty(String string) {
            String string2 = "vendor." + this.getSwitchModelInt(string);
            LocalizedString localizedString = new LocalizedString("com.sun.jade.device.fcswitch.fibrealliance.service.resource.SwitchModel", string2.trim(), DEFAULT_VENDOR);
            return localizedString.getString();
        }

        private int getSwitchModelInt(String string) {
            try {
                if (Pattern.compile("Sun", 2).matcher(string).find(0)) {
                    return 1;
                }
                if (Pattern.compile("QLogic", 2).matcher(string).find(0)) {
                    return 2;
                }
                if (Pattern.compile("Brocade", 2).matcher(string).find(0)) {
                    return 3;
                }
                if (Pattern.compile("MCDATA", 2).matcher(string).find(0)) {
                    return 4;
                }
                if (Pattern.compile("Inrange", 2).matcher(string).find(0)) {
                    return 5;
                }
            }
            catch (Exception exception) {
                return 0;
            }
            return 0;
        }
    }
}

