/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.fibrealliance.io.AbstractSwitchDeviceReport;
import com.sun.jade.device.fcswitch.util.snmp.CIMStateStatusHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPPortType;
import com.sun.jade.device.fcswitch.util.zones.ZoneInfo;
import com.sun.jade.device.protocol.agent.StoradeReportConverter;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.component.zoning.api.ZoningHelper;
import com.sun.netstorage.mgmt.fm.storade.client.StoradeClient;
import com.sun.netstorage.mgmt.fm.storade.util.TokenList;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Properties;

public class StorADESwitchReportConvertor
extends AbstractSwitchDeviceReport
implements StoradeReportConverter {
    private Properties props;
    private static final String CIM_VERSION = "CIM 2.5";
    private String ip;
    private int portCount;
    private String wwn;
    private static final String SYSTEM_VIEW = "SystemView";
    private static final String ZONE_VIEW = "ZoneView";
    private static final String DOT = ".";
    private static final String PORT_COUNT_ERROR_MESSAGE = "Error getting the number of ports.";
    private static final String SENSOR_COUNT_ERROR_MESSAGE = "Error getting the number of sensors.";
    private static final int TEN = 10;
    private static final String LOG_TAG = "Switch_Device_Report";
    private static final String DEFAULT_PORT_TYPE = "1";
    private int noOfZones;
    private int noOfZonesets;
    private int noOfSensors;
    private ZoningHelper zoneHelper;
    public static final String sccs_id = "@(#)StorADESwitchReportConvertor.java 1.9     04/03/29 SMI";

    public StorADESwitchReportConvertor(Properties properties) {
        this(properties, null);
    }

    public StorADESwitchReportConvertor(Properties properties, ZoningHelper zoningHelper) {
        super(properties, zoningHelper);
        this.zoneHelper = zoningHelper;
        this.props = properties;
        this.ip = properties.getProperty("ip");
        this.wwn = properties.getProperty("wwn");
        try {
            this.portCount = Integer.parseInt(properties.getProperty("NumberOfPorts"));
        }
        catch (Exception exception) {
            this.portCount = 0;
        }
    }

    public synchronized String generateReport() {
        return "";
    }

    public synchronized DeviceClass convertSubReport(TokenList tokenList, String string) {
        DeviceClass deviceClass;
        block2: {
            deviceClass = new DeviceClass();
            if (!string.startsWith("port")) break block2;
            try {
                String string2 = this.getIndex(string);
                int n = Integer.parseInt(string2);
                this.populateFibrePort(tokenList, deviceClass, n);
                DeviceClass deviceClass2 = deviceClass.newSubInstance();
                this.populateFibreCounters(tokenList, deviceClass2, n);
                DeviceClass deviceClass3 = deviceClass.newSubInstance();
                this.populateProtocolEndPoint(deviceClass3, n);
            }
            catch (Exception exception) {
                Report.error.log((Object)("Could not parse the component " + string));
            }
        }
        return deviceClass;
    }

    private String getIndex(String string) {
        String string2;
        block3: {
            string2 = null;
            if (string == null) break block3;
            try {
                int n = string.indexOf(DOT);
                if (n > -1) {
                    string2 = string.substring(n + 1);
                    break block3;
                }
                string2 = string;
            }
            catch (Exception exception) {
                Report.error.log((Object)("Could not determine the element id from " + string));
            }
        }
        return string2;
    }

    public synchronized DeviceClass convertReport(TokenList tokenList) {
        DeviceClass deviceClass;
        block5: {
            DeviceClass deviceClass2 = null;
            DeviceClass deviceClass3 = null;
            Object var4_4 = null;
            Object var5_5 = null;
            Object var6_6 = null;
            DeviceClass deviceClass4 = null;
            DeviceClass deviceClass5 = null;
            DeviceClass deviceClass6 = null;
            deviceClass = this.getReport();
            DeviceClass deviceClass7 = deviceClass.newSubInstance();
            deviceClass7.setClassName("model");
            deviceClass7.setProperty("schema", CIM_VERSION);
            deviceClass7.setProperty("view", "system");
            deviceClass7.setProperty("type", "switch");
            deviceClass7.setProperty("prefix", "StorAdeSwitch");
            deviceClass7.setProperty("package", "com.sun.jade.cim.bean");
            DeviceClass deviceClass8 = deviceClass7.newSubInstance();
            deviceClass8.setClassName(SYSTEM_VIEW);
            DeviceClass deviceClass9 = deviceClass8.newSubInstance();
            this.populateSwitchSystem(tokenList, deviceClass9);
            DeviceClass deviceClass10 = deviceClass9.newSubInstance();
            this.populateChassisDevice(tokenList, deviceClass10);
            DeviceClass deviceClass11 = deviceClass9.newSubInstance();
            this.populatePhysicalPackage(tokenList, deviceClass11);
            if (this.portCount == 0) break block5;
            int n = 0;
            while (n < this.portCount) {
                deviceClass3 = deviceClass9.newSubInstance();
                this.populateFibrePort(tokenList, deviceClass3, n);
                deviceClass2 = deviceClass3.newSubInstance();
                this.populateFibreCounters(tokenList, deviceClass2, n);
                deviceClass4 = deviceClass3.newSubInstance();
                this.populateProtocolEndPoint(deviceClass4, n);
                String string = tokenList.getStringValue("port." + n, "link_wwn");
                if (string != null) {
                    this.populateLogicalNetwork(deviceClass4, deviceClass6);
                    deviceClass5 = deviceClass4.newSubInstance();
                    deviceClass5.setClassName("ProtocolEndpoint");
                    if (string != null) {
                        string = string.substring(0, 16);
                    }
                    deviceClass5.setProperty("Name", string);
                    deviceClass5.setProperty("NameFormat", "WWN");
                    deviceClass5.setProperty("ProtocolType", "18");
                }
                ++n;
            }
            try {
                this.addZoneData(deviceClass9, deviceClass7);
            }
            catch (Exception exception) {
                Object[] objectArray = null;
                String string = this.props.getProperty("password");
                objectArray = string != null && !"".equals(string) ? ZoneInfo.getQlogicZones(this.ip, string) : ZoneInfo.getQlogicZones(this.ip);
                this.addZoneData(deviceClass9, deviceClass7, objectArray);
            }
        }
        return deviceClass;
    }

    protected String getIP() {
        return this.ip;
    }

    protected String getPortWWN(int n) {
        String string = null;
        if (string == null) {
            String string2 = Integer.toHexString(n);
            string = this.computePortWWN(string2);
        }
        try {
            if (string != null && string.length() > 16) {
                string = string.substring(0, 16);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return string;
    }

    private String computePortWWN(String string) {
        StringBuffer stringBuffer = new StringBuffer(this.getWWN());
        stringBuffer.setCharAt(0, '2');
        if (string.length() > 1) {
            stringBuffer.setCharAt(2, string.charAt(0));
            stringBuffer.setCharAt(3, string.charAt(1));
            return stringBuffer.toString();
        }
        stringBuffer.setCharAt(3, string.charAt(0));
        return stringBuffer.toString();
    }

    protected void populateProtocolEndPoint(DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("ProtocolEndpoint");
        string = this.getPortWWN(n);
        if (string.length() > 16) {
            string = string.substring(0, 16);
        }
        deviceClass.setProperty("CreationClassName", "CIM_ProtocolEndpoint");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("Name", string == null ? "" : string);
        deviceClass.setProperty("NameFormat", "WWN");
        deviceClass.setProperty("ProtocolType", "18");
    }

    protected void populateLogicalNetwork(DeviceClass deviceClass, DeviceClass deviceClass2) {
        String string = this.props.getProperty("FabricName");
        deviceClass2 = deviceClass.newSubInstance();
        deviceClass2.setClassName("LogicalNetwork");
        deviceClass2.setProperty("Name", string);
        deviceClass2.setProperty("NetworkType", "18");
    }

    protected void populateSwitchSystem(TokenList tokenList, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("Name", this.getWWN());
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(tokenList.getStringValue("header", "status")));
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        string = this.props.getProperty("ipno");
        if (string == null) {
            string = "-";
        }
        deviceClass.setProperty("OtherIdentifyingInfo", string == null ? this.ip : string);
        deviceClass.setProperty("IdentifyingDescriptions", "IP Address");
        deviceClass.setProperty("PortCount", this.portCount + "");
        String string2 = "info.version";
        string = tokenList.getStringValue(string2, "Active_Firmware_image");
        if (string == null) {
            string = tokenList.getStringValue(string2, "FLASH_Firmware_Revision");
        }
        deviceClass.setProperty("Flash", string == null ? "-" : string);
        String string3 = tokenList.getStringValue(string2, "Hardware_PCB_Version");
        if ("<Unknown>".equalsIgnoreCase(string3)) {
            string3 = "UnKnown";
        }
        deviceClass.setProperty("HW", string3 == null ? "-" : string3);
        deviceClass.setProperty("MAC", "-");
        string3 = tokenList.getStringValue(string2, "Flasher_Shell_Version");
        if (string3 == null) {
            string3 = tokenList.getStringValue(string2, "PROM_Firmware_Revision");
        }
        deviceClass.setProperty("PROM", string3 == null ? "-" : string3);
        deviceClass.setProperty("WWN", this.getWWN());
        deviceClass.setProperty("ZoneTotal", this.noOfZones + "");
        String string4 = this.props.getProperty("FabricName");
        String string5 = null;
        if (this.wwn.equalsIgnoreCase(string4)) {
            string5 = "Yes";
        }
        deviceClass.setProperty("PrincipalSwitch", string5 == null ? "Unknown" : string5);
    }

    protected void populateFibreCounters(TokenList tokenList, DeviceClass deviceClass, int n) {
        String string = "port." + n + ".error";
        String string2 = null;
        deviceClass.setClassName("DeviceStatisticalInformation");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("DeviceCreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePortEventCounters");
        deviceClass.setProperty("DeviceID", "" + n);
        string2 = this.getPortWWN(n);
        string2 = string2 == null ? "" : string2;
        deviceClass.setProperty("Name", string2);
        string2 = tokenList.getStringValue(string, "LinkFailures");
        deviceClass.setProperty("LinkFails", string2 == null ? "0" : string2);
        string2 = tokenList.getStringValue(string, "PrimitiveSequenceProtocolErrors");
        deviceClass.setProperty("Prim_Seq_Errs", string2 == null ? "0" : string2);
    }

    protected void populateFibrePort(TokenList tokenList, DeviceClass deviceClass, int n) {
        String string = "port." + n;
        String string2 = null;
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("REF", "" + n);
        deviceClass.setProperty("DeviceID", "" + n);
        string2 = this.getPortWWN(n);
        string2 = string2 == null ? "" : string2;
        deviceClass.setProperty("Name", string2);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(tokenList.getStringValue(string, "state")));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(tokenList.getStringValue(string, "state")));
        deviceClass.setProperty("PowerManagementSupported", "false");
        string2 = tokenList.getStringValue(string + ".error", "LossofSignal");
        deviceClass.setProperty("LossOfSignalCounter", string2 == null ? "0" : string2);
        string2 = tokenList.getStringValue(string + ".error", "LossofSynchronization");
        deviceClass.setProperty("LossOfSyncCounter", string2 == null ? "0" : string2);
        string2 = tokenList.getStringValue(string + ".error", "InvalidCRC");
        deviceClass.setProperty("CRCErrors", string2 == null ? "0" : string2);
        string2 = tokenList.getStringValue(string + ".error", "InvalidTxWords");
        deviceClass.setProperty("InvalidTransmissionWords", string2 == null ? "0" : string2);
        deviceClass.setProperty("FramesTooShort", "0");
        deviceClass.setProperty("FramesTooLong", "0");
        string2 = tokenList.getStringValue(string, "type");
        deviceClass.setProperty("Type", string2 == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : string2);
        deviceClass.setProperty("Description", string2 == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : string2);
        string2 = tokenList.getStringValue(string, "speed");
        deviceClass.setProperty("Speed", "0");
        deviceClass.setProperty("PortOperatingSpeed", string2 == null ? "0" : string2);
        string2 = tokenList.getStringValue(string, "state");
        deviceClass.setProperty("OperatingStatus", string2 == null ? "Unknown" : string2);
        string2 = tokenList.getStringValue(string + ".state", "AdmStatus");
        deviceClass.setProperty("AdministrativeStatus", string2 == null ? "Unknown" : string2);
    }

    protected void populateChassisDevice(TokenList tokenList, DeviceClass deviceClass) {
        String string;
        String string2;
        String string3 = null;
        deviceClass.setClassName("LogicalDevice");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("DeviceID", "Chassis");
        deviceClass.setProperty("Name", "chassis");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_ChassisDevice");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(tokenList.getStringValue("header", "status")));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(tokenList.getStringValue("header", "status")));
        deviceClass.setProperty("Description", "Switch Chassis");
        deviceClass.setProperty("PowerManagementSupported", "false");
        string3 = tokenList.getStringValue("system", "sysUpTime");
        deviceClass.setProperty("PowerOnTime", string3 == null ? "-" : string3);
        string3 = tokenList.getStringValue("system", "uptime");
        deviceClass.setProperty("PowerOnSeconds", string3 == null ? "0" : string3);
        Report.debug.log(LOG_TAG, (Object)("Number of Sensors " + this.noOfSensors));
        String string4 = "sensor.board";
        TokenList[] tokenListArray = tokenList.getSubLists(string4);
        if (tokenListArray == null) {
            string4 = "sensor.other";
            tokenListArray = tokenList.getSubLists("sensor.other");
        }
        int n = 1;
        while (n <= tokenListArray.length) {
            string2 = deviceClass.newSubInstance();
            string2.setClassName("TemperatureSensor");
            string2.setProperty("SystemName", this.wwn);
            string2.setProperty("DeviceID", tokenList.getStringValue(string4 + DOT + n, "name"));
            string2.setProperty("Name", tokenList.getStringValue(string4 + DOT + n, "name"));
            string2.setProperty("CreationClassName", "CIM_TemperatureSensor");
            string2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
            string3 = tokenList.getStringValue(string4 + DOT + n, "message");
            string2.setProperty("SensorType", DEFAULT_PORT_TYPE);
            string2.setProperty("OtherSensorTypeDescription", string3 == null ? "Unknown" : string3);
            string2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(tokenList.getStringValue(string4 + DOT + n, "status")));
            ++n;
        }
        string2 = "sensor.fan";
        TokenList[] tokenListArray2 = tokenList.getSubLists(string2);
        int n2 = 1;
        while (n2 <= tokenListArray2.length) {
            string = deviceClass.newSubInstance();
            string.setClassName("Fan");
            string.setProperty("SystemName", this.wwn);
            string.setProperty("DeviceID", tokenList.getStringValue(string2 + DOT + n2, "name"));
            string.setProperty("Name", tokenList.getStringValue(string2 + DOT + n2, "name"));
            string.setProperty("CreationClassName", "CIM_Fan");
            string.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
            string.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(tokenList.getStringValue(string2 + DOT + n2, "status")));
            ++n2;
        }
        string = "sensor.power-supply";
        TokenList[] tokenListArray3 = tokenList.getSubLists(string);
        int n3 = 1;
        while (n3 <= tokenListArray3.length) {
            DeviceClass deviceClass2 = deviceClass.newSubInstance();
            deviceClass2.setClassName("PowerSupply");
            deviceClass2.setProperty("SystemName", this.wwn);
            deviceClass2.setProperty("DeviceID", tokenList.getStringValue(string + DOT + n3, "name"));
            deviceClass2.setProperty("Name", tokenList.getStringValue(string + DOT + n3, "name"));
            deviceClass2.setProperty("CreationClassName", "CIM_UninterruptiblePowerSupply");
            deviceClass2.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
            deviceClass2.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(tokenList.getStringValue(string + DOT + n3, "status")));
            ++n3;
        }
    }

    protected void populatePhysicalPackage(TokenList tokenList, DeviceClass deviceClass) {
        deviceClass.setClassName("PhysicalPackage");
        deviceClass.setProperty("Tag", this.getWWN());
        String string = this.props.getProperty("DeviceDisplayModel");
        deviceClass.setProperty("Name", string == null ? "Sun StorEdge network FC 2Gig switch" : string);
        deviceClass.setProperty("Manufacturer", string == null ? "Sun StorEdge network FC 2Gig switch" : string);
        deviceClass.setProperty("SerialNumber", "-");
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_PhysicalPackage");
        deviceClass.setProperty("Removable", "true");
        deviceClass.setProperty("Replaceable", "true");
        deviceClass.setProperty("HotSwappable", "true");
    }

    protected DeviceClass getReport() {
        DeviceClass deviceClass = new DeviceClass();
        deviceClass.setClassName("report");
        deviceClass.setProperty("ReturnCode", "OK");
        return deviceClass;
    }

    protected String getReportError(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<report ReturnCode='FAILURE'>\n");
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(exception.toString());
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        int n = 1;
        if (stringArray.length < 1) {
            System.out.println("Usage: java -Dstorade.home=<JADE_HOME>/build/demo StorADESwitchReportConvertor <mgmtHost> <device_id>");
        }
        try {
            try {
                properties.put("ip", stringArray[0]);
                StoradeClient storadeClient = new StoradeClient(stringArray[0]);
                String string = stringArray[1];
                TokenList tokenList = (TokenList)storadeClient.getDeviceReportProperties(stringArray[1]);
                String string2 = string.substring(string.indexOf(":") + 1, string.length());
                properties.put("wwn", string2);
                properties.put("NumberOfPorts", tokenList.getStringValue("port", "count"));
                properties.put("NumberOfSensors", tokenList.getStringValue("sensor", "count"));
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n > 1) {
                        Thread.sleep(30000L);
                    }
                    StorADESwitchReportConvertor storADESwitchReportConvertor = new StorADESwitchReportConvertor(properties);
                    FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/" + stringArray[1] + ".xml." + n2));
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    printStream.println(storADESwitchReportConvertor.convertReport(tokenList).toXML());
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var12_14 = null;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            throw throwable;
        }
    }

    public static class Test
    extends UnitTest {
        public void testSwitchReportGenerator(String string) {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            StorADESwitchReportConvertor storADESwitchReportConvertor = new StorADESwitchReportConvertor(properties);
            this.assertEquals(storADESwitchReportConvertor.getIP(), string);
        }

        public static void main(String[] stringArray) {
            new Test().testSwitchReportGenerator(stringArray[0]);
        }
    }
}

