/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.io;

import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.fibrealliance.io.SwitchDeviceReport;
import com.sun.jade.device.fcswitch.util.snmp.CIMStateStatusHelper;
import com.sun.jade.device.fcswitch.util.snmp.FA_Mibsnmp;
import com.sun.jade.device.fcswitch.util.snmp.PortSpeedHelper;
import com.sun.jade.device.fcswitch.util.snmp.PrincipalSwitchHelper;
import com.sun.jade.device.fcswitch.util.snmp.SNMPPortType;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToCIM_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPToString_State_Status;
import com.sun.jade.device.fcswitch.util.snmp.SNMPWalk;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.device.fcswitch.util.zones.Zones;
import com.sun.jade.device.protocol.snmp.SingleSnmpSession;
import com.sun.jade.device.util.DeviceClass;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import com.sun.netstorage.mgmt.esm.logic.device.component.zoning.api.ZoningHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.snmp.SnmpStatusException;

public class InrangeDeviceReport
extends SwitchDeviceReport {
    private Properties props;
    private String ip;
    private int portCount;
    private String wwn;
    private HashMap systemProps = null;
    private HashMap portStatProps = null;
    private HashMap portProps = null;
    private HashMap revisionProps = null;
    private HashMap sensorProps = null;
    private HashMap systemUnitProps = null;
    private HashMap portResult = null;
    private SwitchWWNsnmp swSnmp = null;
    private static final String DEFAULT_PORT_TYPE = "1";
    private static final String SYSTEM_VIEW = "SystemView";
    private static final String ZONE_VIEW = "ZoneView";
    private static final String NUMBER_OF_PORTS = "connUnitNumports";
    private static final String CONNECTED_PORT_NUMBER = "connUnitLinkPortNumberX";
    private static final String CIM_VERSION = "CIM 2.5";
    private static final String DOT = ".";
    private static final String PORT_COUNT_ERROR_MESSAGE = "Error getting the number of ports.";
    private static final int TEN = 10;
    private static final String LOG_TAG = "Inrange_Device_Report";
    private FA_Mibsnmp switchsnmp = null;
    private int noOfZones;
    private int noOfSensors;
    private Zones[] zones = null;
    private Sanbox sanbox = null;
    private ZoningHelper zoneHelper;
    public static final String sccs_id = "@(#)InrangeDeviceReport.java\t1.36 05/02/03 SMI";

    public InrangeDeviceReport(Properties properties) {
        this(properties, null);
    }

    public InrangeDeviceReport(Properties properties, ZoningHelper zoningHelper) {
        super(properties, zoningHelper);
        this.zoneHelper = zoningHelper;
        this.props = properties;
        this.switchsnmp = new FA_Mibsnmp(this.props);
    }

    public synchronized String generateReport() {
        DeviceClass deviceClass = null;
        DeviceClass deviceClass2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        DeviceClass deviceClass3 = null;
        DeviceClass deviceClass4 = null;
        DeviceClass deviceClass5 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        String string = null;
        try {
            string = this.switchsnmp.resolveVarName(CONNECTED_PORT_NUMBER).getOid();
        }
        catch (SnmpStatusException snmpStatusException) {
            // empty catch block
        }
        this.systemProps = this.switchsnmp.getConnectivityProps();
        if (this.portCount == 0) {
            this.portCount = this.getNumberOfPorts();
        }
        DeviceClass deviceClass6 = this.getReport();
        DeviceClass deviceClass7 = deviceClass6.newSubInstance();
        deviceClass7.setClassName("model");
        deviceClass7.setProperty("schema", CIM_VERSION);
        deviceClass7.setProperty("view", "system");
        deviceClass7.setProperty("type", "switch");
        deviceClass7.setProperty("prefix", "StorAdeSwitch");
        deviceClass7.setProperty("package", "com.sun.jade.cim.bean");
        Report.debug.log(LOG_TAG, (Object)("Filter " + string + DOT + this.props.getProperty("wwnSnmp")));
        this.portResult = this.discoverConnectedDevice(string + DOT + this.props.getProperty("wwnSnmp"));
        DeviceClass deviceClass8 = deviceClass7.newSubInstance();
        deviceClass8.setClassName(SYSTEM_VIEW);
        DeviceClass deviceClass9 = deviceClass8.newSubInstance();
        this.populateSwitchSystem(this.switchsnmp, this.systemProps, deviceClass9);
        DeviceClass deviceClass10 = deviceClass9.newSubInstance();
        this.populateChassisDevice(this.systemProps, deviceClass10);
        DeviceClass deviceClass11 = deviceClass9.newSubInstance();
        this.populatePhysicalPackage(this.systemProps, deviceClass11);
        Collection collection = this.getPortIndex();
        if (this.portCount != 0) {
            int n = 1;
            while (n <= this.portCount) {
                String string2 = new Integer(n).toString();
                if (collection.contains(string2)) {
                    this.portStatProps = this.switchsnmp.getPortStatProps(n);
                    this.portProps = this.switchsnmp.getPortProps(n);
                } else {
                    this.portStatProps = new HashMap();
                    this.portProps = new HashMap();
                }
                deviceClass2 = deviceClass9.newSubInstance();
                this.populateFibrePort(this.portProps, this.portStatProps, deviceClass2, n);
                deviceClass = deviceClass2.newSubInstance();
                this.populateFibreCounters(this.portProps, this.portStatProps, deviceClass, n);
                if (this.portProps.size() != 0) {
                    deviceClass3 = deviceClass2.newSubInstance();
                    this.populateProtocolEndPoint(this.portProps, deviceClass3, n);
                    Set set = this.portResult.entrySet();
                    Iterator iterator = set.iterator();
                    String string3 = null;
                    int n2 = 0;
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String string4 = (String)entry.getValue();
                        try {
                            n2 = Integer.parseInt(string4, 10);
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                        if (n2 != n) continue;
                        this.populateLogicalNetwork(deviceClass3, deviceClass5);
                        deviceClass4 = deviceClass3.newSubInstance();
                        string3 = (String)entry.getKey();
                        int n3 = string3.lastIndexOf(DOT);
                        string3 = string3.substring(n3);
                        HashMap hashMap = this.switchsnmp.getLinkProps(string3);
                        deviceClass4.setClassName("ProtocolEndpoint");
                        String string5 = (String)hashMap.get("connUnitLinkPortWwnY");
                        if (string5 != null) {
                            string5 = string5.substring(0, 16);
                        }
                        deviceClass4.setProperty("Name", string5);
                        deviceClass4.setProperty("NameFormat", "WWN");
                        deviceClass4.setProperty("ProtocolType", "18");
                    }
                }
                ++n;
            }
        }
        return deviceClass6.toXML();
    }

    protected String getPortWWN(HashMap hashMap, int n) {
        String string = (String)hashMap.get("connUnitPortWwn");
        try {
            if (string != null && string.length() > 16) {
                string = string.substring(0, 16);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return string;
    }

    protected void populateSwitchSystem(FA_Mibsnmp fA_Mibsnmp, HashMap hashMap, DeviceClass deviceClass) {
        String string = null;
        deviceClass.setClassName("UnitaryComputerSystem");
        deviceClass.setProperty("Name", this.getWWN());
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)hashMap.get("connUnitStatus"))));
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        string = this.props.getProperty("ipno");
        deviceClass.setProperty("OtherIdentifyingInfo", string == null ? this.ip : string);
        deviceClass.setProperty("IdentifyingDescriptions", "IP Address");
        deviceClass.setProperty("PortCount", (String)hashMap.get(NUMBER_OF_PORTS));
        this.revisionProps = fA_Mibsnmp.getRevisionProps(2);
        deviceClass.setProperty("Flash", this.revisionProps.get("connUnitRevsRevId") == null ? "-" : (String)this.revisionProps.get("connUnitRevsRevId"));
        this.revisionProps = fA_Mibsnmp.getRevisionProps(4);
        String string2 = (String)this.revisionProps.get("connUnitRevsRevId");
        if ("<Unknown>".equalsIgnoreCase(string2)) {
            string2 = "UnKnown";
        }
        deviceClass.setProperty("HW", string2 == null ? "-" : string2);
        deviceClass.setProperty("MAC", "-");
        this.revisionProps = fA_Mibsnmp.getRevisionProps(3);
        string2 = (String)this.revisionProps.get("connUnitRevsRevId");
        deviceClass.setProperty("PROM", string2 == null ? "-" : string2);
        deviceClass.setProperty("WWN", this.getWWN());
        deviceClass.setProperty("ZoneTotal", this.noOfZones + "");
        string = (String)hashMap.get("connUnitPrincipal");
        if (string != null) {
            string = PrincipalSwitchHelper.get_FA_PrincipalSwitchAttr(string);
        }
        deviceClass.setProperty("PrincipalSwitch", string == null ? "Unknown" : string);
    }

    protected void populateFibrePort(HashMap hashMap, HashMap hashMap2, DeviceClass deviceClass, int n) {
        String string = null;
        deviceClass.setClassName("FibrePort");
        deviceClass.setProperty("SystemName", this.getWWN());
        deviceClass.setProperty("REF", "" + (n - 1));
        deviceClass.setProperty("DeviceID", "" + (n - 1));
        string = this.getPortWWN(hashMap, n - 1);
        string = string == null ? "" : string;
        deviceClass.setProperty("Name", string);
        deviceClass.setProperty("CreationClassName", "StorAdeSwitch_FibrePort");
        deviceClass.setProperty("SystemCreationClassName", "StorAdeSwitch_UnitaryComputerSystem");
        deviceClass.setProperty("Status", CIMStateStatusHelper.convertToCIMStatus(SNMPToCIM_State_Status.getOperationalStatusString((String)hashMap.get("connUnitPortStatus"))));
        deviceClass.setProperty("Availability", CIMStateStatusHelper.convertToCIMAvailability(SNMPToCIM_State_Status.getOperationalStatusString((String)hashMap.get("connUnitPortStatus"))));
        deviceClass.setProperty("PowerManagementSupported", "false");
        string = (String)hashMap2.get("connUnitPortStatCountLossofSignal");
        deviceClass.setProperty("LossOfSignalCounter", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountLossofSynchronization");
        deviceClass.setProperty("LossOfSyncCounter", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountInvalidCRC");
        deviceClass.setProperty("CRCErrors", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountInvalidTxWords");
        deviceClass.setProperty("InvalidTransmissionWords", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountFramesTruncated");
        deviceClass.setProperty("FramesTooShort", string == null ? "0" : string);
        string = (String)hashMap2.get("connUnitPortStatCountFramesTooLong");
        deviceClass.setProperty("FramesTooLong", string == null ? "0" : string);
        string = (String)hashMap.get("connUnitPortType");
        deviceClass.setProperty("Type", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        deviceClass.setProperty("Description", string == null ? SNMPPortType.getPortTypeString(DEFAULT_PORT_TYPE) : SNMPPortType.getPortTypeString(string));
        string = (String)hashMap.get("connUnitPortSpeed");
        deviceClass.setProperty("Speed", string == null ? "0" : string);
        deviceClass.setProperty("PortOperatingSpeed", PortSpeedHelper.getPortSpeed(string));
        String string2 = this.getOperatingStatusString(SNMPToString_State_Status.getOperationalStatusString((String)hashMap.get("connUnitPortStatus")));
        deviceClass.setProperty("OperatingStatus", string2);
        deviceClass.setProperty("AdministrativeStatus", SNMPToCIM_State_Status.getOperationalStateString((String)hashMap.get("connUnitPortState")));
    }

    private Collection getPortIndex() {
        SNMPWalk sNMPWalk = new SNMPWalk(this.getIP());
        HashMap hashMap = new HashMap();
        hashMap = sNMPWalk.getProperties("connUnitPortIndex", "connUnitPortType");
        return hashMap.values();
    }

    private String getOperatingStatusString(String string) {
        if ("OLS".equalsIgnoreCase(string)) {
            return "Off Line";
        }
        if ("Ready".equalsIgnoreCase(string)) {
            return "Online";
        }
        return "Unknown";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) throws Exception {
        Properties properties = new Properties();
        int n = 1;
        if (stringArray.length < 1) {
            System.out.println("Usage: java -Dstorade.home=<JADE_HOME>/build/demo InrangeDeviceReport <ipAddress> <noTimes>");
        }
        try {
            try {
                properties.put("ip", stringArray[0]);
                SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(stringArray[0]);
                String string = switchWWNsnmp.getWWNString();
                String string2 = switchWWNsnmp.getWWNSnmp();
                String string3 = switchWWNsnmp.getFabricName();
                properties.put("wwn", string);
                properties.put("wwnSnmp", string2);
                properties.put("FabricName", string3);
                try {
                    n = Integer.parseInt(stringArray[1]);
                }
                catch (Exception exception) {
                    n = 1;
                }
                int n2 = 0;
                while (n2 < n) {
                    if (n > 1) {
                        Thread.sleep(30000L);
                    }
                    InrangeDeviceReport inrangeDeviceReport = new InrangeDeviceReport(properties);
                    FileOutputStream fileOutputStream = new FileOutputStream(new File("/tmp/" + stringArray[0] + ".xml." + n2));
                    PrintStream printStream = new PrintStream(fileOutputStream);
                    printStream.println(inrangeDeviceReport.generateReport());
                    ++n2;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var12_14 = null;
                SingleSnmpSession.destroySnmpSession();
                SingleSnmpSession.destroyAsyncSnmpSession();
                return;
            }
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            SingleSnmpSession.destroySnmpSession();
            SingleSnmpSession.destroyAsyncSnmpSession();
            throw throwable;
        }
        SingleSnmpSession.destroySnmpSession();
        SingleSnmpSession.destroyAsyncSnmpSession();
    }

    public static class Test
    extends UnitTest {
        public void testInrangeReportGenerator(String string) {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            InrangeDeviceReport inrangeDeviceReport = new InrangeDeviceReport(properties);
            String string2 = new SwitchWWNsnmp(properties.getProperty("ip")).getWWNString();
            this.assertNotNull(string2);
            this.assertEquals(inrangeDeviceReport.getIP(), string);
        }

        public static void main(String[] stringArray) {
            new Test().testInrangeReportGenerator(stringArray[0]);
        }
    }
}

