/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.DataBlock;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;

public class Topology
extends SanboxHeader {
    private static final int UT_CONFIG_MGMT_MSG = 48;
    private static final int CFG_FABRIC_TOPOLOGY_REQ = 16;
    private static VariableDefinition[] req = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("first_port", 1), new VariableDefinition("reserved", 1, 3)};
    private static VariableDefinition[] ret = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("first_port", 1), new VariableDefinition("total_ports", 1), new VariableDefinition("rprt_chassis_num", 1), new VariableDefinition("rprt_stage_type", 1), new VariableDefinition("rprt_port0_addr", 4), new VariableDefinition("port_links", 12, 16)};
    private static VariableDefinition[] port_link_s = new VariableDefinition[]{new VariableDefinition("link_chassis_num", 1), new VariableDefinition("link_stage_type", 1), new VariableDefinition("link_status", 1), new VariableDefinition("reserved", 1), new VariableDefinition("rprt_port_addr", 4), new VariableDefinition("link_port_addr", 4)};
    private static final String sccs_id = "@(#)Topology.java\t1.1 10/08/01 SMI";

    public static byte[] getTopologyRequest(int n) {
        SanboxHeader sanboxHeader = new SanboxHeader(req);
        sanboxHeader.setCommand(48);
        DataBlock dataBlock = sanboxHeader.getBlock();
        dataBlock.setVariable("sub_cmd", 16L);
        dataBlock.setVariable("first_port", n);
        return sanboxHeader.getBytes();
    }

    public Topology(byte[] byArray) {
        super(ret);
        this.block.useData(byArray);
    }

    public int getFirstPort() {
        return (int)this.block.getVariableValue("first_port");
    }

    public int getTotalPorts() {
        return (int)this.block.getVariableValue("total_ports");
    }

    public int getRprtChassisNum() {
        return (int)this.block.getVariableValue("rprt_chassis_num");
    }

    public int getRprtStageType() {
        return (int)this.block.getVariableValue("rprt_stage_type");
    }

    public int getRprtPort0Addr() {
        return (int)this.block.getVariableValue("rprt_port0_addr");
    }

    public int getLinkPortAddr(int n) {
        DataBlock dataBlock = new DataBlock(port_link_s);
        dataBlock.useData(this.block.getVariableBytes("port_links", n));
        return (int)dataBlock.getVariableValue("link_port_addr");
    }
}

