/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.SimpleSubCommand;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class SystemConfig
extends SanboxHeader {
    private static final String sccs_id = "@(#)SystemConfig.java\t1.3 10/08/01 SMI";
    private static final int COUNT = 64;
    private static final int COMMAND = 48;
    private static final int SUB_COMMAND = 516;
    private static VariableDefinition[] ret = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("sysUpTime", 4), new VariableDefinition("sysDescr", 1, 64)};

    public static byte[] getSystemConfigRequest() {
        SimpleSubCommand simpleSubCommand = new SimpleSubCommand(48, 516);
        return simpleSubCommand.getBytes();
    }

    public SystemConfig(byte[] byArray) {
        super(ret);
        this.block.useData(byArray);
    }

    public long getSysUpTime() {
        return this.block.getVariableValue("sysUpTime");
    }

    public String getSysDescr() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 64) {
            int n2 = (int)this.block.getVariableValue("sysDescr", n);
            if (n2 == 0) break;
            stringBuffer.append((char)n2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("System Uptime: ");
        stringBuffer.append(this.getSysUpTime() + "s" + "\n");
        stringBuffer.append("System Description: ");
        stringBuffer.append(this.getSysDescr() + "\n");
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            SystemConfig systemConfig = new SystemConfig(byArray);
            this.assertNotNull(systemConfig);
        }
    }
}

