/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.DataBlock;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxHeader;
import com.sun.jade.device.fcswitch.ancor.sanbox.VariableDefinition;
import com.sun.jade.util.unittest.UnitTest;

public class PortSteering
extends SanboxHeader {
    private static final String sccs_id = "@(#)PortSteering.java\t1.3 10/08/01 SMI";
    public static final int MAX_PORTS = 16;
    public static final int MAX_COUNT = 64;
    private static final int PORT_COMMAND = 48;
    private static final int STATE_SUB_COMMAND = 125;
    private static VariableDefinition[] req = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("port_num", 1), new VariableDefinition("reserved", 1, 3)};
    private static VariableDefinition[] ret = new VariableDefinition[]{new VariableDefinition("sub_cmd", 4), new VariableDefinition("port_num", 1), new VariableDefinition("num_of_port", 1), new VariableDefinition("reserved", 1, 2), new VariableDefinition("port_dest_valid", 1, 64), new VariableDefinition("chassis_dest_valid", 1, 64), new VariableDefinition("chassis_dest_port", 1, 64), new VariableDefinition("chksum", 4)};

    public static byte[] getPortSteeringRequest(int n) {
        SanboxHeader sanboxHeader = new SanboxHeader(req);
        sanboxHeader.setCommand(48);
        DataBlock dataBlock = sanboxHeader.getBlock();
        dataBlock.setVariable("sub_cmd", 125L);
        dataBlock.setVariable("port_num", n);
        return sanboxHeader.getBytes();
    }

    public PortSteering(byte[] byArray) {
        super(ret);
        this.block.useData(byArray);
    }

    public int getPortNum() {
        return (int)this.block.getVariableValue("port_num");
    }

    public int getNumOfPort() {
        return (int)this.block.getVariableValue("num_of_port");
    }

    public int[] getPortDestValid() {
        int[] nArray = new int[64];
        int n = 0;
        while (n < 64) {
            nArray[n] = (int)this.block.getVariableValue("port_dest_valid", n);
            ++n;
        }
        return nArray;
    }

    public int[] getChassisDestValid() {
        int[] nArray = new int[64];
        int n = 0;
        while (n < 64) {
            nArray[n] = (int)this.block.getVariableValue("chassis_dest_valid", n);
            ++n;
        }
        return nArray;
    }

    public int[] getChassisDestPort() {
        int[] nArray = new int[64];
        int n = 0;
        while (n < 64) {
            nArray[n] = (int)this.block.getVariableValue("chassis_dest_port", n);
            ++n;
        }
        return nArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Port ");
        stringBuffer.append(this.getPortNum() + 1);
        stringBuffer.append(" of " + this.getNumOfPort());
        stringBuffer.append("\n");
        stringBuffer.append("#    port_dest_valid    chassis_dest_valid    chassis_dest_port");
        stringBuffer.append("\n");
        int n = 0;
        while (n < 64) {
            stringBuffer.append(n + 1 + "               " + this.getPortDestValid()[n] + "               " + this.getChassisDestValid()[n] + "               " + (this.getChassisDestPort()[n] + 1));
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static class Test
    extends UnitTest {
        public void test() {
            byte[] byArray = new byte[100];
            int n = 0;
            while (n < 100) {
                byArray[n] = (byte)n;
                ++n;
            }
            PortSteering portSteering = new PortSteering(byArray);
            this.assertNotNull(portSteering);
        }
    }
}

