/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.sanbox;

import com.sun.jade.device.fcswitch.ancor.sanbox.AlPortStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.ChassisStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Initiators;
import com.sun.jade.device.fcswitch.ancor.sanbox.NameServerNode;
import com.sun.jade.device.fcswitch.ancor.sanbox.NameServerPort;
import com.sun.jade.device.fcswitch.ancor.sanbox.NetConfig;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortCounts;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortState;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortSteering;
import com.sun.jade.device.fcswitch.ancor.sanbox.ResetLog;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.device.fcswitch.ancor.sanbox.TestStatus;
import com.sun.jade.device.fcswitch.ancor.sanbox.Topology;
import com.sun.jade.util.unittest.UnitTest;
import java.net.InetAddress;

public class CLI {
    public static boolean debug = true;
    public static final int ERROR = -1;

    public static void usage(int n) {
        CLI.usage();
        System.exit(n);
    }

    public static void usage() {
        System.out.println("Usage: ");
        System.out.println("version        <ip-address>");
        System.out.println("start_test     <ip-address> <port> [ size length pattern ]");
        System.out.println("test_status    <ip-address> <port>");
        System.out.println("stop_test      <ip-address> <port>");
        System.out.println("port_counts    <ip-address> <port>");
        System.out.println("port_status    <ip-address> <port>");
        System.out.println("initiators     <ip-address>");
        System.out.println("chassis_status <ip-address>");
    }

    public static void run(String[] stringArray) throws Exception {
        block38: {
            Sanbox sanbox;
            int n;
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block37: {
                                    Object object;
                                    String string = null;
                                    String string2 = null;
                                    String string3 = null;
                                    n = 0;
                                    while (n < stringArray.length) {
                                        object = stringArray[n];
                                        if (!((String)object).startsWith("-") || ((String)object).equals("-")) break;
                                        if (((String)object).equals("-f")) {
                                            string = stringArray[++n];
                                        } else if (((String)object).equals("-p")) {
                                            string2 = stringArray[++n];
                                        } else if (((String)object).equals("-u")) {
                                            string3 = stringArray[++n];
                                        }
                                        ++n;
                                    }
                                    if (n >= stringArray.length) {
                                        CLI.usage();
                                        System.exit(-1);
                                    }
                                    object = InetAddress.getByName(stringArray[n + 1]);
                                    sanbox = new Sanbox((InetAddress)object);
                                    System.out.println("IP:     " + sanbox.getHost().getHostAddress());
                                    if (!stringArray[n].equals("version")) break block37;
                                    SanboxVersion sanboxVersion = sanbox.getVersion();
                                    System.out.print(sanboxVersion);
                                    break block38;
                                }
                                if (!stringArray[n].equals("start_test")) break block39;
                                Integer n2 = new Integer(0);
                                Integer n3 = new Integer(2000);
                                Integer n4 = new Integer(1000);
                                Integer n5 = new Integer(0x7E7E7E7E);
                                if (stringArray.length < 3) {
                                    CLI.usage(-1);
                                }
                                n2 = new Integer(stringArray[n + 2]);
                                if (stringArray.length == 5) {
                                    n3 = new Integer(stringArray[n + 2]);
                                    n4 = new Integer(stringArray[n + 3]);
                                    n5 = new Integer(stringArray[n + 4]);
                                }
                                sanbox.startTest(n2 + 1, n3, n4, n5, false);
                                break block38;
                            }
                            if (!stringArray[n].equals("test_status")) break block40;
                            if (stringArray.length >= 3) {
                                Integer n6 = new Integer(stringArray[n + 2]);
                                int n7 = n6 - 1;
                                TestStatus testStatus = sanbox.getTestStatus();
                                System.out.println("-------------- p=" + n7);
                                System.out.println("test_fail_cnt:          " + testStatus.getTestFailCount());
                                System.out.println("port_test_status:       " + testStatus.getPortTestStatus(n7));
                                System.out.println("port_test_count:        " + testStatus.getPortTestCount(n7));
                                System.out.println("port_fail_count:        " + testStatus.getPortFailCount(n7));
                            } else {
                                CLI.usage(-1);
                            }
                            break block38;
                        }
                        if (!stringArray[n].equals("stop_test")) break block41;
                        sanbox.abortTest();
                        break block38;
                    }
                    if (!stringArray[n].equals("port_counts")) break block42;
                    Integer n8 = new Integer(stringArray[n + 2]);
                    System.out.println("PORTCOUNTS on port: " + n8);
                    PortCounts portCounts = sanbox.getPortCounts(n8 - 1);
                    System.out.println(portCounts.getBlock());
                    break block38;
                }
                if (!stringArray[n].equals("port_status")) break block43;
                Integer n9 = new Integer(stringArray[n + 2]);
                int n10 = n9 - 1;
                PortState portState = sanbox.getPortState(n10);
                System.out.println("Port Number = " + n9);
                System.out.println("Port Type   = " + portState.getPortTypeString());
                System.out.println("Port Mode   = " + portState.getOperationalStateString());
                if (2 == portState.getOperationalState()) {
                    System.out.println("Port is Offline.");
                    return;
                }
                if (!portState.getLoggedIn()) {
                    System.out.println("Not logged in.");
                    return;
                }
                SanboxVersion sanboxVersion = sanbox.getVersion();
                AlPortStatus alPortStatus = null;
                Initiators initiators = null;
                NameServerPort nameServerPort = null;
                NameServerNode nameServerNode = null;
                switch (portState.getPortType()) {
                    case 3: {
                        Topology topology = sanbox.getTopology();
                        System.out.println("top=" + topology);
                        int n11 = topology.getLinkPortAddr(n10);
                        System.out.println("FC: " + Integer.toHexString(n11));
                        sanbox.setRemoteAddr(n11);
                        SanboxVersion sanboxVersion2 = sanbox.getVersion();
                        NetConfig netConfig = sanbox.getNetConfig();
                        int n12 = netConfig.getNetAddress();
                        long l = sanboxVersion2.getWorldWideName();
                        sanbox.setLocalAddr();
                        System.out.println("T_Port Linked-to: " + Integer.toHexString((int)(l >> 32)) + Integer.toHexString((int)l) + " IP: " + Integer.toString(n12 >>> 24) + "." + Integer.toString(n12 >> 16 & 0xFF) + "." + Integer.toString(n12 >> 8 & 0xFF) + "." + Integer.toString(n12 & 0xFF));
                        break;
                    }
                    case 4: {
                        alPortStatus = sanbox.getAlPortStatus(n10);
                        initiators = sanbox.getInitiators(0);
                        System.out.println("Devices = " + alPortStatus.getPortEntryCount());
                        System.out.println("Address = 0x" + Integer.toHexString(alPortStatus.getSwitchAlpa()));
                        int n13 = initiators.getNumInitiators();
                        int n14 = 0;
                        while (n14 < n13) {
                            if (n10 == initiators.getPortNum(n14)) {
                                long l = initiators.getPortName(n14);
                                System.out.println("Port WWN: " + Integer.toHexString((int)(l >> 32)) + Integer.toHexString((int)l));
                                l = initiators.getNodeName(n14);
                                System.out.println("Node WWN: " + Integer.toHexString((int)(l >> 32)) + Integer.toHexString((int)l));
                            }
                            ++n14;
                        }
                        break block38;
                    }
                    case 1: {
                        int n15 = (int)sanboxVersion.getModuleAddr();
                        nameServerPort = sanbox.getNameServerPort(n10, n15, 0);
                        nameServerNode = sanbox.getNameServerNode(n10, n15, 0);
                        long l = nameServerPort.getWorldWideName();
                        System.out.println("Port WWN: " + Integer.toHexString((int)(l >> 32)) + Integer.toHexString((int)l));
                        l = nameServerNode.getWorldWideName();
                        System.out.println("Node WWN: " + Integer.toHexString((int)(l >> 32)) + Integer.toHexString((int)l));
                        break;
                    }
                    case 2: 
                    case 5: {
                        alPortStatus = sanbox.getAlPortStatus(n10);
                        int n16 = alPortStatus.getFirstPortAddr();
                        int n17 = alPortStatus.getPortEntryCount();
                        System.out.println("Devices = " + n17);
                        System.out.println("Switch AL_PA = 0x" + Integer.toHexString(alPortStatus.getSwitchAlpa()));
                        int n18 = 0;
                        while (n18 < n17) {
                            int n19 = alPortStatus.getDeviceAlpa(n18);
                            nameServerPort = sanbox.getNameServerPort(n10, n16, n19);
                            nameServerNode = sanbox.getNameServerNode(n10, n16, n19);
                            long l = nameServerPort.getWorldWideName();
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("AL_PA:");
                            stringBuffer.append(Integer.toHexString(n19));
                            stringBuffer.append("   Port WWN:");
                            stringBuffer.append(Integer.toHexString((int)(l >> 32)));
                            stringBuffer.append(Integer.toHexString((int)l));
                            l = nameServerNode.getWorldWideName();
                            stringBuffer.append("   Node WWN:");
                            stringBuffer.append(Integer.toHexString((int)(l >> 32)));
                            stringBuffer.append(Integer.toHexString((int)l));
                            System.out.println(stringBuffer.toString());
                            ++n18;
                        }
                        break block38;
                    }
                    default: {
                        System.out.println("Unsupported state " + portState.getOperationalState());
                        break;
                    }
                }
                break block38;
            }
            if (stringArray[n].equals("port_steering")) {
                Integer n20 = new Integer(stringArray[n + 2]);
                PortSteering portSteering = sanbox.getPortSteering(n20 - 1);
                System.out.println(portSteering.getBlock());
            } else if (stringArray[n].equals("initiators")) {
                Initiators initiators = sanbox.getInitiators(0);
                System.out.println(initiators.getBlock());
            } else if (stringArray[n].equals("chassis_status")) {
                ChassisStatus chassisStatus = sanbox.getChassisStatus(0);
                System.out.println(chassisStatus.getBlock());
            } else if (stringArray[n].equals("reset_log")) {
                ResetLog resetLog = sanbox.getResetLog(0);
                System.out.println(resetLog.getBlock());
            } else if (stringArray[n].equals("report")) {
                System.out.println(sanbox.getReport());
            } else if (stringArray[n].equals("wwn_zone")) {
                System.out.println(sanbox.getWWNZone());
            } else if (stringArray[n].equals("links")) {
                Topology topology = sanbox.getTopology();
                System.out.println("First Port\t" + topology.getFirstPort());
                System.out.println("Total Ports\t" + topology.getTotalPorts());
                System.out.println("Chassin Num\t" + topology.getRprtChassisNum());
                System.out.println("Stage Type\t" + topology.getRprtStageType());
                System.out.println("Port 0 Addr\t" + topology.getRprtPort0Addr());
                int n21 = 0;
                while (n21 < 12) {
                    System.out.println("Port " + n21 + "\t" + topology.getLinkPortAddr(n21));
                    ++n21;
                }
            } else {
                CLI.usage();
            }
        }
    }

    public static void main(String[] stringArray) {
        block3: {
            if (stringArray.length < 2) {
                CLI.usage();
                System.exit(1);
            }
            try {
                CLI.run(stringArray);
            }
            catch (Exception exception) {
                System.out.println("Error " + exception);
                if (!debug) break block3;
                exception.printStackTrace();
            }
        }
    }

    public static class Test
    extends UnitTest {
        public void test() {
            CLI cLI = new CLI();
            this.assertNotNull(cLI);
        }
    }
}

