/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.ancor.diag;

import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.fcswitch.ancor.diag.AncorLoopbackTest;
import com.sun.jade.device.fcswitch.ancor.diag.Messages;
import com.sun.jade.device.fcswitch.ancor.sanbox.PortCounts;
import com.sun.jade.device.fcswitch.ancor.sanbox.Sanbox;
import com.sun.jade.device.fcswitch.ancor.sanbox.SanboxVersion;
import com.sun.jade.device.fcswitch.ancor.sanbox.TestStatus;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import javax.wbem.cim.CIMDateTime;

public class AncorLoopbackTestExecutable
extends TestExecutableImpl {
    private static final Localizer msgs = Messages.getLocalizer();
    private static final int POLL_INTERVAL = 5000;
    private DiagnosticResult result;
    private boolean abort;
    private boolean isRunning;
    private boolean isTesting;
    private int xferSize = 2000;
    private int numberOfPasses = 10000;
    private int testPattern = 0;
    private int patternType = 0;
    private int numTests;
    private int testsComplete;
    private int testPercent;
    private int errorsDetected;
    private Sanbox sanbox;
    private InetAddress hostAddress;
    private int portNum;
    private TestStatus testStatus;
    private PortCounts portCounts;
    private static final String sccs_id = "@(#)AncorLoopbackTestExecutable.java\t1.12 05/08/03 SMI";

    public AncorLoopbackTestExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
        Report.debug.enableLogging();
        Report.debug.log((Object)("\nnew AncorLoopbackTestExecutable: mse     =" + referenceForMSE));
        Report.debug.log((Object)("\nnew AncorLoopbackTestExecutable: setting =" + diagnosticSetting));
    }

    public ReferenceForMSE getExclusiveMSE() {
        return new ReferenceForMSE(this.mse.getSystemClassName(), this.mse.getSystemName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        block31: {
            block29: {
                this.isRunning = true;
                this.result = diagnosticResult;
                this.testsComplete = 0;
                this.testPercent = 0;
                this.errorsDetected = 0;
                try {
                    try {
                        if (!this.parseLocalSettings()) {
                            Object var5_2 = null;
                            this.isRunning = false;
                            this.cleanUp();
                            break block29;
                        }
                        if (this.patternType == 0) {
                            this.numTests = AncorLoopbackTest.criticalMap.length;
                            Report.debug.log((Object)("numPatterns=" + AncorLoopbackTest.criticalMap.length));
                        } else if (this.patternType == 1) {
                            this.numTests = 1;
                        } else if (this.patternType == 2) {
                            this.numTests = AncorLoopbackTest.allPatternsMap.length;
                            Report.debug.log((Object)("numPatterns=" + AncorLoopbackTest.allPatternsMap.length));
                        }
                        diagnosticResult.setTestStartTime(new CIMDateTime());
                        diagnosticResult.setTestState(TestState.IN_PROGRESS);
                        diagnosticResult.setEstimatedTimeOfPerforming(this.numberOfPasses / 10000 * this.xferSize / 100 * this.numTests);
                        diagnosticResult.setPercentComplete((short)0);
                        if (this.reportStatus) {
                            if (this.patternType != 1) {
                                this.setting.setTestParameter("UserPattern", "0x00000000");
                            }
                            diagnosticResult.addTestResults(msgs.getFormattedString("test.settings", (Object)("\n" + this.setting.getTestParameter("TestWarningLevel") + "\n" + this.setting.getTestParameter("ReportSoftErrors") + "\n" + this.setting.getTestParameter("ReportStatusMessages") + "\n" + this.setting.getTestParameter("HaltOnError") + "\n" + this.setting.getTestParameter("TransferSize") + "\n" + this.setting.getTestParameter("NumberOfPasses") + "\n" + this.setting.getTestParameter("PatternType") + "\n" + this.setting.getTestParameter("UserPattern"))));
                        }
                        this.sanbox = new Sanbox(this.hostAddress);
                        SanboxVersion sanboxVersion = this.sanbox.getVersion();
                        this.testStatus = this.sanbox.getTestStatus();
                        if (this.numTests > 1 && this.patternType == 0) {
                            int n = 0;
                            while (n < this.numTests) {
                                if (this.reportStatus) {
                                    diagnosticResult.addTestResults(msgs.getFormattedString("test.msg.patternMessage", (Object)("0x" + Integer.toHexString(AncorLoopbackTest.criticalMap[n]))));
                                    diagnosticResult.update();
                                }
                                Report.debug.log((Object)("Running Test " + n + " with pattern " + "0x" + Integer.toHexString(AncorLoopbackTest.criticalMap[n])));
                                this.runTest(AncorLoopbackTest.criticalMap[n]);
                                if (!this.abort) {
                                    ++n;
                                    continue;
                                }
                                break;
                            }
                        } else if (this.numTests > 1 && this.patternType == 2) {
                            int n = 0;
                            while (n < this.numTests) {
                                if (this.reportStatus) {
                                    diagnosticResult.addTestResults(msgs.getFormattedString("test.msg.patternMessage", (Object)("0x" + Integer.toHexString(AncorLoopbackTest.allPatternsMap[n]))));
                                    diagnosticResult.update();
                                }
                                Report.debug.log((Object)("Running Test " + n + " with pattern " + "0x" + Integer.toHexString(AncorLoopbackTest.allPatternsMap[n])));
                                this.runTest(AncorLoopbackTest.allPatternsMap[n]);
                                if (!this.abort) {
                                    ++n;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            if (this.reportStatus) {
                                String string = (String)this.setting.getTestParameter("UserPattern").getCurrentValue();
                                diagnosticResult.addTestResults(msgs.getFormattedString("test.msg.patternMessage", (Object)string));
                                diagnosticResult.update();
                            }
                            Report.debug.log((Object)("***pattern passed to runTest:" + this.testPattern));
                            this.runTest(this.testPattern);
                        }
                        if (this.errorsDetected > 0) {
                            String string = msgs.getFormattedString("loopback.countsfail", (Object)new Integer(this.errorsDetected), (Object)new Integer(this.portNum + 1));
                            if (!this.abort) {
                                diagnosticResult.addTestResults(msgs.getString("test.msg.stoped"));
                            }
                            diagnosticResult.setFinalResults(TestState.FAILED, string);
                            break block31;
                        }
                        if (!this.abort) {
                            diagnosticResult.setFinalResults(TestState.PASSED, msgs.getString("test.passed"));
                            diagnosticResult.setFinalResults(TestState.PASSED);
                            break block31;
                        } else {
                            diagnosticResult.setFinalResults(TestState.STOPPED, msgs.getString("test.msg.stopedNoErrorsFound"));
                        }
                        break block31;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        Report.error.log((Object)exception);
                        if (this.reportErrors) {
                            diagnosticResult.addTestResults(exception.getLocalizedMessage());
                        }
                        diagnosticResult.setFinalResults(TestState.FAILED);
                        Object var5_4 = null;
                        this.isRunning = false;
                        this.cleanUp();
                        this.abort = false;
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.isRunning = false;
                    this.cleanUp();
                    this.abort = false;
                    throw throwable;
                }
            }
            this.abort = false;
            return;
        }
        Object var5_3 = null;
        this.isRunning = false;
        this.cleanUp();
        this.abort = false;
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        if (!this.isRunning || this.abort) {
            return false;
        }
        this.abort = true;
        ((Object)((Object)this)).notify();
        return true;
    }

    private boolean parseLocalSettings() throws Exception {
        String string;
        super.parseSettings();
        TestParameter testParameter = this.setting.getTestParameter("TransferSize");
        if (testParameter != null) {
            string = (String)testParameter.getCurrentValue();
            this.xferSize = Integer.parseInt(string);
        }
        if ((testParameter = this.setting.getTestParameter("NumberOfPasses")) != null) {
            string = (String)testParameter.getCurrentValue();
            this.numberOfPasses = Integer.parseInt(string);
        }
        testParameter = this.setting.getTestParameter("PatternType");
        int n = 0;
        if (testParameter != null) {
            n = testParameter.choiceValue(n);
        }
        if (n == 1 && (testParameter = this.setting.getTestParameter("UserPattern")) != null) {
            String string2 = (String)testParameter.getCurrentValue();
            if (string2.startsWith("0x")) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer = stringBuffer.delete(0, 2);
                String string3 = stringBuffer.toString();
                try {
                    this.testPattern = (int)Long.parseLong(string3, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    Report.error.log((Object)numberFormatException);
                    this.result.addTestResults(msgs.getString("test.msg.invalidPatternCause"));
                    this.result.addTestResults(msgs.getString("test.msg.invalidPatternAction"));
                    this.result.setFinalResults(TestState.FAILED);
                    return false;
                }
            }
            try {
                this.testPattern = (int)Long.parseLong(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                Report.error.log((Object)numberFormatException);
                this.result.addTestResults(msgs.getString("test.msg.invalidPatternCause"));
                this.result.addTestResults(msgs.getString("test.msg.invalidPatternAction"));
                this.result.setFinalResults(TestState.FAILED);
                return false;
            }
            Report.debug.log((Object)("User testPattern=" + this.testPattern));
        }
        this.patternType = n;
        Report.debug.log((Object)("patternType=" + this.patternType));
        Report.debug.log("AncorLoopBackTestExecutable", (Object)("Loopback test mse = " + this.mse.getCIMObjectPath()));
        Report.debug.log("AncorLoopBackTestExecutable", (Object)("System Name = " + this.mse.getSystemName()));
        this.hostAddress = InetAddress.getByName(DiagUtil.getIP((ReferenceForMSE)this.mse));
        this.portNum = Integer.parseInt(this.mse.getKeyValue()) - 1;
        return true;
    }

    private void runTest(int n) throws DiagnosticException {
        Report.trace.log((Object)("runTest pattern=" + n));
        if (this.startTest(n)) {
            this.waitForResult(n);
            this.completeTest();
        }
        Report.trace.log((Object)"Test finished");
    }

    private synchronized boolean startTest(int n) throws DiagnosticException {
        if (this.abort) {
            return false;
        }
        this.sanbox.startTest(this.portNum, this.xferSize, this.numberOfPasses, n, false);
        this.isTesting = true;
        return true;
    }

    private synchronized void completeTest() {
        ++this.testsComplete;
        this.isTesting = false;
    }

    private synchronized boolean waitForResult(int n) throws DiagnosticException {
        if (this.abort) {
            return false;
        }
        long l = this.testStatus.getPortTestCount(this.portNum);
        long l2 = this.numberOfPasses * this.numTests;
        long l3 = 0L;
        long l4 = this.testStatus.getPortFailCount(this.portNum);
        long l5 = this.testStatus.getTestFailCount();
        Report.debug.log((Object)("numTests=" + this.numTests));
        Report.debug.log((Object)("testsComplete=" + this.testsComplete));
        do {
            try {
                ((Object)((Object)this)).wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.abort) {
                return false;
            }
            TestStatus testStatus = this.sanbox.getTestStatus();
            long l6 = testStatus.getTestFailCount();
            long l7 = testStatus.getPortFailCount(this.portNum);
            Report.debug.log((Object)("Errors portFailCount = " + l7));
            if (l7 - l4 > 0L || l6 - l5 > 0L) {
                if (this.haltOnError) {
                    String string = msgs.getFormattedString("loopback.count.fail", (Object)new Integer(this.portNum + 1));
                    throw new DiagnosticException(string);
                }
                this.errorsDetected = (int)l6 - (int)l5;
            }
            long l8 = testStatus.getPortTestCount(this.portNum) - l;
            l3 = l8 - (long)(this.testsComplete * this.numberOfPasses);
            Report.debug.log((Object)("packetsReceived = " + l3));
            if (l3 == 0L) {
                throw new DiagnosticException(msgs.getString("loopback.start.failed"));
            }
            long l9 = l8 / (l2 / 100L);
            this.result.setPercentComplete((short)l9);
        } while (l3 < (long)this.numberOfPasses);
        return true;
    }

    private boolean cleanUp() {
        Report.trace.log((Object)"cleanUp");
        if (!this.isTesting) {
            return true;
        }
        this.isTesting = false;
        try {
            this.sanbox.abortTest();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

