/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.model.cim.recipes.array;

import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareID;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.HardwareIDManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.MaskingCapabilities;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.PrivilegeManagementService;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.StorageSystem;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.array.Volume;
import com.sun.netstorage.mgmt.esm.model.cim.ingredients.common.Privilege;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.AccessRecipe;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Contract;
import com.sun.netstorage.mgmt.esm.model.cim.recipes.array.Localization;

public class RemoveAccessRecipe
extends AccessRecipe {
    private static final String SCCS_ID = "@(#)RemoveAccessRecipe.java 1.5   03/09/08 SMI";
    public static final String NO_PRIVILEGE_FOUND = "In the storage system ({0}), the privilege was not found between the volume ({1}) and the initiator ({2}).";
    private StorageSystem myStorageSystem;
    private String myInitiator;

    public RemoveAccessRecipe(StorageSystem storageSystem, Volume volume, String string) {
        super(storageSystem, volume);
        this.init(storageSystem, string);
    }

    public RemoveAccessRecipe(StorageSystem storageSystem, String string, String string2) {
        super(storageSystem, string);
        this.init(storageSystem, string2);
    }

    public void init(StorageSystem storageSystem, String string) {
        Contract.requires((storageSystem != null ? 1 : 0) != 0, (String)"theStorageSystem != null");
        Contract.requires((string != null ? 1 : 0) != 0, (String)"theInitiator != null");
        this.myStorageSystem = storageSystem;
        this.myInitiator = string;
    }

    protected void cookRecipe() {
        this.traceStep(1, "Find the CIM Object Path to the initiator.");
        HardwareIDManagementService hardwareIDManagementService = this.myStorageSystem.getHardwareIDManagementService();
        HardwareID hardwareID = hardwareIDManagementService.getHardwareID(this.myInitiator);
        if (hardwareID == null) {
            this.failInvalidInitiator(this.myInitiator);
        }
        this.traceStep(2, "Get the authorization service and determine the capabilities.");
        PrivilegeManagementService privilegeManagementService = this.myStorageSystem.getPrivilegeManagementService();
        MaskingCapabilities maskingCapabilities = this.myStorageSystem.getMaskingCapabilities();
        this.traceStep(3, "Find the Privilege object associated from this volume to the initiator.");
        Privilege privilege = null;
        Privilege[] privilegeArray = this.getVolume().getPrivileges();
        int n = 0;
        while (n < privilegeArray.length) {
            HardwareID hardwareID2 = privilegeArray[n].getHardwareID();
            if (hardwareID2 != null && hardwareID2.equals(hardwareID)) {
                privilege = privilegeArray[n];
            }
            ++n;
        }
        if (privilege == null) {
            this.failNoPrivilegeFound(this.getVolume(), hardwareID);
        }
        this.traceStep(4, "Remove access for that initiator.");
        privilegeManagementService.RemoveAccess(hardwareID, privilege, this.getVolume());
    }

    protected final void failNoPrivilegeFound(Volume volume, HardwareID hardwareID) {
        String[] stringArray = new String[]{this.getStorageSystem().getName(), volume.getName(), hardwareID.getStorageID()};
        this.failRecipe(Localization.RES_NO_PRIVILEGE_FOUND, stringArray);
    }
}

